/**
 * PowerDBJ
 * create date 2006/09/21
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export;

import jp.co.powerbeans.eclipse.plugin.powerdbj.export.excel.TableDefExcelExporter;
import jp.co.powerbeans.eclipse.plugin.powerdbj.export.html.TableDefContentsHtmlExporter;
import jp.co.powerbeans.eclipse.plugin.powerdbj.export.html.TableDefHtmlExporter;
import jp.co.powerbeans.eclipse.plugin.powerdbj.export.java.PowerQLDAOJavaExporter;
import jp.co.powerbeans.eclipse.plugin.powerdbj.export.java.TableModelJavaExporter;

/**
 * ExporterFactory
 * @author amonden
 * @create date 2006/09/21
 */
public class ExporterFactory {

	private static final Class[] EXPORTER_IMPLS = {
		TableDefHtmlExporter.class,
    TableDefContentsHtmlExporter.class,
    TableDefExcelExporter.class,
    TableModelJavaExporter.class,
    PowerQLDAOJavaExporter.class,
	};
	
	/**
	 * @param exportType
	 * @return
	 */
	public static Exporter getExporter(int exportType) {
		Class cls = EXPORTER_IMPLS[exportType];
		try {
			return (Exporter) cls.newInstance();
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

}
