# prime/engine/engine-basic.rb
# $Id: engine-basic.rb,v 1.4 2004/12/09 12:24:15 komatsu Exp $
#
# Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine-sary'

$engine_class_name = 'PrimeEngineBasic'

class PrimeEngineBasic < PrimeEngineSary
  def initialize(dictname = 'prime-dict')
    @dictname = dictname
    dict_file = File::join2(PRIME_DICT_DIR, @dictname)
    super(dict_file)

    @name = "Basic engine"
    @id   = "basic"
    @description = "Basic engine"
  end

  def initialize_dict ()
    @dict         = Sary::Searcher.new(@dict_file)
    @dict_literal = Sary::Searcher.new(@dict_file, @dict_file + "_literal.ary")

    file_posdict  = File::join2(PRIME_DICT_DIR, @dictname + '-pos')
    file_partdict = File::join2(PRIME_DICT_DIR, @dictname + '-part')
    if File::exist?(file_posdict) then
      if File::exist?(file_partdict) then
        $stderr.puts("PRIME Warning:")
        $stderr.puts("    Both prime-dict-pos and prime-dict-part exist")
        $stderr.puts("    under '#{PRIME_DICT_DIR}'.")
        $stderr.puts("    The file name 'prime-dict-part' is obsolete.")
      end
      @partdict_file = file_posdict
    elsif File::exist?(file_partdict) then
      @partdict_file = file_partdict
    else
      $stderr.puts("PRIME ERROR:")
      $stderr.puts("    The POS dictionary #{file_posdict} is not found.")
      $stderr.puts("    Please install the latest prime-dict package.")
      Kernel::exit()
    end
    @partdict = Sary::Searcher.new(@partdict_file)
  end
end

