;;;; prime-init.el: initialize prime-el
;;;; $Id: prime-init.el,v 1.7 2004/01/14 19:51:27 komatsu Exp $
;;;; 
;;;; Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
;;;;     All rights reserved.
;;;;     This is free software with ABSOLUTELY NO WARRANTY.
;;;; 
;;;; You can redistribute it and/or modify it under the terms of 
;;;; the GNU General Public License version 2.

(require 'poe);; in APEL
(require 'font-lock nil t)
(require 'mell)
(require 'mell-file)
(require 'mell-event)
(require 'mell-string)
(require 'prime-main)
(require 'prime-fund-mode)
(require 'prime-conv-mode)
(require 'prime-input-mode)
(require 'prime-enum-mode)
(require 'prime-style)
(require 'prime-socialite)
(require 'prime-log)
(require 'prime-suikyo)

(defun prime-init (&optional forcep)
  (prime-init-load-file)
  (prime-keymap-init forcep)
  (prime-mode-init forcep)
  (prime-server-init forcep)
  (prime-suikyo-init forcep)
  (prime-style-init prime-style)

  (run-hooks 'prime-init-hook)
  )

(defun prime-init-load-file (&optional init-file)
  (or (mell-file-load-file prime-init-config-file)
      (error (format "Configuration file '%s' does not exist!"
		     prime-init-config-file)))

  (let ((init-dir (or (getenv "PRIME_USER_DIR")
		      (concat (getenv "HOME") "/.prime"))))
    (or init-file
	(setq init-file (concat init-dir "/Custom_prime-el.el")))
    (if (file-exists-p init-file)
	(mell-file-load-file init-file)
      (make-directory init-dir t)
      (copy-file prime-init-config-file init-file))
    ))

;; ------------------------------------------------------------

;; $B%-!<%^%C%W$N@_Dj(B
(defvar prime-fund-mode-map   nil "PRIME$B%b!<%I$N%-!<%^%C%W(B")
(defvar prime-input-mode-map  nil "$B%Q%?%sF~NOCf$N%-!<%^%C%W(B")
(defvar prime-conv-mode-map   nil "$B8uJdA*BrCf$N%-!<%^%C%W(B")
(defvar prime-cand-mode-map   nil "$B8uJd0lMwA*Br$N%-!<%^%C%W(B")
(defvar prime-narrow-mode-map nil "$B8uJd$N(B AND $B8!:wCf$N%-!<%^%C%W(B")

(defun prime-keymap-init (&optional forcep)
  (or (or prime-fund-mode-map forcep)
      (let ((map (make-sparse-keymap)))
	(substitute-key-definition
	 'self-insert-command 'prime-fund-keyin map global-map)
	(substitute-key-definition 'undo 
				   'prime-undo map global-map)
;	(define-key map prime-toggle-key 'prime-mode)
;	(define-key map " "     nil)
	(define-key map " "     'prime-fund-convert-region)
	(define-key map "\C-cw" 'prime-register)
	(define-key map "\C-cc" 'prime-language-toggle)
	(define-key map "\C-ce" 'prime-engine-select)
	(define-key map "\M-\[" 'prime-fund-insparens-insert-parens)
	(define-key map "\M-\]" 'prime-fund-insparens-insert-parens-reverse)
	(setq prime-fund-mode-map map)))
  ;; $BF~NOCf$N%-!<%^%C%W$N@_Dj(B
  (or (or prime-input-mode-map forcep)
;      (let ((map (prime-make-keymap 'undefined)))
      (let ((map (prime-make-keymap 'prime-undefined)))
	(substitute-key-definition 'prime-mode 
				   'prime-mode map global-map)
	(substitute-key-definition 'undo 
				   'prime-undo map global-map)
	(substitute-key-definition 'self-insert-command
				   'prime-keyin map global-map)
	(define-key map " " 'prime-conv-next)
	(substitute-key-definition 'forward-char-command
				   'prime-input-forward-char map global-map)
	(substitute-key-definition 'backward-char-command 
				   'prime-input-backward-char map global-map)
	(define-key map "\C-f" 'prime-input-forward-char)    ; $BK\Ev$O$$$i$J$$(B
	(define-key map "\C-b" 'prime-input-backward-char)   ; $BK\Ev$O$$$i$J$$(B
	(substitute-key-definition 'beginning-of-line
				   'prime-input-beginning-of-pattern
				   map global-map)
	(substitute-key-definition 'end-of-line
				   'prime-input-end-of-pattern map global-map)
	(substitute-key-definition 'delete-backward-char 
				   'prime-input-delete-backward-char
				   map global-map)
	(substitute-key-definition 'delete-char
				   'prime-input-delete-char map global-map)
	(substitute-key-definition 'universal-argument
				   'prime-enum-mode map global-map)
	(substitute-key-definition 'transpose-chars
				   'prime-input-transpose-chars map global-map)

;	(define-key map prime-toggle-key 'prime-mode)
	(define-key map "\C-w" 'prime-register-word)
	(define-key map "\C-m" 'prime-conv-decide)
	(define-key map [return] 'prime-conv-decide)
	(define-key map "\C-g" 'prime-conv-cancel)
	(define-key map "\C-l" 'prime-conv-cand-list)
	(define-key map "\C- " 'prime-space)
	(define-key map "\M- " 'prime-space)
;	(define-key map "\177" 'prime-undo)
	(define-key map "\C-k" 'prime-conv-katakana)
	(define-key map "\M-k" 'prime-conv-katakana)
	(define-key map "\M-h" 'prime-conv-hiragana)
	(define-key map "\M-l" 'prime-conv-ascii)
	(define-key map "\C-s" 'prime-narrow-mode)
	(define-key map "\C-cc" 'prime-language-toggle)
	(define-key map "\C-ce" 'prime-engine-select)
	(define-key map [muhenkan]          'prime-conv-hiragana-without-learn)
	(define-key map [henkan-mode]       'prime-conv-decide)
	(define-key map [hiragana-katakana] 'prime-conv-katakana)
	(define-key map [f6]                'prime-conv-hiragana)
	(define-key map [f7]                'prime-conv-katakana)
	(define-key map [f10]               'prime-conv-ascii)
	(if (featurep 'xemacs)
	    (define-key map '(control ?.) 'prime-conv-exact)
	  (define-key map [?\^.] 'prime-conv-exact))
	(setq prime-input-mode-map map)
	))

  ;; $BJQ49Cf$N%-!<%^%C%W$N@_Dj(B (prime-input-mode-map $B$r7Q>5(B)
  (or (or prime-conv-mode-map forcep)
      (let ((map (make-sparse-keymap)))
	;; prime-input-mode-map $B$N@_Dj$rL58z2=$9$k(B.
	(substitute-key-definition 'prime-input-beginning-of-pattern
				   'undefined map prime-input-mode-map)
	(substitute-key-definition 'prime-input-end-of-pattern
				   'undefined map prime-input-mode-map)
	(substitute-key-definition 'prime-input-forward-char
				   'undefined map prime-input-mode-map)
	(substitute-key-definition 'prime-input-backward-char
				   'undefined map prime-input-mode-map)
	(substitute-key-definition 'prime-input-delete-char
				   'undefined map prime-input-mode-map)
	(substitute-key-definition 'prime-input-delete-backward-char
				   'prime-conv-prev map prime-input-mode-map)
;	(substitute-key-definition 'delete-backward-char
;				   'undefined map global-map)
	(substitute-key-definition 'previous-line
				   'prime-conv-prev map global-map)
	(substitute-key-definition 'next-line
				   'prime-conv-next map global-map)

	(define-key map "\C-q" 'prime-dict-word-delete)
	(define-key map "\C-l" 'prime-conv-cand-list)
	(define-key map [muhenkan]          'prime-conv-cancel)
	(setq prime-conv-mode-map map)
	)
      )

  ;; $B8uJd0lMw$+$i$NA*Br(B (prime-input-mode-map, prime-conv-mode-map $B$r7Q>5(B)
  (or (or prime-cand-mode-map forcep)
      (let ((map (make-sparse-keymap)))
	(substitute-key-definition 'forward-char-command
				   'prime-cand-forward map global-map)
	(substitute-key-definition 'backward-char-command
				   'prime-cand-backward map global-map)
	(define-key map "\C-f" 'prime-cand-forward)    ; $BK\Ev$O$$$i$J$$(B
	(define-key map "\C-b" 'prime-cand-backward)   ; $BK\Ev$O$$$i$J$$(B
	(substitute-key-definition 'previous-line
				   'prime-cand-prev-line map global-map)
	(substitute-key-definition 'next-line
				   'prime-cand-next-line map global-map)
	(substitute-key-definition 'end-of-line
				   'prime-cand-end-of-line map global-map)
	(substitute-key-definition 'beginning-of-line
				   'prime-cand-beginning-of-line
				   map global-map)
;	(substitute-key-definition 'delete-backward-char
;				   'prime-cand-backward
;				   map global-map)
	(setq prime-cand-mode-map map)
	))
  
  (or (or prime-narrow-mode-map forcep)
      (let ((map (make-sparse-keymap)))
	(substitute-key-definition 'forward-char-command
				   'prime-narrow-forward-char map global-map)
	(substitute-key-definition 'backward-char-command 
				   'prime-narrow-backward-char map global-map)
	(define-key map "\C-f" 'prime-narrow-forward-char)    ; $BK\Ev$O$$$i$J$$(B
	(define-key map "\C-b" 'prime-narrow-backward-char)   ; $BK\Ev$O$$$i$J$$(B
	(substitute-key-definition 'beginning-of-line
				   'prime-narrow-beginning-of-pattern
				   map global-map)
	(substitute-key-definition 'end-of-line
				   'prime-narrow-end-of-pattern map global-map)
	(substitute-key-definition 'delete-backward-char 
				   'prime-narrow-delete-backward-char
				   map global-map)
	(substitute-key-definition 'delete-char
				   'prime-narrow-delete-char map global-map)
	(substitute-key-definition 'transpose-chars
				   'prime-narrow-transpose-chars map global-map)
	(substitute-key-definition
	 'self-insert-command 'prime-narrow-keyin map global-map)
	(define-key map " "    'prime-conv-next)
	(setq prime-narrow-mode-map map)
	))

  (defconst prime-minor-mode-map-alist
    (list (cons 'prime-cand-mode    prime-cand-mode-map)
	  (cons 'prime-narrow-mode  prime-narrow-mode-map)
	  (cons 'prime-conv-mode    prime-conv-mode-map)
	  (cons 'prime-input-mode   prime-input-mode-map)
	  (cons 'prime-fund-mode    prime-fund-mode-map))
    "PRIME $B$N%-!<%^%C%W$N%j%9%H(B")
  (run-hooks 'prime-keymap-init-hook)
  )

;; $BJQ49%b!<%I@_Dj(B
(defcustom prime-predict-after-fix nil
  "nil $B0J30$N>l9g(B, $B3NDj$7$?8e<!$NC18l$rM=B,$9$k(B")
(defcustom prime-disp-cand-list-oneline nil
  "nil $B0J30$N>l9g(B, $B>o$KJQ498uJd$r(B 1 $B9T$GI=<((B")
(defcustom prime-language-list '(japanese "[PB|$B$"(B]" english "[PB|Aa]")
  "PRIME $B$GF~NO$9$k8@8l$H%$%s%8%1!<%?$N%j%9%H(B")
(defcustom prime-language-default 'japanese
  "$B%G%U%)%k%H$GF~NO$5$l$k8@8l(B")
(defcustom prime-language-always-hiragana t
  "nil $B$N>l9g(B, $BIQEY$K1~$8$F%+%?%+%J$,Bh(B 0 $B8uJd$K$J$k(B")

;; prime-enum-mode.el $B$K0\F0(B
;(defcustom prime-enum-char-list '(?1 ?2 ?3 ?4 ?5 ?6 ?7 ?8 ?9 ?0)
;  "prime-enum-mode $B;~$KA*BrMQ$H$7$F;HMQ$5$l$kJ8;z$N%j%9%H(B")
;(defcustom prime-enum-mode-sensitive nil
;  "prime-enum-mode $B$,M-8z$J>l9g(B, $B>o$KE,MQ$9$k$+$I$&$+(B
;nil $B$N>l9g$O(B prime-enum-char-list $B$NCM$,B3$/8B$j(B, prime-enum-mode $B$OL5;k$9$k(B.")

(defcustom prime-insparens-template-list
  '(("$B!V(B" . "$B!W(B") ("$B!X(B" . "$B!Y(B") ("$B!Z(B" . "$B![(B") ("$B!R(B" . "$B!S(B") ("$B!T(B" . "$B!U(B")
    ("$B!J(B" . "$B!K(B") ("$B!L(B" . "$B!M(B") ("$B!N(B" . "$B!O(B") ("$B!P(B" . "$B!Q(B") ("$B!H(B" . "$B!I(B")
    ("$B!F(B" . "$B!G(B") ("". ""))
  "prime-fund-insparens-insert-parens $B$G;HMQ$9$k3g8L$N%Z%"(B")

(defcustom prime-fix-by-capital-p t
  "$BBgJ8;zF~NO$rC18l$N6h@Z$j$H$9$k$+$I$&$+(B")

(defcustom prime-direct-key-alist
  '((?] "$B!W(B") (?[ "$B!V(B"))
  "$BJQ49$r$7$J$$$GD>@\F~NO$r$9$k%-!<(B")
(make-variable-buffer-local 'prime-direct-key-alist)

;; face $B$N@_Dj(B
(defcustom prime-cursor-color (mell-color-find "Pink" 6)
  "PRIME $B%b!<%I;~$N%+!<%=%k$N?'(B")
(defcustom prime-narrow-cursor-color (mell-color-find "LightSkyBlue" 4)
  "PRIME $B8uJd$N(B AND $B8!:wCf$N%+!<%=%k$N?'(B")
(defconst prime-default-cursor-color
  (mell-color-find (mell-color-get-cursor) 7)
  "PRIME $B%b!<%I$G;HMQ$9$kBTHrMQ$N%G%U%)%k%H%+!<%=%k$N?'(B")

(defface prime-cand-cursor-face
  (list 
   (list t
	 (list :foreground (mell-color-get-background)
	       :background (prime-face-find-color prime-cursor-color)
	       )))
  "PRIME cursor face")


;; $B3F%b!<%I$N@_Dj(B ($BEPO?$N=gHV$OD6=EMW(B)
(defvar prime-mode nil
  "*Non-nil means in an PRIME mode.")
(defvar prime-fund-mode nil
  "*Non-nil means in an PRIME fundamental mode.")
(defvar prime-input-mode nil
  "*Non-nil means in an PRIME input mode.")
(defvar prime-conv-mode nil
  "*Non-nil means in an PRIME conversion mode.")
(defvar prime-cand-mode nil
  "*Non-nil means in an PRIME all candidates mode.")
(defvar prime-narrow-mode nil
  "*Non-nil means in an PRIME all narrow mode.")
(defvar prime-enum-mode t
  "*Non-nil means in an PRIME all enumerative mode.")

(defvar prime-debug-mode nil
  "*Non-nil means in an PRIME debuging mode")

(defun prime-mode-init (&optional forcep)
  (prime-set-minor-mode 'prime-mode "")
  (prime-set-minor-mode 'prime-fund-mode   "" prime-fund-mode-map)
  (prime-set-minor-mode 'prime-input-mode  "" prime-input-mode-map)
  (prime-set-minor-mode 'prime-conv-mode   "" prime-conv-mode-map)
  (prime-set-minor-mode 'prime-narrow-mode "" prime-narrow-mode-map)
  (prime-set-minor-mode 'prime-cand-mode   "" prime-cand-mode-map)
  (prime-set-minor-mode 'prime-enum-mode   "")
  (run-hooks 'prime-mode-init-hook)
  )

(provide 'prime-init)
