;; $Id: prime-input-mode.el,v 1.1 2003/05/31 19:37:21 komatsu Exp $

;; undo $B5!9=$r<+A0$GMQ0U$7$F$$$k$N$G(B, $B$=$N$X$s$rCm0U(B.
(defun prime-input-mode (&optional arg)
  (setq prime-input-mode 
	(if (null arg) (not prime-input-mode)
	  (> (prefix-numeric-value arg) 0)))
  (if prime-input-mode
      (prime-input-mode-on t)
    (prime-input-mode-off t)
    ))

(defun prime-input-mode-on (&optional forcep)
  (if (or forcep (not prime-input-mode))
      (progn
	(let (prime-pat)
	  (prime-mode-on nil))
	(prime-conv-mode-off)
	(prime-fund-mode-off)
	(setq prime-input-mode t)
	(prime-input-mode-reset)
	(setq prime-buffer-undo-list buffer-undo-list)
	(buffer-disable-undo)
	(setq prime-tmp-fontify-region font-lock-fontify-region-function)
	(setq font-lock-fontify-region-function 'prime-fontify-region)
	)))

(defun prime-input-mode-off (&optional forcep)
  (if (or forcep prime-input-mode)
      (progn
	(prime-conv-mode-off)
	(setq prime-input-mode nil)
	(buffer-enable-undo)
	(setq buffer-undo-list prime-buffer-undo-list)
	(setq font-lock-fontify-region-function prime-tmp-fontify-region)
	)))

;;;; ------------------------------------------------------------
;;;; $B4X?tDj5A(B
;;;; ------------------------------------------------------------

(defun prime-input-mode-reset ()
  (setq prime-input-column (length prime-pat))
  )

(defun prime-input-insert-char (char &optional column)
  (or column (setq column prime-input-column))
  (setq prime-pat (concat (substring prime-pat 0 column)
			  (char-to-string char)  (substring prime-pat column)))
  (setq prime-input-column 
	(+ prime-input-column (length (char-to-string char))))
  )

(defun prime-input-get-label (&optional pattern)
  (or pattern (setq pattern prime-pat))
  (car (prime-server-get-label pattern)))

(defun prime-input-get-kana (&optional pattern)
  "$B$R$i$,$J$H%+%?%+%J$N:GE,$JJ}$rA*Br$9$k(B."
  (or pattern (setq pattern prime-pat))
  (let ((hiragana (prime-get-hiragana pattern))
	(katakana (prime-get-katakana pattern)))
;    (if (or prime-language-always-hiragana
;	    (>= (length (member hiragana prime-cands))
;		(length (member katakana prime-cands))))
;	hiragana
;      katakana
    (cond ((or (string-match "\\cj+[a-zA-Z-]+\\cj+\\|^[a-zA-Z-]*$" hiragana) 
	       (and (let ((case-fold-search nil))
		      (if prime-fix-by-capital-p
			  (string-match "^[A-Z][A-Z]+$" pattern)
			(string-match "[A-Z]" pattern)))))
	   pattern)
	  ((or prime-language-always-hiragana
	      (>= (length (member hiragana prime-cands))
		  (length (member katakana prime-cands))))
	   hiragana)
	  (t
	   katakana)
	  )))

(defun prime-input-backward-char ()
  (interactive)
  (setq prime-input-column (max 0 (1- prime-input-column)))
  (prime-disp-input)
  )
	
(defun prime-input-forward-char ()
  (interactive)
  (setq prime-input-column (min (length prime-pat) (1+ prime-input-column)))
  (prime-disp-input)
  )

(defun prime-input-end-of-pattern ()
  (interactive)
  (setq prime-input-column (length prime-pat))
  (prime-disp-input)
  )

(defun prime-input-beginning-of-pattern ()
  (interactive)
  (setq prime-input-column 0)
  (prime-disp-input)
  )

(defun prime-input-transpose-chars ()
  (interactive)
  (setq prime-pat (mell-string-transpose-chars prime-pat prime-input-column))
  (and (> prime-input-column 0) (< prime-input-column (length prime-pat))
       (setq prime-input-column (1+ prime-input-column)))
  (prime-disp-input)
  )

;; Think "undo" !
(defun prime-input-delete-char ()
  (interactive)
  (or (= prime-input-column (length prime-pat))
      (setq prime-pat (concat (substring prime-pat 0 prime-input-column)
			      (substring prime-pat (1+ prime-input-column)))))
  (if (= (length prime-pat) 0)
      (prime-conv-cancel-all)
    (prime-disp-input)
    ))

(defun prime-input-delete-backward-char ()
  (interactive)
  (or (= prime-input-column 0)
      (progn
	(setq prime-pat (concat (substring prime-pat 0 (1- prime-input-column))
				(substring prime-pat prime-input-column)))
	(setq prime-input-column (1- prime-input-column))))
  (if (= (length prime-pat) 0)
      (prime-conv-cancel-all)
    (prime-disp-input)
    ))

(defun prime-input-split ()
  (interactive)
  (setq prime-next-pattern (substring prime-pat prime-input-column))
  (setq prime-pat (substring prime-pat 0 prime-input-column))
  (setq prime-conv-exact-p t)
  (prime-disp-input)
  )

(provide 'prime-input-mode)

