;; $Id: prime-style.el,v 1.3 2004/01/18 13:35:56 komatsu Exp $

(defcustom prime-style nil "PRIME $B$NF~NO%9%?%$%k(B
'default, 'kana, 'tcode, 'capital-only, 'komatsu $B$+$iA*Br2DG=(B.
'default: $B%G%U%)%k%H$NF~NO%9%?%$%k(B
'kana:    $B$+$JF~NOMQ%9%?%$%k(B
'tcode:   T-Code$BF~NOMQ%9%?%$%k(B
'capital-only: $BBgJ8;z$N$_$,F|K\8lF~NO3+;O%-!<(B
'komatsu: $B>.>>(B (PRIME $B$N:n<T(B) $B$NF~NO%9%?%$%k(B")

(defvar prime-style-alist
  '((default      . prime-style-default)
    (capital-only . prime-style-capital-only)
    (kana         . prime-style-kana)
    (tcode        . prime-style-tcode)
    (komatsu      . prime-style-komatsu)))

(defcustom prime-style-kutouten-direct-p t "$B6gFIE@$rB(3NDj$9$k$+$I$&$+(B")
(defcustom prime-style-kutouten-autochange-p nil "$B<+F0E*$K6gFIE@$rJQ99$9$k(B")
(defcustom prime-style-kutouten '("$B!#(B" . "$B!"(B") "$B6gE@(B($B!#(B)$B$HFIE@(B($B!"(B)$B$N%Z%"(B")
(defvar prime-style-kutouten-local nil "$B%P%C%U%!%m!<%+%k$N6gFIE@$N%Z%"(B")
(make-variable-buffer-local 'prime-style-kutouten-local)

(defun prime-style-init (&optional style)
  (setq style-function (cdr (assoc (or style prime-style) prime-style-alist)))
  (and (functionp style-function)
       (apply style-function nil)))

(defun prime-style-default ()
  "$B%G%U%)%k%H$NF~NO%9%?%$%k(B"
  (interactive)
  (setq prime-style-kutouten-direct-p t)
  (setq prime-style-kutouten '("$B!#(B" . "$B!"(B"))
  (setq prime-direct-key-alist '((?] "$B!W(B") (?[ "$B!V(B")))
  (setq prime-fix-by-capital-p t)
  (setq prime-enum-mode t)
  )

(defun prime-style-kana ()
  "$B$+$JF~NOMQ%9%?%$%k(B"
  (interactive)
  (setq prime-style-kutouten-direct-p nil)
  (setq prime-direct-key-alist '())
  (setq prime-fix-by-capital-p nil)
  (setq prime-enum-mode nil)
  )

(defun prime-style-tcode ()
  "T-Code$BF~NOMQ%9%?%$%k(B"
  (interactive)
  (setq prime-style-kutouten-direct-p nil)
  (setq prime-direct-key-alist '())
  (setq prime-fix-by-capital-p nil)
  (setq prime-enum-mode nil)
  )

(defun prime-style-capital-only ()
  "$BBgJ8;z$N$_$rF|K\8lF~NO3+;O%-!<$H$9$k(B.
by $BJ?2,$5$s(B <hira@ics.saitama-u.ac.jp>"
  (interactive)
  (let ((symbols "0123456789!@#$%^&*()_=+\\|[{]};:'\"`,.<>~/?")
	(alphabets "abcdefghijklmnopqrstuvwxyz-"))
    (mapcar '(lambda (c)
	       (define-key prime-fund-mode-map (string c) nil))
	    (concat alphabets symbols))
    (setq prime-direct-key-alist
	  (mapcar (lambda (c) (list c (string c)))
		  symbols))
    ))

(defun prime-style-komatsu ()
  "$B>.>>(B (PRIME $B$N:n<T(B) $B$NF~NO%9%?%$%k(B"
  (interactive)
  (setq prime-style-kutouten '("." . ", "))
  (setq prime-style-kutouten-autochange-p t)
  (setq prime-direct-key-alist
	(append 
	 (mapcar (lambda (c) (list c (string c)))
		 "!@#$%^&*(_=+\\|{;:'\"`.<~")
	 '((?[ "$B!V(B") (?] "$B!W(B") (?? "? ") (?> "> ") (?\) ") ") (?\} "} "))))
  (setq prime-language-always-hiragana nil)
  )


;;;; $B6gFIE@(B ========================================

(defun mell-match-score-region (regexp-list start end &optional buffer)
  (and buffer (set-buffer buffer))
  (sort
   (mapcar '(lambda (symbol)
	      (let ((symbol-output (if (consp symbol) (car symbol) symbol))
		    (symbol-regexp (if (consp symbol) (cdr symbol) symbol)))
		(cons symbol-output
		      (mell-match-count-region symbol-regexp start end))))
	   regexp-list)
   '(lambda (val1 val2)
      (> (cdr val1) (cdr val2)))
   ))

(defun mell-match-score-buffer (regexp-list &optional buffer)
  (and buffer (set-buffer buffer))
  (mell-match-score-region regexp-list (point-min) (point-max)))

;; mell $B9T$-(B?
(defvar prime-style-kuten-list  '("$B!#(B" "$B!%(B" ("."  . "\\cj\\. \\|\\cj\\.$")))
(defvar prime-style-touten-list '("$B!"(B" "$B!$(B" (", " . "\\cj\\, \\|\\cj\\,$")))

;; mell $B9T$-(B?
(defun prime-style-kutouten-guess ()
  (cons
   (car (car (mell-match-score-region prime-style-kuten-list
				      (max (point-min) (- (point) 1000))
				      (min (point-max) (+ (point) 1000))
				      )))
   (car (car (mell-match-score-region prime-style-touten-list
				      (max (point-min) (- (point) 1000))
				      (min (point-max) (+ (point) 1000))
				      )))
   ))

(defun prime-style-kutouten-set (kuten touten)
  (interactive "s$B6gE@(B ($B!#$J$I(B): \ns$BFIE@(B ($B!"$J$I(B): ")
  (setq prime-style-kutouten-local (cons kuten touten))
  )

(defun prime-style-kutouten-set-automatically ()
  (interactive)
  (if (null prime-style-kutouten-local)
      (let ((kutouten (prime-style-kutouten-guess)))
	(prime-style-kutouten-set (car kutouten) (cdr kutouten))
	)))

(provide 'prime-style)
