/*
 * Decompiled with CFR 0.152.
 */
package jp.eclipse.plugin.proptranslator.wizard;

import java.util.ArrayList;
import java.util.List;
import jp.eclipse.plugin.proptranslator.util.StringUtils;
import jp.eclipse.plugin.proptranslator.wizard.FileBean;
import jp.eclipse.plugin.proptranslator.wizard.FileSelectLabelProvider;
import jp.eclipse.plugin.proptranslator.wizard.FileSelectModifier;
import jp.eclipse.plugin.proptranslator.wizard.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelectWizardPage1
extends WizardPage {
    private TableViewer viewer;
    private List<IFile> files;

    public FileSelectWizardPage1(List<IFile> files) {
        super("FileSelectWizardPage1");
        this.setTitle(Messages.getString("FileSelectWizardPage1.0"));
        this.setDescription(Messages.getString("FileSelectWizardPage1.1"));
        this.files = files;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.viewer = new TableViewer(composite, 68354);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.getString("FileSelectWizardPage1.2"));
        column = new TableColumn(table, 0);
        column.setText(Messages.getString("FileSelectWizardPage1.3"));
        String[] properties = new String[]{"", "text"};
        this.viewer.setColumnProperties(properties);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)table);
        CellEditor[] editors = cellEditorArray;
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier((ICellModifier)new FileSelectModifier(this.viewer));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileSelectLabelProvider());
        ArrayList<FileBean> input = new ArrayList<FileBean>();
        List<IFile> list = this.getFiles();
        int i = 0;
        while (i < list.size()) {
            IFile file = list.get(i);
            FileBean bean = new FileBean();
            bean.setRelativeCurrentDir(StringUtils.getRelativeCurrentDir(file));
            bean.setAbsoluteCurrentDir(StringUtils.getAbsoluteCurrentDir(file));
            bean.setFileName(file.getName());
            bean.setTranslatedFileName(StringUtils.getTranslatedFileName(file));
            input.add(bean);
            ++i;
        }
        this.viewer.setInput(input);
        TableColumn[] columns = table.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            columns[i2].pack();
            ++i2;
        }
        this.updateStatus();
        this.setControl((Control)composite);
    }

    private void updateStatus() {
        if (this.files.isEmpty()) {
            this.setErrorMessage(Messages.getString("FileSelectWizardPage1.6"));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public List<IFile> getFiles() {
        return this.files;
    }

    public List getFileBeans() {
        return (List)this.viewer.getInput();
    }
}

