//8bit mono and stereo PCM to ADPCM encoder 
//

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define WAVESIZE (100*1024*1024)
#define WAVEMAX (32767-4096)
#define WAVEMIN (-32767+4096)

unsigned char wavebuf[WAVESIZE];
unsigned char adpbuf[WAVESIZE/2];

//void encode(unsigned char *adp,unsigned char *wave,int size);
void adp_encode(char *src,char *dst);
//fpos_t GetFileSize(char *FileName[]);

static int indexTable[16] = {
    -1, -1, -1, -1, 1, 1, 1, 2,
    -1, -1, -1, -1, 1, 1, 1, 2
};

static int stepsizeTable[10/*89*/] = {
//  7,   8,   9,  10,  11,  12,  13,  14,  16,  17,
//	  8,   8,   8,   8,   8,   16,  16,  16,  16,  16,
	7,   8,   8,   8,   8,   8,  8,  8,  15,  16
//	 19,  21,  23,  25,  28



/* 
   337, 371, 408, 449, 494, 544, 598, 658, 724, 796,
    876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066,
    2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358,
    5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899,
    15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, 32767
*/
};
  
void encode(unsigned char *adp,unsigned char *wave, int size)
{
    int nowpcm;			/* Current input sample value */
    unsigned char sign;			/* Current adpcm sign bit */

    unsigned char/*int*/ delta;			/* Current adpcm output value */
    unsigned char/*int*/ delta2;			/* Current adpcm output value */

    int diff;					/* Difference between nowpcm and valprev */
    int diff2;					/* Difference between nowpcm and valprev */

    int step=0;					/* Stepsize */
    int step2=0; 
    int oldpcm=0;				/* Predicted output value */
    int oldpcm2=0;				/* Predicted output value */
    unsigned char vpdiff;			/* Current change to oldpcm */
    int index=0;				/* Current step change index */

    int index2=0;				/* Current step change index */
    unsigned char/*int*/ outputbuffer;		/* place to keep previous 4-bit value */
    int bufferstep;				/* toggle between outputbuffer/output */
    int i;
    
    bufferstep = 1;

    for (i=0;i<size;i+=2) {
	

	/* Step 1 - compute difference with previous value */
	diff = *wave++ - oldpcm;
	sign = (diff < 0) ? 8 : 0;
	if ( sign ) diff = (-diff);

	/* Step 2 - Divide and clamp */
	/* Note:
	** This code *approximately* computes:
	**    delta = diff*4/step;
	**    vpdiff = (delta+0.5)*step/4;
	** but in shift step bits are dropped. The net result of this is
	** that even if you have fast mul/div hardware you cannot put it to
	** good use since the fixup would be too expensive.
	*/



	delta = 0;
	vpdiff = (step >> 3);
	
	if ( diff >= step ) {
	    delta = 4;
	    diff -= step;
	    vpdiff += step;
	}
	step >>= 1;
	if ( diff >= step  ) {
	    delta |= 2;
	    diff -= step;
	    vpdiff += step;
	}
	step >>= 1;
	if ( diff >= step ) {
	    delta |= 1;
	    vpdiff += step;
	}

	/* Step 3 - Update previous value */
	if ( sign )
	  oldpcm -= vpdiff;
	else
	  oldpcm += vpdiff;

	/* Step 4 - Clamp previous value to 16 bits */
	if ( oldpcm > 255/*32767*/ )
	  oldpcm = 255/*32767*/;
	else if ( oldpcm < 0/*-32768*/ )
	  oldpcm = 0/*-32768*/;

	/* Step 5 - Assemble value, update index and step values */
	delta |= sign;
	
	index += indexTable[delta];
	if ( index < 0 ) index = 0;
	if ( index > 9/*88*/ ) index = 9/*88*/;
	step = stepsizeTable[index];

	/* Step 6 - Output value */
	
	    //outputbuffer = (delta << 4) & 0xf0;
		outputbuffer = (unsigned char)(delta & 0x0f);
		






	/* Step 1 - compute difference with previous value */
	diff2 = *wave++ - oldpcm2;
	sign = (diff2 < 0) ? 8 : 0;
	if ( sign ) diff2 = (-diff2);

	/* Step 2 - Divide and clamp */
	/* Note:
	** This code *approximately* computes:
	**    delta = diff*4/step;
	**    vpdiff = (delta+0.5)*step/4;
	** but in shift step bits are dropped. The net result of this is
	** that even if you have fast mul/div hardware you cannot put it to
	** good use since the fixup would be too expensive.
	*/



	delta2 = 0;
	vpdiff = (step2 >> 3);
	
	if ( diff2 >= step2 ) {
	    delta2 = 4;
	    diff2 -= step2;
	    vpdiff += step2;
	}
	step2 >>= 1;
	if ( diff2 >= step2  ) {
	    delta2 |= 2;
	    diff2 -= step2;
	    vpdiff += step2;
	}
	step2 >>= 1;
	if ( diff2 >= step2 ) {
	    delta2 |= 1;
	    vpdiff += step2;
	}

	/* Step 3 - Update previous value */
	if ( sign )
	  oldpcm2 -= vpdiff;
	else
	  oldpcm2 += vpdiff;

	/* Step 4 - Clamp previous value to 16 bits */
	if ( oldpcm2 > 255/*32767*/ )
	  oldpcm2 = 255/*32767*/;
	else if ( oldpcm2 < 0/*-32768*/ )
	  oldpcm2 = 0/*-32768*/;

	/* Step 5 - Assemble value, update index and step values */
	delta2 |= sign;
	
	index2 += indexTable[delta2];
	if ( index2 < 0 ) index2 = 0;
	if ( index2 > 9/*88*/ ) index2 = 9/*88*/;
	step2 = stepsizeTable[index2];


	/* Step 6 - Output value */
	    *adp++ = (unsigned char)(((delta2 << 4) & 0xf0) | (outputbuffer  & 0x0f));
	



	
    }

}



int main(int argc, char * argv[])
{
  if((argc!=3)&&(argc!=4)){
    printf("%s:adpcm converter for 8bit mono pcm\n",argv[0]);
    printf("\t%s <source file name> <tag name>\n",argv[0]);
    printf("\t output file name : <tag name>.snd\n");
    exit(-1);
  }
  memset(wavebuf,0,sizeof(wavebuf));
  memset(adpbuf,0,sizeof(adpbuf));
  adp_encode(argv[1],argv[2]);
  return 0;
}

void adp_encode(char *src,char *dst)
{
  FILE *fp;
  int size,i;
  char nbuff[256];
  if((fp=fopen(src,"rb"))==NULL){
    printf("can't open %s\n",src);
    exit(-1);
  }
 
	fpos_t fsize = 0;

	/* t@CTCY𒲍 */ 
	fseek(fp,0,SEEK_END); 
	fgetpos(fp,&fsize); 
	if(fsize > sizeof(wavebuf))fsize=sizeof(wavebuf);

 
  fseek(fp,44,SEEK_SET); //Skip header
  
  size=fread(wavebuf,1,fsize,fp);
  fclose(fp);
  encode(adpbuf,wavebuf,size);
  if((fp=fopen( strcat( strcpy(nbuff,dst) ,".dat" ),"w" ))==NULL){
    printf("can't open %s\n",dst);
    exit(-1);
  }
 fwrite(adpbuf,1,fsize/2,fp);
  fclose(fp);
}

