//*****************************************************************************
//*****************************************************************************
//  FILENAME: DAC9_3.h
//   Version: 2.2, Updated on 2009/5/7 at 21:9:55
//  Generated by PSoC Designer 5.0.423.0
//
//  DESCRIPTION: DAC9 User Module C Language interface file for the
//               22/24/25/26/27/29xxx PSoC family of devices.
//
//-----------------------------------------------------------------------------
//      Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

//-------------------------------------------------
// Defines for DAC9_3 API's.
//-------------------------------------------------
// Power Setting Defines
#define DAC9_3_OFF                 0
#define DAC9_3_LOWPOWER            1
#define DAC9_3_MEDPOWER            2
#define DAC9_3_HIGHPOWER           3
#define DAC9_3_FULLPOWER           3

// Define constants for declaring function prototypes based on DataFormat parameter
#define DAC9_3_OffsetBinary            0x04
#define DAC9_3_TwosComplement          0x02
#define DAC9_3_SignAndMagnitude        0x01
#define DAC9_3_RawRegister             0x00
#define DAC9_3_DATAFORMAT          0x3
#define DAC9_3_OFFSETBINARY        DAC9_3_DATAFORMAT & DAC9_3_OffsetBinary
#define DAC9_3_TWOSCOMPLEMENT      DAC9_3_DATAFORMAT & DAC9_3_TwosComplement
#define DAC9_3_SIGNANDMAGNITUDE    DAC9_3_DATAFORMAT & DAC9_3_SignAndMagnitude

// Declare function fastcall16 pragmas
#pragma fastcall16 DAC9_3_Start
#pragma fastcall16 DAC9_3_SetPower
#pragma fastcall16 DAC9_3_Stop

//-------------------------------------------------
// Prototypes of the DAC9_3 API.
//-------------------------------------------------
extern void  DAC9_3_Start(BYTE bPowerSetting);
extern void  DAC9_3_SetPower(BYTE bPowerSetting);
extern void  DAC9_3_Stop(void);

// Declare overloaded functions based on DataForamt parameter selected
#if DAC9_3_OFFSETBINARY
   #pragma fastcall16 DAC9_3_WriteBlind
   #pragma fastcall16 DAC9_3_WriteStall
   extern void  DAC9_3_WriteBlind(WORD wOutputValue);
   extern void  DAC9_3_WriteStall(WORD wOutputValue);
#else
   #if DAC9_3_TWOSCOMPLEMENT
      #pragma fastcall16 DAC9_3_WriteBlind
      #pragma fastcall16 DAC9_3_WriteStall
      extern void  DAC9_3_WriteBlind(INT iOutputValue);
      extern void  DAC9_3_WriteStall(INT iOutputValue);
   #else    //DAC9_3_SIGNANDMAGNITUDE
      #pragma fastcall16 DAC9_3_WriteBlind2B
      #pragma fastcall16 DAC9_3_WriteStall2B
      extern void  DAC9_3_WriteBlind2B(BYTE bLSB, BYTE bMSB);
      extern void  DAC9_3_WriteStall2B(BYTE bLSB, BYTE bMSB);
   #endif
#endif

//-------------------------------------------------
// Hardware Addresses for DAC9_3
//-------------------------------------------------

#pragma ioport  DAC9_3_LSB_CR0: 0x098                      // LSB Analog control register 0
BYTE            DAC9_3_LSB_CR0;
#pragma ioport  DAC9_3_LSB_CR1: 0x099                      // LSB Analog control register 1
BYTE            DAC9_3_LSB_CR1;
#pragma ioport  DAC9_3_LSB_CR2: 0x09a                      // LSB Analog control register 2
BYTE            DAC9_3_LSB_CR2;
#pragma ioport  DAC9_3_LSB_CR3: 0x09b                      // LSB Analog control register 3
BYTE            DAC9_3_LSB_CR3;

#pragma ioport  DAC9_3_MSB_CR0: 0x088                      // MSB Analog control register 0
BYTE            DAC9_3_MSB_CR0;
#pragma ioport  DAC9_3_MSB_CR1: 0x089                      // MSB Analog control register 1
BYTE            DAC9_3_MSB_CR1;
#pragma ioport  DAC9_3_MSB_CR2: 0x08a                      // MSB Analog control register 2
BYTE            DAC9_3_MSB_CR2;
#pragma ioport  DAC9_3_MSB_CR3: 0x08b                      // MSB Analog control register 3
BYTE            DAC9_3_MSB_CR3;

// end of file DAC9_3.h
