;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: DAC9_3.inc
;;   Version: 2.2, Updated on 2009/5/7 at 21:9:55
;;  Generated by PSoC Designer 5.0.423.0
;;
;;  DESCRIPTION:  Assembler declarations for the DAC9 user module interface
;;                for the 22/24/25/26/27/29xxx PSoC family of devices.
;;
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"

;--------------------------------------------------
; Constants for DAC9_3 API's
;--------------------------------------------------
DAC9_3_OFF:              equ 00h
DAC9_3_LOWPOWER:         equ 01h
DAC9_3_MEDPOWER:         equ 02h
DAC9_3_HIGHPOWER:        equ 03h
DAC9_3_FULLPOWER:        equ 03h

DAC9_3_LSB_CR0:          equ 98h
DAC9_3_LSB_CR1:          equ 99h
DAC9_3_LSB_CR2:          equ 9ah
DAC9_3_LSB_CR3:          equ 9bh
DAC9_3_MSB_CR0:          equ 88h
DAC9_3_MSB_CR1:          equ 89h
DAC9_3_MSB_CR2:          equ 8ah
DAC9_3_MSB_CR3:          equ 8bh

DAC9_3_OffsetBinary:     equ 04h
DAC9_3_TwosComplement:   equ 02h
DAC9_3_SignAndMagnitude: equ 01h
DAC9_3_RawRegister:      equ 00h

DAC9_3_DATAFORMAT:       equ 3h
DAC9_3_OFFSETBINARY:     equ DAC9_3_DATAFORMAT & DAC9_3_OffsetBinary
DAC9_3_TWOSCOMPLEMENT:   equ DAC9_3_DATAFORMAT & DAC9_3_TwosComplement
DAC9_3_SIGNANDMAGNITUDE: equ DAC9_3_DATAFORMAT & DAC9_3_SignAndMagnitude

DAC9_3_PHASE_Normal:     equ 0
DAC9_3_PHASE_Swapped:    equ 1

DAC9_3_PHASE_SWAP:       equ DAC9_3_PHASE_Normal

IF DAC9_3_PHASE_SWAP
    DAC9_3_CR0_HIBITS:   equ C0h
ELSE
    DAC9_3_CR0_HIBITS:   equ 80h
ENDIF

;--------------------------------------------------
; Register Address Constants for DAC9_3
;--------------------------------------------------
DAC9_3_LSB_CR0: equ 98h                          ; LSB SC Block Control Register 0
DAC9_3_LSB_CR1: equ 99h                          ; LSB SC Block Control Register 1
DAC9_3_LSB_CR2: equ 9ah                          ; LSB SC Block Control Register 2
DAC9_3_LSB_CR3: equ 9bh                          ; LSB SC Block Control Register 3

DAC9_3_MSB_CR0: equ 88h                          ; MSB SC Block Control Register 0
DAC9_3_MSB_CR1: equ 89h                          ; MSB SC Block Control Register 1
DAC9_3_MSB_CR2: equ 8ah                          ; MSB SC Block Control Register 2
DAC9_3_MSB_CR3: equ 8bh                          ; MSB SC Block Control Register 3

; end of file DAC9_3.inc
