;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: LPF2_2.asm
;;   Version: 2.5, Updated on 2009/5/7 at 21:11:10
;;  Generated by PSoC Designer 5.0.423.0
;;
;;  DESCRIPTION: Asm source for 2 Pole Switched Capacitor Low Pass Filter
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2001-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"
include "LPF2_2.inc"


;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  LPF2_2_Start
export _LPF2_2_Start
export  LPF2_2_SetPower
export _LPF2_2_SetPower

export  LPF2_2_SetC1
export _LPF2_2_SetC1
export  LPF2_2_SetC2
export _LPF2_2_SetC2
export  LPF2_2_SetC3
export _LPF2_2_SetC3
export  LPF2_2_SetC4
export _LPF2_2_SetC4
export  LPF2_2_SetCA
export _LPF2_2_SetCA
export  LPF2_2_SetCB
export _LPF2_2_SetCB
export  LPF2_2_SetPolarity
export _LPF2_2_SetPolarity

export  LPF2_2_Stop
export _LPF2_2_Stop


;-----------------------------------------------
; Variable Allocation
;-----------------------------------------------
AREA bss (RAM,REL)



;-----------------------------------------------
;  EQUATES
;-----------------------------------------------
bPOWERMASK:          equ   03h         ; Power field mask for CR3
LPF_CNUMMASK:        equ   1fh         ; Mask for A, B & C Caps
LPF_CFBMASK:         equ   80h         ; Mask for Feedback Caps
LPF_POLARITYMASK:    equ   20h         ; Mask of Asign field for CR0



AREA UserModules (ROM,REL)
;-----------------------------------------------------------------------------
;  FUNCTION NAME: LPF2_2_Start
;
;  DESCRIPTION: Applies power setting to the module's PSoC blocks
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    A register contains the power setting (constant)
;  RETURNS:      Nothing
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;

 LPF2_2_Start:
_LPF2_2_Start:
 LPF2_2_SetPower:
_LPF2_2_SetPower:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, bPOWERMASK                        ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location

    push A                                   ; put power value in temp store
    mov A, reg[LPF2_2_FLIN_CR3]    ; read power value
    and A, ~bPOWERMASK                       ; clear power bits in A
    or  A, [X]                               ; combine power value with balance of reg.
    mov reg[LPF2_2_FLIN_CR3], A    ; move complete value back to register

    mov A, reg[LPF2_2_FLOUT_CR3]   ; read power value
    and A, ~bPOWERMASK                       ; clear power bits in A
    or  A, [X]                               ; combine power value with balance of reg.
    mov reg[LPF2_2_FLOUT_CR3], A   ; move complete value back to register
    pop A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

;-----------------------------------------------------------------------------
;  FUNCTION NAME: LPF2_2_SetCn, n=1..4
;
;  DESCRIPTION:   Alters the filter transfer function by modifying the value
;                 of the capacitors (defined in LPF2_2.inc)
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    The A register contains a non-negative integer less than 32
;  RETURNS:
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;

 LPF2_2_SetC1:
_LPF2_2_SetC1:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, LPF_CNUMMASK                      ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location
    push A                                   ; put C1 value in temp store
    mov A, reg[LPF2_2_FILT_C1_REG] ; read current C1
    and A, ~LPF_CNUMMASK                     ; clear C1 bits in A
    or  A, [X]                               ; combine C1 value with balance of reg.
    mov reg[LPF2_2_FILT_C1_REG], A ; move complete value back to register
    pop  A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

 LPF2_2_SetC2:
_LPF2_2_SetC2:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, LPF_CNUMMASK                      ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location
    push A                                   ; put C2 value in temp store
    mov A, reg[LPF2_2_FILT_C2_REG] ; read current C2
    and A, ~LPF_CNUMMASK                     ; clear C2 bits in A
    or  A, [X]                               ; combine C2 value with balance of reg.
    mov reg[LPF2_2_FILT_C2_REG], A ; move complete value back to register
    pop A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

 LPF2_2_SetC3:
_LPF2_2_SetC3:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, LPF_CNUMMASK                      ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location
    push A                                   ; put C3 value in temp store
    mov A, reg[LPF2_2_FILT_C3_REG] ; read current C3
    and A, ~LPF_CNUMMASK                     ; clear C3 bits in A
    or  A, [X]                               ; combine C3 value with balance of reg.
    mov reg[LPF2_2_FILT_C3_REG], A ; move complete value back to register
    pop A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

 LPF2_2_SetC4:
_LPF2_2_SetC4:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, LPF_CNUMMASK                      ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location
    push A                                   ; put C4 value in temp store
    mov A, reg[LPF2_2_FILT_C4_REG] ; read current C4
    and A, ~LPF_CNUMMASK                     ; clear C4 bits in A
    or  A, [X]                               ; combine C4 value with balance of reg.
    mov reg[LPF2_2_FILT_C4_REG], A ; move complete value back to register
    pop A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret


;-----------------------------------------------------------------------------
;  FUNCTION NAME: LPF2_2_SetCA
;            and  LPF2_2_SetCB
;
;  DESCRIPTION:   Alters the filter transfer function by modifying the value
;                 of the op-amp feedback capacitors (see LPF2_2.inc)
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    The A register contains one of the LPF2_2_FEEDBACK
;                  constants defined in LPF2_2.inc
;  RETURNS:      Nothing.
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;

 LPF2_2_SetCA:
_LPF2_2_SetCA:
    RAM_PROLOGUE RAM_USE_CLASS_1
    cmp   A, LPF2_2_FEEDBACK_32    ; Change Feedback to 32 units?
    jz    .SetCAto32                         ;    Yes, go make it so
                                             ;     No, clear it to 16 units...
    and   reg[LPF2_2_FILT_CA_REG], ~LPF_CFBMASK
    RAM_EPILOGUE RAM_USE_CLASS_1 
    ret
.SetCAto32:
    or    reg[LPF2_2_FILT_CA_REG],  LPF_CFBMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret


 LPF2_2_SetCB:
_LPF2_2_SetCB:
    RAM_PROLOGUE RAM_USE_CLASS_1
    cmp   A, LPF2_2_FEEDBACK_32    ; Change Feedback to 32 units?
    jz    .SetCAto32                         ;    Yes, go make it so
                                             ;     No, clear it to 16 units...
    and   reg[LPF2_2_FILT_CB_REG], ~LPF_CFBMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.SetCAto32:
    or    reg[LPF2_2_FILT_CB_REG],  LPF_CFBMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret

;-----------------------------------------------------------------------------
;  FUNCTION NAME: LPF2_2_SetPolarity
;
;  DESCRIPTION:   Alters the output polarity of the data by altering the
;                 input polarity at FLIN
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    The A register contains one of the LPF2_2_POLARITY
;                  constants defined in LPF2_2.inc
;  RETURNS:      Nothing.
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;

 LPF2_2_SetPolarity:
_LPF2_2_SetPolarity:
    RAM_PROLOGUE RAM_USE_CLASS_1
    cmp   A, LPF2_2_POLARITY_NON_INVERTING ; Should the output be non-inverting?
    jz    .SetPoltoNonInv                         ;    Yes, go make it so
                                                  ;    No, then set it to Inverting...
    or    reg[LPF2_2_FLIN_CR0], LPF_POLARITYMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.SetPoltoNonInv:
    and   reg[LPF2_2_FLIN_CR0], ~LPF_POLARITYMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret

;-----------------------------------------------------------------------------
;  FUNCTION NAME: LPF2_2_Stop
;
;  DESCRIPTION: Cuts power to the user module.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:     None
;  RETURNS:       Nothing
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 LPF2_2_Stop:
_LPF2_2_Stop:

    RAM_PROLOGUE RAM_USE_CLASS_1
    and reg[LPF2_2_FLIN_CR3],  ~bPOWERMASK
    and reg[LPF2_2_FLOUT_CR3], ~bPOWERMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret


; End of File LPF2_2.asm
