//*****************************************************************************
//*****************************************************************************
//  FILENAME: SDCard_SPI.h
//  Version: 1.2, Updated on 2009/5/7 at 21:11:30
//  Generated by PSoC Designer 5.0.423.0
//
//  DESCRIPTION:
//    SDCard SDCard User Module low level SPI header file.
//-----------------------------------------------------------------------------
//      Copyright (c) Cypress MicroSystems 2000-2006. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

#ifndef SDCard_SPI_HEADER
#define SDCard_SPI_HEADER

#pragma fastcall16  SDCard_InitHdwr
#pragma fastcall16  SDCard_UnInitHdwr
#pragma fastcall16  SDCard_Select
#pragma fastcall16  SDCard_SendTxData
#pragma fastcall16  SDCard_bReadRxData
#pragma fastcall16  SDCard_bReadStatus
#pragma fastcall16  SDCard_WriteBuff256
#pragma fastcall16  SDCard_ReadBuff256
#pragma fastcall16  SDCard_WriteBuff
#pragma fastcall16  SDCard_ReadBuff

//-------------------------------------------------
// Prototypes of the SDCard API.
//-------------------------------------------------
extern void  SDCard_InitHdwr(BYTE bConfiguration);
extern void  SDCard_UnInitHdwr(void);
extern void  SDCard_Select(BYTE bEnable);
extern void  SDCard_SendTxData(BYTE bTxData);
extern BYTE  SDCard_bReadRxData(void);
extern BYTE  SDCard_bReadStatus(void);
extern void  SDCard_WriteBuff256(char * sRamBuff);
extern void  SDCard_ReadBuff256(char * sRamBuff);
extern void  SDCard_WriteBuff(char * sRamBuff, BYTE bCnt);
extern void  SDCard_ReadBuff(char * sRamBuff, BYTE bCnt);


//-------------------------------------------------
// Constants for SDCard API's.
//-------------------------------------------------

#define SDCard_ENABLE   1
#define SDCard_DISABLE  0

#define SDCard_INT_REG_ADDR                    ( 0x@SPIM__ISR_ADDR )
#define SDCard_bINT_MASK                       ( 0x@SPIM__ISR_MASK )

//*******************************
// SPI Configuration definitions
//*******************************
#define  SDCard_SPIM_MODE_0            0x00      // MODE 0 - Leading edge latches data - pos clock
#define  SDCard_SPIM_MSB_FIRST         0x00      // MSB bit transmitted/received first

//********************************
// SPI Status register masks
//********************************
#define  SDCard_SPIM_RX_OVERRUN_ERROR  0x40      // Overrun error in received data
#define  SDCard_SPIM_TX_BUFFER_EMPTY   0x10      // TX Buffer register is ready for next data byte
#define  SDCard_SPIM_RX_BUFFER_FULL    0x08      // RX Buffer register has received current data
#define  SDCard_SPIM_SPI_COMPLETE      0x20      // SPI Tx/Rx cycle has completed

//-------------------------------------------------
// Register Addresses for SDCard
//-------------------------------------------------
#pragma ioport  SDCard_CONTROL_REG: 0x02b                  // Control register
BYTE            SDCard_CONTROL_REG;
#pragma ioport  SDCard_SHIFT_REG:   0x028                  // TX Shift Register register
BYTE            SDCard_SHIFT_REG;
#pragma ioport  SDCard_TX_BUFFER_REG:   0x029              // TX Buffer Register
BYTE            SDCard_TX_BUFFER_REG;
#pragma ioport  SDCard_RX_BUFFER_REG:   0x02a              // RX Buffer Register
BYTE            SDCard_RX_BUFFER_REG;
#pragma ioport  SDCard_FUNCTION_REG:    0x128              // Function register
BYTE            SDCard_FUNCTION_REG;
#pragma ioport  SDCard_INPUT_REG:   0x129                  // Input register
BYTE            SDCard_INPUT_REG;
#pragma ioport  SDCard_OUTPUT_REG:  0x12a                  // Output register
BYTE            SDCard_OUTPUT_REG;  

#endif
// end of file SDCard.h
