;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: SDCard.inc
;;  Version: 1.2, Updated on 2009/5/7 at 21:11:30
;;  Generated by PSoC Designer 5.0.423.0
;;
;;  DESCRIPTION:
;;    Assembler include file of SDCard instance of SDCard
;;    user module.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2006. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

;--------------------------------------------------
; Register constants and masks
;--------------------------------------------------
SDCard_SPIM_MODE_0:             equ   00h      ; MODE 0 - Leading edge latches data - pos clock
SDCard_SPIM_MSB_FIRST:          equ   00h      ; MSB bit transmitted/received first

;---------------------------
; SPI Status register masks
;---------------------------
SDCard_SPIM_RX_OVERRUN_ERROR:   equ   40h      ; Overrun error in received data
SDCard_SPIM_TX_BUFFER_EMPTY:    equ   10h      ; TX Buffer register is ready for next data byte
SDCard_SPIM_RX_BUFFER_FULL:     equ   08h      ; RX Buffer register has received current data
SDCard_SPIM_SPI_COMPLETE:       equ   20h      ; SPI Tx/Rx cycle has completed

SDCard_ENABLE_PRESENT:  equ    0
SDCard_ENABLE_WPROTECT: equ    0


IF ( SDCard_ENABLE_WPROTECT)
SDCard_WP_Port:    equ   PRT@SD_WP_PortDR
SDCard_WP_Mask:    equ   0x@SD_WP_Pin_MASK
ENDIF


IF ( SDCard_ENABLE_PRESENT)
SDCard_CD_Port:    equ   PRT@SD_CD_PortDR
SDCard_CD_Mask:    equ   0x@SD_CD_Pin_MASK
ENDIF

SDCard_CS_Port:    equ   PRT2DR
SDCard_CS_Mask:    equ   0x1


;--------------------------------------------------
; Registers used by SDCard
;--------------------------------------------------
SDCard_CONTROL_REG: equ 2bh                      ; Control register
SDCard_SHIFT_REG:   equ 28h                      ; TX Shift Register register
SDCard_TX_BUFFER_REG:   equ 29h                  ; TX Buffer Register
SDCard_RX_BUFFER_REG:   equ 2ah                  ; RX Buffer Register
SDCard_FUNCTION_REG:    equ 28h                  ; Function register
SDCard_INPUT_REG:   equ 29h                      ; Input register
SDCard_OUTPUT_REG:  equ 2ah                      ; Output register

; end of file SDCard.inc
