import anydbm
import datetime
from feedparser import _parse_date
from habu import log

def dbdatefixer(url):
    try:
        from habu import habudb
        if habudb.isAvailable():
            entry = habudb.selectEntryByUrl(url)
            if entry:
                log.debug("adjust_date : fix date from db (%s)" % url)
                return entry.updated.timetuple()
    except Exception, e:
        log.debug(e)

    return datefixer(url)

def datefixer(url):
    log.debug("adjust_date : fix date with now (%s)" % url)
    return datetime.datetime.now().timetuple()

class AdjustDate:
    def __init__(self, config, environ):
        self.datefixer = config.get("use_db", False) and dbdatefixer or datefixer
        self.offset = config.get("time_offset", 0)

    def _toLocalTime(self, struct_time):
        tm = datetime.datetime(*struct_time[:6])
        if len(struct_time) == 9:
            if struct_time[-1] == -1:
                tm += datetime.timedelta(hours=self.offset)
            else:
                tm += datetime.timedelta(hours=self.offset)
            struct_time = tm.timetuple()
        return struct_time
        
    def execute(self, content):
        n = datetime.datetime.now()
        now = n.timetuple()
        nStr = str(n)
        for entry in content["entries"]:
            updated = entry.get("updated", None)
            parsed_updated = entry.get("updated_parsed", None)
            if parsed_updated:
                parsed_updated = self._toLocalTime(parsed_updated)
            if updated and not parsed_updated:
                parsed_updated = self._toLocalTime(_parse_date(updated))
            elif not parsed_updated:
                parsed_updated = self.datefixer(entry["link"])

            entry["updated_parsed"] = parsed_updated
            entry["updated"] = self.date2str(parsed_updated)

        return content

    def date2str(self, dt):
        return "%d-%02d-%02dT%02d:%02d:%02dZ" % dt[:6]


def create(config, environ):
    return AdjustDate(config, environ)
