from habu.webutils import getPage
from twisted.web.error import PageRedirect
from twisted.internet import defer
from habu import log
import re


class Checker:
    def __init__(self, fixer, content):
        self.fixer = fixer
        self.content = content
        self.remain_task_num = 0

    def gotPage(self, result):
        log.debug("fix_redirecotr : got page, no need to fix.")
        self.gotBoth()

    def gotErr(self, failure, entry):
        if isinstance(failure.value, PageRedirect):
            log.info("fix_redirector : reset link")
            entry["link"] = failure.value.location
        self.gotBoth()
    
    def gotBoth(self):
        self.remain_task_num -= 1
        if self.remain_task_num == 0:
            self.deferred.callback(self.content)

    def check(self):
        self.deferred = defer.Deferred()
        for entry in self.content["entries"]:
            link = entry["link"]
            if self.fixer.target_exp.findall(link):
                self.remain_task_num += 1
                if isinstance(link, unicode):
                    link = link.encode("utf-8")
                getPage(link, followRedirect = False,
                        proxy_host = self.fixer.proxy_host, 
                        proxy_port = self.fixer.proxy_port).addCallback(
                    self.gotPage).addErrback(self.gotErr, entry)
        
        if self.remain_task_num == 0:
            return 0
        return self.deferred
        


class PageLinkFixer:
    def __init__(self, config, environ):
        self.proxy_host = environ.get("proxy_host", None)
        self.proxy_port = environ.get("proxy_port", 0)
        exp = config.get("target", "")
        if isinstance(exp, unicode):
            exp = exp.decode("utf-8")
        self.target_exp = re.compile(exp)

    def execute(self, content):
        checker = Checker(self, content)
        result = checker.check()
        return result == 0 and content or result


def create(config, environ):
    return PageLinkFixer(config, environ)

