import datetime

class UnreadFilter:
    def __init__(self, config, environ):
        use_db = config.get("use_db", None)
        self.check = self.setupDb(use_db)
    
    def setupDb(self, use_db):
        if use_db:
            try:
                from habu import habudb
                def getFromDb(link, updated):
                    entry = habudb.selectEntryByUrl(link)
                    if not entry:
                        return False
                    if updated and entry.updated.timetuple()[:6] < updated[:6]:
                        return False
                    return True
                
                return getFromDb
            except:
                pass
        db = {}
        def getFromMemory(link, updated):
            if not db.has_key(link):
                db[link] = updated
                return False
            if updated and db[link] < updated:
                db[link] = updated
                return False
            return True
        
        return getFromMemory

    def execute(self, content):
        entries = []
        for entry in content["entries"]:
            link = entry["link"]
            updated = entry.get("updated_parsed", None)
            if not self.check(link, updated):
                entries.append(entry)
        content["entries"] = entries
        return content



def create(config, environ):
    return UnreadFilter(config, environ)
