# -*- coding: utf-8 -*-

from twisted.trial.unittest import TestCase
from twisted.internet import defer
import hyperestraier
import heupdater

class HEUpdater(TestCase):
    def setUp(self):
        node = hyperestraier.Node()
        node.set_url(node)
        node.set_auth("admin", "admin")
        node.out_doc_by_uri("http://localhost/test/1")
        node.out_doc_by_uri("http://localhost/test/2")
        node.out_doc_by_uri("http://localhost/test/3")

    def tearDown(self):
        node = hyperestraier.Node()
        node.set_url(node)
        node.set_auth("admin", "admin")
        node.sync()
        
    def testNormal(self):
        f = heupdater.HyperEstraierUpdater(
            {"node": "http://localhost:1978/node/test/"},
            None)
        content = {"entries":[
            {"title": u"hoge",
             "link": u"http://localhost/test/1",
             "summary": u"Hello, \n my world."},
            {"title": u"hoge 2",
             "link": u"http://localhost/test/2",
             "summary": u"Hello, \n my world 2."}
            ]}
        f.execute(content)
        dl = f.running_tasks
        return defer.DeferredList(dl, fireOnOneErrback=True)

    def testSimple(self):
        f = heupdater.HyperEstraierUpdater(
            {"node": "http://localhost:1978/node/test/"},
            None)
        entry = {"title": u"世界の果てまで言ってキュー",
                 "link": u"http://localhost/test/3",
                 "summary": u"こんにちは, \n 世界."}
        d = f._update(entry)
        return d.addCallback(self.assertEquals, True)

    

