
import hyperestraier as est
from habu.habuutils import toUTF8


class Searcher:
    def __init__(self, url, userid, password):
        self.url = url
        self.node = est.Node(est.AsynTransport())
        self.node.set_url(url)
        self.node.set_auth(userid, password)

    def search(self, phrase):
        cond = est.Condition()
        cond.set_phrase(phrase)
        deferred = self.node.search(cond, 0)
        deferred.addCallback(self._gotResult, phrase)
        
        return deferred

    def _txtFromSnippet(self, snippet):
        result = [line.split("\t")[0] for line in snippet.split("\n")]

        return "".join(result)

    def _gotResult(self, result, phrase):
        entries = []
        content = {"feed": {"link": self.url,
                            "title": "Search Result for %s" % toUTF8(phrase)},
                   "entries": entries
                   }
        for rdoc in result.docs:
            entry = {"title": rdoc.attr("@title"),
                     "link": rdoc.attr("@uri"),
                     "summary": self._txtFromSnippet(rdoc.snippet)
                     }
            entries.append(entry)
        
        return content
        
        


class HESearcher:
    def __init__(self, config, environ):
        url = config.get("node")
        userid = config.get("userid", "admin")
        password = config.get("password", "admin")
        self.searcher = Searcher(url, userid, password)
        self.phrase = config.get("phrase")
    
    def execute(self, content):
        return self.searcher.search(self.phrase)


def create(config, environ):
    return HESearcher(config, environ)

