from twisted.trial.unittest import TestCase
import StringIO
from habuutils import *
import feedparser

class UtilsTest(TestCase):
    def testMergeResult(self):
        content = [1,2,3]

        class SubModule1:
            def execute(self, content):
                return 4

        class SubModule2:
            def execute(self, content):
                return [5, 6, 7]

        class SubModule3:
            def execute(self, content):
                return []

        class SubModule4:
            def execute(self, content):
                return None

        result = mergeResult(content,
                                       [SubModule1(),
                                        SubModule2(),
                                        SubModule3(),
                                        SubModule4()])
        self.assertEquals(len(result), 7)

    def testConfigGet(self):
        config = {"key1": "config1",
                  "key2": "config2"}
        environ = {"key2": "environ2",
                   "key3": "environ3"}
        get = configGet
        self.assertEquals(get(config, environ, "key1"), "config1")
        self.assertEquals(get(config, environ, "key2"), "config2")
        self.assertEquals(get(config, environ, "key3"), "environ3")
        self.assertEquals(get(config, environ, "key4"), None)

        self.assertEquals(get(config, environ, "key1", "1"), "config1")
        self.assertEquals(get(config, environ, "key2", "2"), "config2")
        self.assertEquals(get(config, environ, "key3", "3"), "environ3")
        self.assertEquals(get(config, environ, "key4", "4"), "4")
        
    def testUniq(self):
        self.assertEquals(uniq([1,2,3,4]), [1,2,3,4])
        self.assertEquals(uniq([1,4,3,4]), [1,4,3])
        self.assertEquals(uniq([2,1,4,3,1,2,4,3]), [2,1,4,3])


class DecoTest(TestCase):
    def testAll(self):
        class C:
            @Sort(key="updated")
            def myfunc(self, c):
                return c
            
        c = C()
        r = c.myfunc({"entries":[{"updated": "3"},
                                 {"updated": "1"},
                                 {"updated": "3"},
                                 {"updated": "2"},
                                 ]})
        self.assertEquals(r["entries"][0]["updated"], "1")
        self.assertEquals(r["entries"][1]["updated"], "2")
        self.assertEquals(r["entries"][2]["updated"], "3")
        self.assertEquals(r["entries"][3]["updated"], "3")

        r = c.myfunc({"entries":[{"updated": 3},
                                 {"updated": 1},
                                 {"updated": 3},
                                 {"updated": 2},
                                 ]})
        self.assertEquals(r["entries"][0]["updated"], 1)
        self.assertEquals(r["entries"][1]["updated"], 2)
        self.assertEquals(r["entries"][2]["updated"], 3)
        self.assertEquals(r["entries"][3]["updated"], 3)
        

        def myGetKey(a):
            return a.get("updated")

        class C:
            @Grep(exclusive=True, updated="2")
            @Sort(key=myGetKey, reverse=True)
            def myfunc(self, c):
                return c


        c = C()
        r = c.myfunc({"entries":[{"updated": "3"},
                                 {"updated": "1"},
                                 {"updated": "4"},
                                 {"updated": "2"},
                                 ]})
        self.assertEquals(r["entries"][0]["updated"], "4")
        self.assertEquals(r["entries"][1]["updated"], "3")
        self.assertEquals(r["entries"][2]["updated"], "1")


        import re
        class C:
            @Grep(updated=re.compile("[1|3|4]"))
            @Sort(key=myGetKey, reverse=True)
            def myfunc(self, c):
                return c

        c = C()
        r = c.myfunc({"entries":[{"updated": "3"},
                                 {"updated": "1"},
                                 {"updated": "4"},
                                 {"updated": "2"},
                                 ]})

        self.assertEquals(r["entries"][0]["updated"], "4")
        self.assertEquals(r["entries"][1]["updated"], "3")
        self.assertEquals(r["entries"][2]["updated"], "1")



class RssTest(TestCase):
    content = {"entries": [
        {"title": u"my title<>&='",
         "author": "my",
         "updated": u"2007-02-20T18:16:02Z",
         "updated_parsed": (2007, 2, 20, 18, 16, 2),
         "link": u"http://localhost/somewhere",
         "summary": u"Hello, World"},
        {"title": u"my title<>&='",
         "author": "my",
         "updated": u"2007-02-20T18:16:02Z",
         "updated_parsed": (2007, 2, 20, 18, 16, 2),
         "link": u"http://localhost/somewhere2",
         "summary": u"Hello, World",
         "summary_detail": {"type": "text/html",
                            "value": "<b>Hello</b>, world"}},
        ]}
    
    def testRss(self):
        io = StringIO.StringIO()
        dumpRSS(self.content, io)
        feedparser.parse(io.getvalue())

    def testAtom(self):
        io = StringIO.StringIO()
        dumpRSS(self.content, io, "atom1.0")
        value = io.getvalue()
        feedparser.parse(value)


