#!/usr/bin/env python
#-------------------------------------------------------------------------------
# Name:        
# Purpose:     
#
# Author:      Jia Lu
#
# Created:     09/04/2007
# Copyright:   (c) Jia Lu 2007
# Licence:     <GPL>
#-------------------------------------------------------------------------------


import wx
from wx.lib.wordwrap import wordwrap
#import wx.lib.mixins.listctrl as listmix
import wx.richtext as rt
import time
import os

try:
    import cStringIO
except:
    import StringIO as cStringIO

try:
    import psyco
    psyco.log()
    psyco.profile()
except:
    pass

import sys
sys.path.insert(1, "./modules")    
import rfc
import rfcContents

class AppFrame(wx.Frame):
    def __init__(self):
##        wx.Frame.__init__(self, None, -1, "File Seeker", pos=wx.DefaultPosition,
##                size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE)
        wx.Frame.__init__(self, None, -1, "RFC Seeker", pos=wx.DefaultPosition,
                size=(800,600), style=wx.DEFAULT_FRAME_STYLE)
        self.initpos = 0

        self.WarningPopup()

        self.SetTitleIcon()
        self.MkStatusbar()
        self.MkMenus()

        self.MkSplitter() 
        self.MkSearchCtrl()  
        self.MkListCtrl()
        self.MkRichText()     
        self.Layout()
        
        self.Centre()
        self.SetFocus()
        
##        self.sp1.Bind(wx.EVT_ENTER_WINDOW, self.OnActivateSp1)
##        self.sp1.Bind(wx.EVT_LEAVE_WINDOW, self.OnLeaveSp1)
##        self.sp2.Bind(wx.EVT_ENTER_WINDOW, self.OnActivateSp2)
##        self.sp2.Bind(wx.EVT_LEAVE_WINDOW, self.OnLeaveSp2)        
        
        # Init rfc config file
        rfc.read_config_file()

    def WarningPopup(self):

        msg = "Please make sure the HTTP access to INTERNET!" + \
              "\n\n" + \
              "Powered By wxPython " + wx.VERSION_STRING + "!"
              
        dlg = wx.MessageDialog(self, msg, "RFC",
                               wx.OK | wx.CANCEL| wx.ICON_INFORMATION)
        response = dlg.ShowModal()
        if response == wx.ID_CANCEL:
            dlg.Destroy()
            self.Close()
        dlg.Destroy()  

    def MkListCtrl(self):
##        self.pnl = wx.Panel(self.sp1, -1)
##        self.pnl.SetBackgroundColour('green') 
        
        self.list=wx.ListCtrl(self.sp1, id=wx.NewId(), style=wx.LC_REPORT|wx.SUNKEN_BORDER)

        self.list.InsertColumn(0,"RFC")
        self.list.InsertColumn(1,"Keywords")
        self.list.SetColumnWidth(0, 40)
        self.list.SetColumnWidth(1, 200)
        
##        self.list.InsertStringItem(0,"2240")
##        self.list.SetStringItem(0,1,"Hellow world...")
##        self.list.InsertStringItem(1,"220")
##        self.list.SetStringItem(1,1,"Hellow world...")
        self.list.Show(True)        
        
        self.Bind(wx.EVT_LIST_ITEM_SELECTED, self.OnShowListDetail)
         
        
    def MkSearchCtrl(self):
        self.search = wx.SearchCtrl(self.sp1, size=wx.DefaultSize, style=wx.TE_PROCESS_ENTER)
        self.search.ShowCancelButton(True)
        #self.search.ShowSearchButton(True)
        
        self.search.Bind(wx.EVT_TEXT, self.OnSearchText)
        self.search.Bind(wx.EVT_SEARCHCTRL_CANCEL_BTN, self.OnSearchCancel)
        #self.search.Bind(wx.EVT_SEARCHCTRL_SEARCH_BTN, self.OnSearchStart)
        self.Bind(wx.EVT_TEXT_ENTER, self.OnDoSearch, self.search)
        
    def MkSplitter(self):
        self.splitter = MySplitter(self, -1)

        sty = wx.BORDER_NONE
        #sty = wx.BORDER_SIMPLE
        #sty = wx.BORDER_SUNKEN
        
        self.sp1 = wx.Panel(self.splitter, style=sty)
        self.sp1.SetBackgroundColour("pink")
        #wx.StaticText(self.sp1, -1, "Panel One", (5,5))

        self.sp2 = wx.Panel(self.splitter, style=sty)
        #self.sp2.SetBackgroundColour("sky blue")
        #wx.StaticText(self.sp2, -1, "Panel Two", (5,5))

        self.splitter.SetMinimumPaneSize(1)
        self.splitter.SplitVertically(self.sp1, self.sp2, 200)
        
    def MkRichText(self):
        self.rtc = rt.RichTextCtrl(self.sp2, style=wx.VSCROLL|wx.HSCROLL|wx.NO_BORDER)
        self.rtc.BeginFontSize(10)
        self.rtc.BeginTextColour((0, 0, 200))
        self.rtc.SetEditable(False)
        #self.rtc.Disable()

    def Layout(self):
        
##        pnl1 = wx.Panel(self.sp1, -1)
##        pnl1.SetBackgroundColour('yellow')
       
        #self.splitter.SplitVertically(self.sp1, pnl2, -160)
        leftBox = wx.BoxSizer(wx.VERTICAL)
        leftBox.Add(self.search,0, wx.EXPAND)
        leftBox.Add(self.list,1, wx.EXPAND)       
##        leftBox.Add(self.search, 1, wx.EXPAND)
##        leftBox.Add(wx.StaticText(self.sp1, label = "Filter Demos:"), 0, wx.TOP|wx.LEFT, 5)
        self.sp1.SetSizer(leftBox)
        
        rightBox = wx.BoxSizer(wx.VERTICAL)
        rightBox.Add(self.rtc, 1, wx.EXPAND)
        self.sp2.SetSizer(rightBox)
        
        #self.sizer.Fit(self)


    def SetTitleIcon(self):
        """
            Make an icon on the title bar.
        """
        icon = wx.EmptyIcon()
        icon.CopyFromBitmap(wx.BitmapFromImage(wx.ImageFromStream(cStringIO.StringIO(getIconData()))))
        self.SetIcon(icon)


    def MkStatusbar(self):
        """
            Make a StatusBar.
        """
        self.sb = MyStatusBar(self)
        self.SetStatusBar(self.sb)

    ### MAKE MENUS FROM HERE ###
    def MkMenus(self):
        self.MainMenu = wx.MenuBar()
        self.AddMenus(self.MainMenu)
        self.SetMenuBar(self.MainMenu)

    def AddMenus(self, menu):
        self.AddFileMenu(menu)
        self.AddSearchMenu(menu)
        self.AddHelpMenu(menu)

    def AddMenuItem(self, menu, itemText, itemDescription, itemHandler):
        menuId = wx.NewId()
        menu.Append(menuId, itemText, itemDescription)
        self.Bind(wx.EVT_MENU, itemHandler, id=menuId)
        return menuId

    def AddFileMenu(self, menu):
        fileMenu = wx.Menu()
        #self.AddMenuItem(fileMenu, '&New File\tCtrl-N', 'New File', self.OnNewFile)
        #self.AddMenuItem(fileMenu, '&Open File\tCtrl-O', 'Open File', self.OnOpenFile)
        #self.AddMenuItem(fileMenu, '&Save File\tCtrl-S', 'Save File', self.OnSaveFile)
        #self.AddMenuItem(fileMenu, 'Save File &As\tCtrl-A', 'Save File As',self.OnSaveFileAs)
        self.AddMenuItem(fileMenu, 'E&xit\tAlt-X', 'Exit', self.OnExit)
        menu.Append(fileMenu, '&File')

    def AddSearchMenu(self, menu):
        SearchMenu = wx.Menu()
        #self.AddMenuItem(editMenu, 'Cut\tCtrl-X', 'Cut', self.edl.OnCutSelection)
        #self.AddMenuItem(editMenu, '&Copy\tCtrl-C', 'Copy', self.edl.OnCopySelection)
        #self.AddMenuItem(editMenu, 'Paste\tCtrl-V', 'Paste', self.edl.OnPaste)
        self.AddMenuItem(SearchMenu, '&Update Index', 'Update RFC DB index.', self.OnUpdateIndex)
        #self.AddMenuItem(SearchMenu, '&Update RFC DB', 'Update RFC DB contents.', self.OnUpdateDB)
        menu.Append(SearchMenu, '&Search')
        

    def AddHelpMenu(self, menu):
        helpMenu = wx.Menu()
        item = wx.MenuItem(helpMenu, -1, "&About Me", "About this program.")
        #item.SetBitmap(wx.BitmapFromImage(wx.ImageFromStream(cStringIO.StringIO(getIconData()))))
        helpMenu.AppendItem(item)
        menu.Append(helpMenu, '&Help')
        
        self.Bind(wx.EVT_MENU, self.OnHelpAbout, id=item.GetId())

    def OnShowListDetail(self, evt):
        self.currentItem = evt.m_itemIndex
        self.currentItemNo = self.Sortedrfc[int(self.currentItem)]
        self.sb.SetStatusText("OK - %s - %s" % 
                (
                self.currentItem,
                self.currentItemNo,
                ))
        busy = wx.BusyInfo("One moment please, Downloading...")
        wx.Yield()
        
        the_rfc = rfcContents.getRFC(self.currentItemNo)
        busy.Destroy()
        
        self.rtc.Clear()
        self.rtc.WriteText(the_rfc)

    def OnActivateSp1(self, evt):
        self.sp1.SetBackgroundColour("black")

    def OnActivateSp2(self, evt):
        self.sp2.SetBackgroundColour("black")

    def OnLeaveSp1(self, evt):
        self.sp1.SetBackgroundColour("green")
        
    def OnLeaveSp2(self, evt):
        self.sp2.SetBackgroundColour("light blue")

    def OnSearchText(self, evt):
        #self.OnDoSearch(evt)
        pass
    
    def OnSearchCancel(self, evt):
        self.search.SetValue('')
    
    def OnSearchStart(self, evt):
        pass
    
    def OnDoSearch(self, evt):
        if self.search.GetValue().strip() == "":
            self.search.SetValue("")
            return
        
        rfcNo = []
        keywords = []

        # Show BusyInfo to wait
        busy = wx.BusyInfo("One moment please, searching...")
        wx.Yield()
        
        rfcNo, keywords, match = rfc.search_rfc(self.search.GetValue().strip())
        self.Sortedrfc = rfcNo[:]
        self.Sortedrfc.sort()
        keywordsDict = dict(zip(rfcNo, keywords))
        
##      # Method 1: use list  
        # Clear list items before insert items
        self.list.DeleteAllItems()
        for index in xrange(len(self.Sortedrfc)):
            self.list.InsertStringItem(index, self.Sortedrfc[index])
            self.list.SetStringItem(index,1, keywordsDict.get(self.Sortedrfc[index]))
        
        #print rfcNo
        #print keywords
        if match == 0:
            self.sb.SetStatusText("No match")
        else:
            self.sb.SetStatusText("%d matches."%match)
        
        # Close BosyInfo    
        busy.Destroy()

    def OnUpdateIndex(self,evt):
        self.sb.SetStatusText("Updating Index...")
        self.search.Disable()
        rfc.download_rfc_index()
        self.sb.SetStatusText("Index Updating finished.")
        self.search.Enable()
       #wx.StaticText(self.pnl1, -1, "Panel One", (5,5))


    def OnHelpAbout(self, evt):
        licenseText = ""
        
        info = wx.AboutDialogInfo()
        info.Name = "RFC Seeker"
        info.Version = "0.0.1"
        info.Copyright = "(C) 2007 Jia Lu"
        info.Description = wordwrap(
            "This RFC Seeker is an application for fun and personal use",
            350, wx.ClientDC(self))
        info.WebSite = ("http://www.lujia.us", "Jia Lu's home page")
        info.Developers = [ "Jia Lu (roka100_AT_gMail_dot_COM)", ]
        
        info.License = wordwrap(licenseText, 500, wx.ClientDC(self))

        # Then we call wx.AboutBox giving it that info object
        wx.AboutBox(info)        

    def OnExit(self, evt):
        self.sb.SetStatusText("Exiting...")
        self.Destroy()

class MySplashScreen(wx.SplashScreen):
    def __init__(self, parent=None):
        #bitmap = wx.Image(name = "image.jpg").ConvertToBitmap()
        bitmap = wx.BitmapFromImage(wx.ImageFromStream(cStringIO.StringIO(getIconData())))
        splashStyle = wx.SPLASH_CENTRE_ON_SCREEN | wx.SPLASH_TIMEOUT
        splashDuration = 500 # milliseconds

        wx.SplashScreen.__init__(self, bitmap, splashStyle, splashDuration, parent)
        self.Bind(wx.EVT_CLOSE, self.OnSplashExit)
        
        self.fc = wx.FutureCall(2000, self.Main)

        # ???
        wx.Yield()

    def OnSplashExit(self, evt):
        self.Hide()
##        MyFrame = AppFrame()
##        #app.SetTopWindow(MyFrame)
##        MyFrame.Show(True)
        # NOTE: freeze without Skip()
        evt.Skip()
        
        if self.fc.IsRunning():
            self.fc.Stop()
            self.Main()
    
    def Main(self):
        MyFrame = AppFrame()
        #app.SetTopWindow(MyFrame)
        MyFrame.Show(True)
        if self.fc.IsRunning():
            self.Raise()       

##class CreateIndexList(listmix.ColumnSorterMixin):
##    def __init__(self):
##        self.list = MyListCtrl(self, tID,
##                                    style=wx.LC_REPORT 
##                                    #| wx.BORDER_SUNKEN
##                                    | wx.BORDER_NONE
##                                    | wx.LC_EDIT_LABELS
##                                    | wx.LC_SORT_ASCENDING
##                                    #| wx.LC_NO_HEADER
##                                    #| wx.LC_VRULES
##                                    #| wx.LC_HRULES
##                                    #| wx.LC_SINGLE_SEL
##                                    )
##        self.list.InsertColumn(0, "RFC")
##        self.list.InsertColumn(1, "Keywords")
##        
##        listmix.ColumnSorterMixin.__init__(self, 2)
##        
##
##class MyListCtrl(wx.ListCtrl, listmix.ListCtrlAutoWidthMixin):
##    def __init__(self, parent, ID, pos=wx.DefaultPosition,
##                 size=wx.DefaultSize, style=0):
##        wx.ListCtrl.__init__(self, parent, ID, pos, size, style)
##        listmix.ListCtrlAutoWidthMixin.__init__(self)

class MySplitter(wx.SplitterWindow):
    def __init__(self, parent, ID):
        wx.SplitterWindow.__init__(self, parent, ID,
                                   style = wx.SP_LIVE_UPDATE
                                   )
        
        self.Bind(wx.EVT_SPLITTER_SASH_POS_CHANGED, self.OnSashChanged)
        self.Bind(wx.EVT_SPLITTER_SASH_POS_CHANGING, self.OnSashChanging)

    def OnSashChanged(self, evt):
        pass

    def OnSashChanging(self, evt):
        # uncomment this to not allow the change
        #evt.SetSashPosition(-1)
        pass


class MyApp(wx.App):
    def OnInit(self):
        MySplash = MySplashScreen()
        MySplash.Show()
        return True


#----------------------------------------------------------------------------

class MyStatusBar(wx.StatusBar):
    def __init__(self, parent):
        wx.StatusBar.__init__(self,parent,-1)
        self.SetStatusText("Started successfully!",0)

def getIconData():
    return \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\x00\x00 \x08\x06\x00\
\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\x01\
\x94IDATX\x85\xb5WAn\xc4 \x0c\xf4@\x7f\xd2>\xa5y5}J\xbe\x92\xb8\x87\r\xac\
\x01c\x02dGZiE\x103L\x06\x9b\x00\xce\x93\x05>\x0f\x8e\xff\xe1<\xcc\xc9\x13\
\xf8\xea\x913\'~\x02\xc0O\x8bh\n(\xc9\x89\x88\x98\x99\x00d\x83\xab\x82T\x01\
\x99\xed@"\x97B\xc4\xf3%W\\I\xcc\xe7\xc1\x14\xc4\x18s"\x04@\x9a+R\xf0(\x92\
\x03%1\x05\x9d0\n\x89\xe4\xab0C\x18E\x94x\x828\x02p\xbe\xde\xbd\x85\xad\xca\
\x00Qx\x8d\xcfd\xc1\xf5\xa7\x14\xb8\\\x89\xbf$<\xd0T\x16\x10\x0b\xd1\x90\x0b\
-L\xb80\xee\x80\x85\t\x17\x92\x008\x0f\xda\x88h3f[\xcf&\x91\x9d\x028\x8f\xfd\
<\xf8\xbbE\xb4\xfa\x8a\x14@6\xa3\xfd<\xf8\xc7x\x87\x99\xbd\x96\x18\x91\x85^3\
K\x0e\xf4\xc8\xcb\x05x\xbb\x166\x84TUu;\xaa\xb2=\x1dB8\x8f\x94\x1bcN\x96+%\
\xa4\x8e\xe8\xbd\xfb}0\xc1\xaf\x8e\xa9<\x10D=\xa1\xe8]H\xee\x92\xe3O\x99Tf!\
\xd4\xe3\xcf\xd6\x01\x03-\x17\x86\x05\xc4\x96]Z\xcf\xbf\xca\xe4Va\x12\xe3\
\xb7\x05hw\x85Qh.\xd8\xedX\x90\x7f\xa2\x08\x11\xddp\xe0\x93\xe4]\x01#\xe4\
\xea)\x90\xeb\xcc\x08P1\xd3\x90B;C\xe6\xb5\xbc\xda\xbd8\xbf\xc0\xfb$X\xbb\
\x97"4,\xd7\x01\x93\xbc\xe5V\xb6\x91F%l\xbe\x7fQ\xd7\xbb\xb8\x88\xca\x0c\xc8\
\x86t\xeb\x18f\x18\xb8\xbc\xa6]\x1a]\xd6\xec\x05\xc3GPX~\xf7n\xd8mF\xc9\xbe\
\x96\x90\t\xd2!\x01\x95\x90r\x81\xc5\x8f\xd3\x7f\xa5\x8a\t\xa7\x8d\x89\xeak\
\x00\x00\x00\x00IEND\xaeB`\x82'

def getSplashData():
    return \
'\xff\xd8\xff\xe0\x00\x10JFIF\x00\x01\x01\x01\x01,\x01,\x00\x00\xff\xdb\x00C\x00\x03\x02\x02\x03\x02\x02\x03\x03\x03\x03\x04\x03\x03\x04\x05\x08\x05\x05\x04\x04\x05\n\x07\x07\x06\x08\x0c\n\x0c\x0c\x0b\n\x0b\x0b\r\x0e\x12\x10\r\x0e\x11\x0e\x0b\x0b\x10\x16\x10\x11\x13\x14\x15\x15\x15\x0c\x0f\x17\x18\x16\x14\x18\x12\x14\x15\x14\xff\xdb\x00C\x01\x03\x04\x04\x05\x04\x05\t\x05\x05\t\x14\r\x0b\r\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\xff\xc0\x00\x11\x08\x02\x05\x02~\x03\x01"\x00\x02\x11\x01\x03\x11\x01\xff\xc4\x00\x1f\x00\x00\x01\x05\x01\x01\x01\x01\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\xff\xc4\x00\xb5\x10\x00\x02\x01\x03\x03\x02\x04\x03\x05\x05\x04\x04\x00\x00\x01}\x01\x02\x03\x00\x04\x11\x05\x12!1A\x06\x13Qa\x07"q\x142\x81\x91\xa1\x08#B\xb1\xc1\x15R\xd1\xf0$3br\x82\t\n\x16\x17\x18\x19'

def main():
    #app = wx.PySimpleApp()
    app = MyApp(redirect=False)
    #win = AppFrame()
    #win.Show(True)

    app.MainLoop()


if __name__ == '__main__':
    main()
    
#TODO: Fix menu press hang.
#TODO: Fix ListCtrl title autowidthsize as contents
#TODO: Fix search algorithm enhance
#TODO: Add thread op for search
