/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.metal.MetalMenuItemUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class MetalMenuUI
extends MetalMenuItemUI {
    private ChangeListener changeListener;
    private PropertyChangeListener propertyChangeListener;
    private MenuListener menuListener;
    private int lastMnemonic = 0;
    private static boolean crossMenuMnemonic = true;
    private boolean isMouseOver = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateDefaultBackgroundColor();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIDefaultsLookup.getBoolean("Menu.crossMenuMnemonic");
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = null;
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            MetalMenuUI metalMenuUI = this;
            this.propertyChangeListener = new PropertyChangeHandler(metalMenuUI);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = null;
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    final void updateMnemonicBinding() {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int n4 = this.menuItem.getModel().getMnemonic();
        int[] nArray2 = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
        if (n4 == this.lastMnemonic || nArray2 == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            nArray = nArray2;
            n3 = nArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = nArray[n2];
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, n, false));
            }
        }
        if (n4 != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            nArray = nArray2;
            n3 = nArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = nArray[n2];
                this.windowInputMap.put(KeyStroke.getKeyStroke(n4, n, false), "selectMenu");
            }
        }
        this.lastMnemonic = n4;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    final ActionMap getActionMap() {
        return this.createActionMap();
    }

    final ActionMap createActionMap() {
        ActionMap actionMap = super.createActionMap();
        if (actionMap != null) {
            actionMap.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
        }
        return actionMap;
    }

    protected MouseInputListener createMouseInputListener$3921fa06() {
        return new MouseInputHandler(this);
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected final MenuDragMouseListener createMenuDragMouseListener$546f662f() {
        return new MenuDragMouseHandler(this);
    }

    protected final MenuKeyListener createMenuKeyListener$65e00b43() {
        return new MenuKeyHandler(this);
    }

    public Dimension getMaximumSize(JComponent serializable) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            serializable = serializable.getPreferredSize();
            return new Dimension(((Dimension)serializable).width, Short.MAX_VALUE);
        }
        return null;
    }

    protected static void setupPostTimer(JMenu serializable) {
        serializable = new Timer(((JMenu)serializable).getDelay(), new PostAction((JMenu)serializable, false));
        ((Timer)serializable).setRepeats(false);
        ((Timer)serializable).start();
    }

    protected static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    private void updateDefaultBackgroundColor() {
        if (!UIDefaultsLookup.getBoolean("Menu.useMenuBarBackgroundForTopLevel")) {
            return;
        }
        JMenu jMenu = (JMenu)this.menuItem;
        if (jMenu.getBackground() instanceof UIResource) {
            if (jMenu.isTopLevelMenu()) {
                jMenu.setBackground(UIDefaultsLookup.getColor("MenuBar.background"));
                return;
            }
            jMenu.setBackground(UIDefaultsLookup.getColor(this.getPropertyPrefix() + ".background"));
        }
    }

    static JPopupMenu getActivePopupMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i = menuElementArray.length - 1; i >= 0; --i) {
            MenuElement menuElement = menuElementArray[i];
            if (!(menuElement instanceof JPopupMenu)) continue;
            return (JPopupMenu)menuElement;
        }
        return null;
    }

    protected final void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
        this.menuItem.getModel().setRollover(this.isMouseOver);
    }

    protected final boolean isMouseOver() {
        return this.isMouseOver;
    }

    public Dimension getPreferredSize(JComponent serializable) {
        serializable = super.getPreferredSize((JComponent)serializable);
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu() && MetalMenuUI.isDownArrowVisible(this.menuItem.getParent())) {
            if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
                ((Dimension)serializable).width += 11;
            } else {
                ((Dimension)serializable).height += 11;
            }
        }
        return serializable;
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        int n;
        int n2;
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            return;
        }
        Color color2 = graphics.getColor();
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n2 = jMenuItem.getWidth();
            n = jMenuItem.getHeight();
        } else {
            n2 = jMenuItem.getHeight();
            n = jMenuItem.getWidth();
        }
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getModel().isArmed() || jMenuItem instanceof JMenu && jMenuItem.getModel().isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n2, n);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n2, n);
            }
            graphics.setColor(color2);
        }
        if (MetalMenuUI.isDownArrowVisible(jMenuItem.getParent())) {
            graphics.setColor(Color.BLACK);
            int n3 = n2 - 9;
            graphics.drawLine(n3 - 2, n / 2 - 1, n3 + 2, n / 2 - 1);
            graphics.drawLine(n3 - 1, n / 2, n3 + 1, n / 2);
            graphics.drawLine(n3, n / 2 + 1, n3, n / 2 + 1);
        }
    }

    final class MenuKeyHandler
    implements MenuKeyListener {
        private /* synthetic */ MetalMenuUI this$0;

        private MenuKeyHandler(MetalMenuUI metalMenuUI, byte by) {
            this.this$0 = metalMenuUI;
        }

        public final void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            JPopupMenu jPopupMenu;
            if (!crossMenuMnemonic && (jPopupMenu = MetalMenuUI.getActivePopupMenu()) != null && jPopupMenu != this.this$0.menuItem.getParent()) {
                return;
            }
            int n = this.this$0.menuItem.getMnemonic();
            if (n == 0) {
                return;
            }
            Object object = menuKeyEvent.getPath();
            char c = (char)n;
            n = c;
            char c2 = menuKeyEvent.getKeyChar();
            n = c2;
            if (Character.toLowerCase(c) == Character.toLowerCase(c2)) {
                Object object2 = ((JMenu)this.this$0.menuItem).getPopupMenu();
                object = new ArrayList<MenuElement>(Arrays.asList(object));
                ((ArrayList)object).add((MenuElement)object2);
                object2 = ((JPopupMenu)object2).getSubElements();
                if (((MenuElement[])object2).length > 0) {
                    ((ArrayList)object).add(object2[0]);
                }
                object2 = menuKeyEvent.getMenuSelectionManager();
                MenuElement[] menuElementArray = new MenuElement[]{};
                menuElementArray = ((ArrayList)object).toArray(menuElementArray);
                ((MenuSelectionManager)object2).setSelectedPath(menuElementArray);
                menuKeyEvent.consume();
            }
        }

        public final void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            char c = menuKeyEvent.getKeyChar();
            if (!Character.isLetterOrDigit(c)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            Object object = menuSelectionManager.getSelectedPath();
            for (int i = ((MenuElement[])object).length - 1; i >= 0; --i) {
                if (object[i] != this.this$0.menuItem) continue;
                JPopupMenu jPopupMenu = ((JMenu)this.this$0.menuItem).getPopupMenu();
                if (!jPopupMenu.isVisible()) {
                    return;
                }
                MenuElement[] menuElementArray2 = jPopupMenu.getSubElements();
                object = object[((MenuElement[])object).length - 1];
                int n = -1;
                int n2 = 0;
                int n3 = -1;
                int[] nArray = null;
                for (int j = 0; j < menuElementArray2.length; ++j) {
                    int n4 = ((JMenuItem)menuElementArray2[j]).getMnemonic();
                    char c2 = (char)n4;
                    n4 = c2;
                    char c3 = c;
                    n4 = c3;
                    if (Character.toLowerCase(c2) == Character.toLowerCase(c3)) {
                        if (n2 == 0) {
                            n3 = j;
                            ++n2;
                        } else {
                            if (nArray == null) {
                                int[] nArray2 = new int[menuElementArray2.length];
                                nArray = nArray2;
                                nArray2[0] = n3;
                            }
                            nArray[n2++] = j;
                        }
                    }
                    if (object != menuElementArray2[j]) continue;
                    n = n2 - 1;
                }
                if (n2 != 0) {
                    if (n2 == 1) {
                        JMenuItem jMenuItem = (JMenuItem)menuElementArray2[n3];
                        if (!(jMenuItem instanceof JMenu)) {
                            menuSelectionManager.clearSelectedPath();
                            jMenuItem.doClick();
                        }
                    } else {
                        MenuElement menuElement = menuElementArray2[nArray[(n + 1) % n2]];
                        MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 2];
                        System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                        menuElementArray3[menuElementArray.length] = jPopupMenu;
                        menuElementArray3[menuElementArray.length + 1] = menuElement;
                        menuSelectionManager.setSelectedPath(menuElementArray3);
                    }
                }
                menuKeyEvent.consume();
                return;
            }
        }

        public final void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        /* synthetic */ MenuKeyHandler(MetalMenuUI metalMenuUI) {
            this(metalMenuUI, 0);
        }
    }

    final class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private /* synthetic */ MetalMenuUI this$0;

        private MenuDragMouseHandler(MetalMenuUI metalMenuUI, byte by) {
            this.this$0 = metalMenuUI;
        }

        public final void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            if (!this.this$0.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Serializable serializable = menuDragMouseEvent.getPoint();
            if (((Point)serializable).x >= 0 && ((Point)serializable).x < this.this$0.menuItem.getWidth() && ((Point)serializable).y >= 0 && ((Point)serializable).y < this.this$0.menuItem.getHeight()) {
                serializable = (JMenu)this.this$0.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length > 0) {
                    if (menuElementArray2[menuElementArray2.length - 1] == ((JMenu)serializable).getPopupMenu()) return;
                }
                if (!((JMenu)serializable).isTopLevelMenu() && ((JMenu)serializable).getDelay() != 0 && menuDragMouseEvent.getID() != 506) {
                    menuSelectionManager.setSelectedPath(menuElementArray);
                    MetalMenuUI.setupPostTimer((JMenu)serializable);
                    return;
                }
                MetalMenuUI.appendPath(menuElementArray, ((JMenu)serializable).getPopupMenu());
                return;
            }
            if (menuDragMouseEvent.getID() != 502) return;
            serializable = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint());
            if (serializable != null) return;
            menuSelectionManager.clearSelectedPath();
        }

        public final void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public final void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }

        /* synthetic */ MenuDragMouseHandler(MetalMenuUI metalMenuUI) {
            this(metalMenuUI, 0);
        }
    }

    public final class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ MetalMenuUI this$0;

        protected MouseInputHandler(MetalMenuUI metalMenuUI) {
            this.this$0 = metalMenuUI;
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
        }

        public final void mousePressed(MouseEvent serializable) {
            MenuElement[] menuElementArray;
            if (!(this.this$0.menuItem instanceof JMenu)) {
                return;
            }
            serializable = (JMenu)this.this$0.menuItem;
            if (!((Component)serializable).isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (((Component)serializable).getParent() instanceof JMenuBar || ((Component)serializable).getParent() instanceof TopLevelMenuContainer) {
                if (((JMenu)serializable).isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    menuElementArray = MouseInputHandler.getFirstParentMenuElement((Component)serializable);
                    if (menuElementArray != null && menuElementArray instanceof MenuElement) {
                        ArrayList<MenuElement[]> arrayList = new ArrayList<MenuElement[]>();
                        while (menuElementArray instanceof MenuElement) {
                            arrayList.add(0, menuElementArray);
                            if (menuElementArray instanceof JPopupMenu) {
                                menuElementArray = (Container)((JPopupMenu)menuElementArray).getInvoker();
                                continue;
                            }
                            menuElementArray = MouseInputHandler.getFirstParentMenuElement((Component)menuElementArray);
                        }
                        menuElementArray = new MenuElement[arrayList.size() + 1];
                        for (int i = 0; i < arrayList.size(); ++i) {
                            Container container = (Container)arrayList.get(i);
                            menuElementArray[i] = (MenuElement)((Object)container);
                        }
                        menuElementArray[arrayList.size()] = serializable;
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    } else {
                        MenuElement[] menuElementArray2 = new MenuElement[1];
                        MenuElement[] menuElementArray3 = menuElementArray2;
                        menuElementArray2[0] = serializable;
                        menuSelectionManager.setSelectedPath(menuElementArray3);
                    }
                }
            }
            if ((menuElementArray = menuSelectionManager.getSelectedPath()).length > 0 && menuElementArray[menuElementArray.length - 1] != ((JMenu)serializable).getPopupMenu()) {
                if (((JMenu)serializable).isTopLevelMenu() || ((JMenu)serializable).getDelay() == 0) {
                    MetalMenuUI.appendPath(menuElementArray, ((JMenu)serializable).getPopupMenu());
                    return;
                }
                MetalMenuUI.setupPostTimer((JMenu)serializable);
            }
        }

        private static Container getFirstParentMenuElement(Component component) {
            for (component = component.getParent(); component != null; component = component.getParent()) {
                if (!(component instanceof MenuElement)) continue;
                return component;
            }
            return null;
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!(this.this$0.menuItem instanceof JMenu)) {
                return;
            }
            Object object = (JMenu)this.this$0.menuItem;
            if (!((Component)object).isEnabled()) {
                return;
            }
            object = MenuSelectionManager.defaultManager();
            ((MenuSelectionManager)object).processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                ((MenuSelectionManager)object).clearSelectedPath();
            }
        }

        public final void mouseEntered(MouseEvent serializable) {
            if (!(this.this$0.menuItem instanceof JMenu)) {
                return;
            }
            serializable = (JMenu)this.this$0.menuItem;
            if (!((Component)serializable).isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!((JMenu)serializable).isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != ((JMenu)serializable).getPopupMenu()) {
                    if (((JMenu)serializable).getDelay() == 0) {
                        MetalMenuUI.appendPath(this.this$0.getPath(), ((JMenu)serializable).getPopupMenu());
                        return;
                    }
                    menuSelectionManager.setSelectedPath(this.this$0.getPath());
                    MetalMenuUI.setupPostTimer((JMenu)serializable);
                    return;
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == ((Component)serializable).getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[3];
                menuElementArray = menuElementArray2;
                menuElementArray2[0] = (MenuElement)((Object)((Component)serializable).getParent());
                menuElementArray[1] = serializable;
                menuElementArray[2] = ((JMenu)serializable).getPopupMenu();
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }

        public final void mouseExited(MouseEvent mouseEvent) {
        }

        public final void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public final void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    final class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ MetalMenuUI this$0;

        private PropertyChangeHandler(MetalMenuUI metalMenuUI, byte by) {
            this.this$0 = metalMenuUI;
        }

        public final void propertyChange(PropertyChangeEvent object) {
            if (((String)(object = ((PropertyChangeEvent)object).getPropertyName())).equals("mnemonic")) {
                this.this$0.updateMnemonicBinding();
                return;
            }
            if (((String)object).equals("ancestor")) {
                this.this$0.updateDefaultBackgroundColor();
            }
        }

        /* synthetic */ PropertyChangeHandler(MetalMenuUI metalMenuUI) {
            this(metalMenuUI, 0);
        }
    }

    static final class PostAction
    extends AbstractAction {
        private JMenu menu;
        private boolean force = false;

        PostAction(JMenu jMenu, boolean bl) {
            this.menu = jMenu;
            this.force = bl;
        }

        public final void actionPerformed(ActionEvent object) {
            if (!crossMenuMnemonic && (object = MetalMenuUI.getActivePopupMenu()) != null && object != this.menu.getParent()) {
                return;
            }
            object = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray;
                    MenuElement[] menuElementArray2 = this.menu.getPopupMenu().getSubElements();
                    if (menuElementArray2.length > 0) {
                        MenuElement[] menuElementArray3 = new MenuElement[4];
                        menuElementArray = menuElementArray3;
                        menuElementArray3[0] = (MenuElement)((Object)container);
                        menuElementArray[1] = this.menu;
                        menuElementArray[2] = this.menu.getPopupMenu();
                        menuElementArray[3] = menuElementArray2[0];
                    } else {
                        MenuElement[] menuElementArray4 = new MenuElement[3];
                        menuElementArray = menuElementArray4;
                        menuElementArray4[0] = (MenuElement)((Object)container);
                        menuElementArray[1] = this.menu;
                        menuElementArray[2] = this.menu.getPopupMenu();
                    }
                    ((MenuSelectionManager)object).setSelectedPath(menuElementArray);
                }
                return;
            }
            MenuElement[] menuElementArray = ((MenuSelectionManager)object).getSelectedPath();
            if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                MetalMenuUI.appendPath(menuElementArray, this.menu.getPopupMenu());
            }
        }

        public final boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }
}

