/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public final class ResizableMouseInputAdapter
extends MouseInputAdapter {
    private static Rectangle _startingBounds;
    private int _eventMouseScreenX;
    private int _eventMouseScreenY;
    private int _resizeCorner;
    private boolean _discardRelease = false;
    private Resizable _resizable;

    public ResizableMouseInputAdapter(Resizable resizable) {
        this._resizable = resizable;
    }

    private boolean isResizable(int n) {
        return this._resizable != null && (this._resizable.getResizableCorners() & n) != 0;
    }

    /*
     * Unable to fully structure code
     */
    public final void mousePressed(MouseEvent var1_1) {
        this._resizeCorner = 0;
        ResizableMouseInputAdapter._startingBounds = this._resizable.getComponent().getBounds();
        if (this._resizable.isTopLevel()) {
            var2_4 = new Point(ResizableMouseInputAdapter._startingBounds.x, ResizableMouseInputAdapter._startingBounds.y);
            SwingUtilities.convertPointToScreen((Point)var2_4, this._resizable.getComponent());
            ResizableMouseInputAdapter._startingBounds.x = var2_4.x;
            ResizableMouseInputAdapter._startingBounds.y = var2_4.y;
        }
        var2_4 = new Point(var1_1.getX(), var1_1.getY());
        SwingUtilities.convertPointToScreen((Point)var2_4, (Component)var1_1.getSource());
        this._eventMouseScreenX = var2_4.x;
        this._eventMouseScreenY = var2_4.y;
        if (var1_1.getSource() instanceof Resizable.ResizeCorner) {
            var2_4 = (Resizable.ResizeCorner)var1_1.getSource();
            this._resizeCorner = var2_4.getCorner();
        } else if (var1_1.getSource() == this._resizable.getComponent()) {
            var2_4 = this._resizable.getResizeInsets();
            if (var1_1.getX() <= var2_4.left) {
                this._resizeCorner = var2_4.top > 0 && var1_1.getY() < this._resizable.getResizeCornerSize() + var2_4.top ? 1 : (var2_4.bottom > 0 && var1_1.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - var2_4.bottom ? 64 : 128);
            } else if (var2_4.right > 0 && var1_1.getX() >= this._resizable.getComponent().getWidth() - var2_4.right) {
                this._resizeCorner = var2_4.top > 0 && var1_1.getY() < this._resizable.getResizeCornerSize() + var2_4.top ? 4 : (var2_4.bottom > 0 && var1_1.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - var2_4.bottom ? 16 : 8);
            } else if (var2_4.top > 0 && var1_1.getY() <= var2_4.top) {
                this._resizeCorner = var2_4.left > 0 && var1_1.getX() < this._resizable.getResizeCornerSize() + var2_4.left ? 1 : (var2_4.right > 0 && var1_1.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - var2_4.right ? 4 : 2);
            } else if (var2_4.bottom > 0 && var1_1.getY() >= this._resizable.getComponent().getHeight() - var2_4.bottom) {
                this._resizeCorner = var2_4.left > 0 && var1_1.getX() < this._resizable.getResizeCornerSize() + var2_4.left ? 64 : (var2_4.right > 0 && var1_1.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - var2_4.right ? 16 : 32);
            } else {
                this._discardRelease = true;
                return;
            }
        }
        var2_4 = Cursor.getDefaultCursor();
        if (!this.isResizable(this._resizeCorner)) ** GOTO lbl77
        var1_2 = this._resizable.getComponent().getComponentOrientation().isLeftToRight();
        switch (this._resizeCorner) {
            case 32: {
                v0 = 9;
                ** GOTO lbl59
            }
            case 2: {
                v0 = 8;
                ** GOTO lbl59
            }
            case 128: {
                var2_4 = Cursor.getPredefinedCursor(var1_2 != false ? 10 : 11);
                break;
            }
            case 8: {
                var2_4 = Cursor.getPredefinedCursor(var1_2 != false ? 11 : 10);
                break;
            }
            case 16: {
                var2_4 = Cursor.getPredefinedCursor(var1_2 != false ? 5 : 4);
                break;
            }
            case 64: {
                var2_4 = Cursor.getPredefinedCursor(var1_2 != false ? 4 : 5);
                break;
            }
            case 1: {
                var2_4 = Cursor.getPredefinedCursor(var1_2 != false ? 6 : 7);
                break;
            }
            case 4: {
                v0 = var1_2 != false ? 7 : 6;
lbl59:
                // 3 sources

                var2_4 = Cursor.getPredefinedCursor(v0);
            }
        }
        var1_3 = this._resizable.getComponent().getTopLevelAncestor();
        if (var1_3 instanceof JFrame) {
            ((JFrame)var1_3).getGlassPane().setVisible(true);
            ((JFrame)var1_3).getGlassPane().setCursor((Cursor)var2_4);
        } else if (var1_3 instanceof JApplet) {
            ((JApplet)var1_3).getGlassPane().setVisible(true);
            ((JApplet)var1_3).getGlassPane().setCursor((Cursor)var2_4);
        } else if (var1_3 instanceof JWindow) {
            ((JWindow)var1_3).getGlassPane().setVisible(true);
            ((JWindow)var1_3).getGlassPane().setCursor((Cursor)var2_4);
        } else {
            if (var1_3 instanceof JDialog) {
                ((JDialog)var1_3).getGlassPane().setVisible(true);
                ((JDialog)var1_3).getGlassPane().setCursor((Cursor)var2_4);
            }
            return;
lbl77:
            // 1 sources

            this._resizeCorner = 0;
        }
    }

    public final void mouseDragged(MouseEvent serializable) {
        if (_startingBounds == null) {
            return;
        }
        Point point = new Point(serializable.getX(), serializable.getY());
        serializable = (Component)serializable.getSource();
        SwingUtilities.convertPointToScreen(point, (Component)serializable);
        int n = this._eventMouseScreenX - point.x;
        int n2 = this._eventMouseScreenY - point.y;
        Dimension dimension = this._resizable.getComponent().getMinimumSize();
        Dimension dimension2 = this._resizable.getComponent().getMaximumSize();
        Point point2 = new Point(this._resizable.getComponent().getX(), this._resizable.getComponent().getY());
        if (this._resizable.isTopLevel()) {
            SwingUtilities.convertPointToScreen(point2, this._resizable.getComponent());
        }
        int n3 = point2.x;
        int n4 = point2.y;
        Rectangle rectangle = this._resizable.isTopLevel() ? new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE) : this._resizable.getComponent().getParent().getBounds();
        int n5 = this._resizeCorner;
        boolean bl = this._resizable.getComponent().getComponentOrientation().isLeftToRight();
        if (!bl) {
            switch (this._resizeCorner) {
                case 1: 
                case 4: 
                case 8: 
                case 16: 
                case 64: 
                case 128: {
                    n5 = 128;
                }
            }
        }
        switch (n5) {
            case 0: {
                return;
            }
            case 2: {
                if (ResizableMouseInputAdapter._startingBounds.height + n2 < dimension.height) {
                    n2 = -(ResizableMouseInputAdapter._startingBounds.height - dimension.height);
                } else if (ResizableMouseInputAdapter._startingBounds.height + n2 > dimension2.height) {
                    n2 = dimension2.height - ResizableMouseInputAdapter._startingBounds.height;
                }
                n3 = ResizableMouseInputAdapter._startingBounds.x;
                n4 = ResizableMouseInputAdapter._startingBounds.y - n2;
                n = ResizableMouseInputAdapter._startingBounds.width;
                n2 = ResizableMouseInputAdapter._startingBounds.height + n2;
                break;
            }
            case 4: {
                if (ResizableMouseInputAdapter._startingBounds.height + n2 < dimension.height) {
                    n2 = -(ResizableMouseInputAdapter._startingBounds.height - dimension.height);
                } else if (ResizableMouseInputAdapter._startingBounds.height + n2 > dimension2.height) {
                    n2 = dimension2.height - ResizableMouseInputAdapter._startingBounds.height;
                }
                if (ResizableMouseInputAdapter._startingBounds.width - n < dimension.width) {
                    n = ResizableMouseInputAdapter._startingBounds.width - dimension.width;
                } else if (ResizableMouseInputAdapter._startingBounds.width - n > dimension2.width) {
                    n = -(dimension2.width - ResizableMouseInputAdapter._startingBounds.width);
                }
                if (ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - n > rectangle.width) {
                    n = ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - rectangle.width;
                }
                n3 = ResizableMouseInputAdapter._startingBounds.x;
                n4 = ResizableMouseInputAdapter._startingBounds.y - n2;
                n = ResizableMouseInputAdapter._startingBounds.width - n;
                n2 = ResizableMouseInputAdapter._startingBounds.height + n2;
                break;
            }
            case 8: {
                if (ResizableMouseInputAdapter._startingBounds.width - n < dimension.width) {
                    n = ResizableMouseInputAdapter._startingBounds.width - dimension.width;
                } else if (ResizableMouseInputAdapter._startingBounds.width - n > dimension2.width) {
                    n = -(dimension2.width - ResizableMouseInputAdapter._startingBounds.width);
                }
                if (ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - n > rectangle.width) {
                    n = ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - rectangle.width;
                }
                n = ResizableMouseInputAdapter._startingBounds.width - n;
                n2 = ResizableMouseInputAdapter._startingBounds.height;
                break;
            }
            case 16: {
                if (ResizableMouseInputAdapter._startingBounds.width - n < dimension.width) {
                    n = ResizableMouseInputAdapter._startingBounds.width - dimension.width;
                } else if (ResizableMouseInputAdapter._startingBounds.width - n > dimension2.width) {
                    n = -(dimension2.width - ResizableMouseInputAdapter._startingBounds.width);
                }
                if (ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - n > rectangle.width) {
                    n = ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - rectangle.width;
                }
                if (ResizableMouseInputAdapter._startingBounds.height - n2 < dimension.height) {
                    n2 = ResizableMouseInputAdapter._startingBounds.height - dimension.height;
                } else if (ResizableMouseInputAdapter._startingBounds.height - n2 > dimension2.height) {
                    n2 = -(dimension2.height - ResizableMouseInputAdapter._startingBounds.height);
                }
                if (ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - n2 > rectangle.height) {
                    n2 = ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - rectangle.height;
                }
                n = ResizableMouseInputAdapter._startingBounds.width - n;
                n2 = ResizableMouseInputAdapter._startingBounds.height - n2;
                break;
            }
            case 32: {
                if (ResizableMouseInputAdapter._startingBounds.height - n2 < dimension.height) {
                    n2 = ResizableMouseInputAdapter._startingBounds.height - dimension.height;
                } else if (ResizableMouseInputAdapter._startingBounds.height - n2 > dimension2.height) {
                    n2 = -(dimension2.height - ResizableMouseInputAdapter._startingBounds.height);
                }
                if (ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - n2 > rectangle.height) {
                    n2 = ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - rectangle.height;
                }
                n = ResizableMouseInputAdapter._startingBounds.width;
                n2 = ResizableMouseInputAdapter._startingBounds.height - n2;
                break;
            }
            case 64: {
                if (ResizableMouseInputAdapter._startingBounds.height - n2 < dimension.height) {
                    n2 = ResizableMouseInputAdapter._startingBounds.height - dimension.height;
                } else if (ResizableMouseInputAdapter._startingBounds.height - n2 > dimension2.height) {
                    n2 = -(dimension2.height - ResizableMouseInputAdapter._startingBounds.height);
                }
                if (ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - n2 > rectangle.height) {
                    n2 = ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - rectangle.height;
                }
                if (ResizableMouseInputAdapter._startingBounds.width + n < dimension.width) {
                    n = -(ResizableMouseInputAdapter._startingBounds.width - dimension.width);
                } else if (ResizableMouseInputAdapter._startingBounds.width + n > dimension2.width) {
                    n = dimension2.width - ResizableMouseInputAdapter._startingBounds.width;
                }
                n3 = ResizableMouseInputAdapter._startingBounds.x - n;
                n4 = ResizableMouseInputAdapter._startingBounds.y;
                n = ResizableMouseInputAdapter._startingBounds.width + n;
                n2 = ResizableMouseInputAdapter._startingBounds.height - n2;
                break;
            }
            case 128: {
                if (ResizableMouseInputAdapter._startingBounds.width + n < dimension.width) {
                    n = -(ResizableMouseInputAdapter._startingBounds.width - dimension.width);
                } else if (ResizableMouseInputAdapter._startingBounds.width + n > dimension2.width) {
                    n = dimension2.width - ResizableMouseInputAdapter._startingBounds.width;
                }
                n3 = ResizableMouseInputAdapter._startingBounds.x - n;
                n4 = ResizableMouseInputAdapter._startingBounds.y;
                n = ResizableMouseInputAdapter._startingBounds.width + n;
                n2 = ResizableMouseInputAdapter._startingBounds.height;
                break;
            }
            case 1: {
                if (ResizableMouseInputAdapter._startingBounds.width + n < dimension.width) {
                    n = -(ResizableMouseInputAdapter._startingBounds.width - dimension.width);
                } else if (ResizableMouseInputAdapter._startingBounds.width + n > dimension2.width) {
                    n = dimension2.width - ResizableMouseInputAdapter._startingBounds.width;
                }
                if (ResizableMouseInputAdapter._startingBounds.height + n2 < dimension.height) {
                    n2 = -(ResizableMouseInputAdapter._startingBounds.height - dimension.height);
                } else if (ResizableMouseInputAdapter._startingBounds.height + n2 > dimension2.height) {
                    n2 = dimension2.height - ResizableMouseInputAdapter._startingBounds.height;
                }
                n3 = ResizableMouseInputAdapter._startingBounds.x - n;
                n4 = ResizableMouseInputAdapter._startingBounds.y - n2;
                n = ResizableMouseInputAdapter._startingBounds.width + n;
                n2 = ResizableMouseInputAdapter._startingBounds.height + n2;
                break;
            }
            default: {
                return;
            }
        }
        this._resizable.resizing$2e715812(n3, n4, n, n2);
    }

    public final void mouseReleased(MouseEvent serializable) {
        _startingBounds = null;
        if (this._discardRelease) {
            this._discardRelease = false;
            return;
        }
        if (this._resizeCorner != 0) {
            serializable = this._resizable.getComponent().getTopLevelAncestor();
            if (serializable instanceof JFrame) {
                ((JFrame)this._resizable.getComponent().getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JFrame)this._resizable.getComponent().getTopLevelAncestor()).getGlassPane().setVisible(false);
            } else if (serializable instanceof JApplet) {
                ((JApplet)serializable).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JApplet)serializable).getGlassPane().setVisible(false);
            } else if (serializable instanceof JWindow) {
                ((JWindow)serializable).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JWindow)serializable).getGlassPane().setVisible(false);
            } else if (serializable instanceof JDialog) {
                ((JDialog)serializable).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JDialog)serializable).getGlassPane().setVisible(false);
            }
            this._eventMouseScreenX = 0;
            this._eventMouseScreenY = 0;
            _startingBounds = null;
            this._resizeCorner = 0;
        }
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof Resizable.ResizeCorner) {
            Resizable.ResizeCorner resizeCorner = (Resizable.ResizeCorner)mouseEvent.getSource();
            boolean bl = resizeCorner.getComponentOrientation().isLeftToRight();
            switch (resizeCorner.getCorner()) {
                case 16: {
                    resizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 5 : 4));
                    return;
                }
                case 4: {
                    resizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 7 : 6));
                    return;
                }
                case 64: {
                    resizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 4 : 5));
                    return;
                }
                case 1: {
                    resizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 6 : 7));
                    return;
                }
            }
        } else if (mouseEvent.getSource() == this._resizable.getComponent()) {
            Insets insets = this._resizable.getResizeInsets();
            boolean bl = this._resizable.getComponent().getComponentOrientation().isLeftToRight();
            if (mouseEvent.getX() <= insets.left) {
                if (this.isResizable(1) && insets.top > 0 && mouseEvent.getY() < this._resizable.getResizeCornerSize() + insets.top) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 6 : 7));
                    return;
                }
                if (this.isResizable(64) && insets.bottom > 0 && mouseEvent.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - insets.bottom) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 4 : 5));
                    return;
                }
                if (this.isResizable(128)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 10 : 11));
                    return;
                }
                this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                return;
            }
            if (mouseEvent.getX() >= this._resizable.getComponent().getWidth() - insets.right) {
                if (this.isResizable(4) && insets.top > 0 && mouseEvent.getY() < this._resizable.getResizeCornerSize() + insets.top) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 7 : 6));
                    return;
                }
                if (this.isResizable(64) && insets.bottom > 0 && mouseEvent.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - insets.bottom) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 5 : 4));
                    return;
                }
                if (this.isResizable(8)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 11 : 10));
                    return;
                }
                this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                return;
            }
            if (mouseEvent.getY() <= insets.top) {
                if (this.isResizable(1) && insets.left > 0 && mouseEvent.getX() < this._resizable.getResizeCornerSize() + insets.left) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 6 : 7));
                    return;
                }
                if (this.isResizable(4) && insets.right > 0 && mouseEvent.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - insets.right) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 7 : 6));
                    return;
                }
                if (this.isResizable(2)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(8));
                    return;
                }
                this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                return;
            }
            if (mouseEvent.getY() >= this._resizable.getComponent().getHeight() - insets.bottom) {
                if (this.isResizable(64) && insets.left > 0 && mouseEvent.getX() < this._resizable.getResizeCornerSize() + insets.left) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 4 : 5));
                    return;
                }
                if (this.isResizable(16) && insets.right > 0 && mouseEvent.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - insets.right) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 5 : 4));
                    return;
                }
                if (this.isResizable(32)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(9));
                    return;
                }
                this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                return;
            }
            this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
            return;
        }
        this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    public final void mouseExited(MouseEvent serializable) {
        if (serializable.getSource() instanceof Resizable.ResizeCorner) {
            serializable = (Resizable.ResizeCorner)serializable.getSource();
            ((Component)serializable).setCursor(Cursor.getDefaultCursor());
            return;
        }
        this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
    }
}

