/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.qbrowser.container.MessageContainer;
import com.qbrowser.property.HeaderPropertyTable;
import com.qbrowser.property.Property;
import java.util.LinkedList;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.command.Message;

public final class ActiveMQHeaderPropertyTable
extends HeaderPropertyTable {
    public ActiveMQHeaderPropertyTable() {
    }

    public ActiveMQHeaderPropertyTable(int row) {
        super(0);
    }

    public final int load(MessageContainer mc) {
        if (mc == null) {
            return 0;
        }
        javax.jms.Message message = mc.getMessage();
        if (message == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            int jgsq;
            Message acm;
            String jgroupid;
            int jpri;
            String jcorid;
            String jtype;
            Property property;
            Object object;
            long jexp = message.getJMSExpiration();
            if (jexp != 0L) {
                Property jexp_prop = new Property();
                object = "JMSExpiration";
                property = jexp_prop;
                jexp_prop.key = object;
                object = "Long";
                property = jexp_prop;
                jexp_prop.property_type = object;
                object = jexp;
                property = jexp_prop;
                jexp_prop.property_value = object;
                this.list.add(jexp_prop);
            }
            Destination d = message.getJMSReplyTo();
            String s = null;
            if (d != null) {
                s = d instanceof Queue ? "queue://" + ((Queue)d).getQueueName() : "topic://" + ((Topic)d).getTopicName();
            }
            if (s != null) {
                Property jrepto = new Property();
                object = "JMSReplyTo";
                property = jrepto;
                jrepto.key = object;
                object = "String";
                property = jrepto;
                jrepto.property_type = object;
                object = s;
                property = jrepto;
                jrepto.property_value = object;
                this.list.add(jrepto);
            }
            if ((jtype = message.getJMSType()) != null && jtype.length() > 0) {
                Property jtypep = new Property();
                object = "JMSType";
                property = jtypep;
                jtypep.key = object;
                object = "String";
                property = jtypep;
                jtypep.property_type = object;
                object = jtype;
                property = jtypep;
                jtypep.property_value = object;
                this.list.add(jtypep);
            }
            if ((jcorid = message.getJMSCorrelationID()) != null && jcorid.length() > 0) {
                Property jcoridp = new Property();
                object = "JMSCorrelationID";
                property = jcoridp;
                jcoridp.key = object;
                object = "String";
                property = jcoridp;
                jcoridp.property_type = object;
                object = jcorid;
                property = jcoridp;
                jcoridp.property_value = object;
                this.list.add(jcoridp);
            }
            if ((jpri = message.getJMSPriority()) != 4) {
                Property jprip = new Property();
                object = "JMSPriority";
                property = jprip;
                jprip.key = object;
                object = "Int";
                property = jprip;
                jprip.property_type = object;
                object = jpri;
                property = jprip;
                jprip.property_value = object;
                this.list.add(jprip);
            }
            if ((jgroupid = (acm = (Message)message).getGroupID()) != null && jgroupid.length() != 0) {
                Property jgroupidp = new Property();
                object = "Message Group";
                property = jgroupidp;
                jgroupidp.key = object;
                object = "String";
                property = jgroupidp;
                jgroupidp.property_type = object;
                object = jgroupid;
                property = jgroupidp;
                jgroupidp.property_value = object;
                this.list.add(jgroupidp);
            }
            if ((jgsq = acm.getGroupSequence()) != 0) {
                Property jgsqp = new Property();
                object = "Message Group Sequence Number";
                property = jgsqp;
                jgsqp.key = object;
                object = "Int";
                property = jgsqp;
                jgsqp.property_type = object;
                object = jgsq;
                property = jgsqp;
                jgsqp.property_value = object;
                this.list.add(jgsqp);
            }
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {}
        return this.list.size();
    }

    public final int loadAllProperties(MessageContainer mc) {
        if (mc == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            javax.jms.Message message = mc.getMessage();
            String msgid = message.getJMSMessageID();
            Property msgidp = new Property();
            Object object = "JMSMessageID";
            Property property = msgidp;
            msgidp.key = object;
            object = "String";
            property = msgidp;
            msgidp.property_type = object;
            object = msgid;
            property = msgidp;
            msgidp.property_value = object;
            this.list.add(msgidp);
            Object s1 = mc.getVdest();
            s1 = s1 != null ? (s1 instanceof Queue ? "queue://" + ((Queue)s1).getQueueName() : "topic://" + ((Topic)s1).getTopicName()) : "";
            Property jdestp = new Property();
            object = "JMSDestination";
            property = jdestp;
            jdestp.key = object;
            object = "String";
            property = jdestp;
            jdestp.property_type = object;
            object = s1;
            property = jdestp;
            jdestp.property_value = object;
            this.list.add(jdestp);
            Object s = mc.getVreplyto();
            s = s != null ? (s instanceof Queue ? "queue://" + ((Queue)s).getQueueName() : "topic://" + ((Topic)s).getTopicName()) : "";
            Property jrepto = new Property();
            object = "JMSReplyTo";
            property = jrepto;
            jrepto.key = object;
            object = "String";
            property = jrepto;
            jrepto.property_type = object;
            object = s;
            property = jrepto;
            jrepto.property_value = object;
            this.list.add(jrepto);
            String jcorid = message.getJMSCorrelationID();
            Property jcoridp = new Property();
            object = "JMSCorrelationID";
            property = jcoridp;
            jcoridp.key = object;
            object = "String";
            property = jcoridp;
            jcoridp.property_type = object;
            object = jcorid;
            property = jcoridp;
            jcoridp.property_value = object;
            this.list.add(jcoridp);
            int delivermode = message.getJMSDeliveryMode();
            Property delivermodep = new Property();
            object = "JMSDeliverMode";
            property = delivermodep;
            delivermodep.key = object;
            object = "Int";
            property = delivermodep;
            delivermodep.property_type = object;
            object = delivermode;
            property = delivermodep;
            delivermodep.property_value = object;
            this.list.add(delivermodep);
            int jpri = message.getJMSPriority();
            Property jprip = new Property();
            object = "JMSPriority";
            property = jprip;
            jprip.key = object;
            object = "Int";
            property = jprip;
            jprip.property_type = object;
            object = jpri;
            property = jprip;
            jprip.property_value = object;
            this.list.add(jprip);
            long jexp = message.getJMSExpiration();
            Property jexp_prop = new Property();
            object = "JMSExpiration";
            property = jexp_prop;
            jexp_prop.key = object;
            object = "Long";
            property = jexp_prop;
            jexp_prop.property_type = object;
            object = jexp;
            property = jexp_prop;
            jexp_prop.property_value = object;
            this.list.add(jexp_prop);
            String jtype = message.getJMSType();
            Property jtypep = new Property();
            object = "JMSType";
            property = jtypep;
            jtypep.key = object;
            object = "String";
            property = jtypep;
            jtypep.property_type = object;
            object = jtype;
            property = jtypep;
            jtypep.property_value = object;
            this.list.add(jtypep);
            boolean redelivered = message.getJMSRedelivered();
            Property redvd = new Property();
            object = "JMSRedelivered";
            property = redvd;
            redvd.key = object;
            object = "Boolean";
            property = redvd;
            redvd.property_type = object;
            object = redelivered;
            property = redvd;
            redvd.property_value = object;
            this.list.add(redvd);
            long jtimestamp = message.getJMSTimestamp();
            Property jtimestampp = new Property();
            object = "JMSTimestamp";
            property = jtimestampp;
            jtimestampp.key = object;
            object = "Long";
            property = jtimestampp;
            jtimestampp.property_type = object;
            object = jtimestamp;
            property = jtimestampp;
            jtimestampp.property_value = object;
            this.list.add(jtimestampp);
            Message acm = (Message)message;
            String jgroupid = acm.getGroupID();
            Property jgroupidp = new Property();
            object = "Message Group";
            property = jgroupidp;
            jgroupidp.key = object;
            object = "String";
            property = jgroupidp;
            jgroupidp.property_type = object;
            object = jgroupid;
            property = jgroupidp;
            jgroupidp.property_value = object;
            this.list.add(jgroupidp);
            int jgsq = acm.getGroupSequence();
            Property jgsqp = new Property();
            object = "Message Group Sequence Number";
            property = jgsqp;
            jgsqp.key = object;
            object = "Int";
            property = jgsqp;
            jgsqp.property_type = object;
            object = jgsq;
            property = jgsqp;
            jgsqp.property_value = object;
            this.list.add(jgsqp);
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return this.list.size();
    }
}

