/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.tree;

import com.jidesoft.swing.ResizablePanel;
import com.qbrowser.QBrowserV2;
import com.qbrowser.icons.QBrowserIconsFactory;
import com.qbrowser.localstore.LocalStoreManager;
import com.qbrowser.localstore.LocalStoreProperty;
import com.qbrowser.util.QBrowserUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public final class TreeIconPanel
extends ResizablePanel
implements TreeSelectionListener {
    private JTree tree;
    private DefaultMutableTreeNode top = null;
    private String hostandport = null;
    QBrowserV2 qb;
    private JScrollPane treeView;

    public TreeIconPanel(String vhostandport, QBrowserV2 vqb) {
        this.qb = vqb;
        this.hostandport = vhostandport;
        this.top = new DefaultMutableTreeNode(new DestInfo(this.hostandport, "BKR", null));
        this.createNodes(this.top);
        this.tree = new JTree(this.top);
        this.tree.getSelectionModel().setSelectionMode(1);
        ImageIcon leafIconTPC = QBrowserIconsFactory.getImageIcon("icons/flag4_ns.png");
        ImageIcon leafIconQUE = QBrowserIconsFactory.getImageIcon("icons/flag1.png");
        ImageIcon leafIconLS = QBrowserIconsFactory.getImageIcon("icons/flag7.png");
        ImageIcon globeIcon = QBrowserIconsFactory.getImageIcon("icons/globe16.png");
        ImageIcon foIcon = QBrowserIconsFactory.getImageIcon("icons/folder_open.png");
        ImageIcon fcIcon = QBrowserIconsFactory.getImageIcon("icons/folder.png");
        ImageIcon qIconp = QBrowserIconsFactory.getImageIcon("icons/flag1_p.png");
        ImageIcon tIconp = QBrowserIconsFactory.getImageIcon("icons/flag4_p.png");
        ImageIcon lIconp = QBrowserIconsFactory.getImageIcon("icons/flag7_p.png");
        ImageIcon tIcons = QBrowserIconsFactory.getImageIcon("icons/flag4_s.png");
        QBTreeRenderer qbt = new QBTreeRenderer(this, tIcons, qIconp, tIconp, lIconp, foIcon, fcIcon, globeIcon, leafIconQUE, leafIconTPC, leafIconLS);
        this.tree.setCellRenderer(qbt);
        this.tree.addTreeSelectionListener(this);
        this.treeView = new JScrollPane(this.tree);
        this.treeView.setBorder(BorderFactory.createEmptyBorder());
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.add(this.treeView);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public final JScrollPane getTreeView() {
        return this.treeView;
    }

    public final JTree getTree() {
        return this.tree;
    }

    public final TreePath findTreePath(String dest_name, String dest_type) {
        this.tree.getRowCount();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            TreePath tp = this.tree.getPathForRow(i);
            Object[] obj = tp.getPath();
            for (int j = 0; j < obj.length; ++j) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)obj[j];
                DestInfo di = (DestInfo)dmtn.getUserObject();
                if (!di.destinationName.equals(dest_name) || !di.destinationType.equals(dest_type)) continue;
                return tp;
            }
        }
        return null;
    }

    public final DestInfo getSelectedDestInfo() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof DestInfo) {
                DestInfo dest = (DestInfo)nodeInfo;
                return dest;
            }
            return null;
        }
        return null;
    }

    public final void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        node.getUserObject();
        node.isLeaf();
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DestInfo vdesti;
        int i;
        DefaultMutableTreeNode dest = null;
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(new DestInfo("Queue", "FD", null));
        top.add(category);
        for (i = 0; i < QBrowserV2.destinationNamesForDisplayQueue.size(); ++i) {
            String qn = (String)QBrowserV2.destinationNamesForDisplayQueue.get(i);
            dest = new DefaultMutableTreeNode(new DestInfo(qn, "QUEUE", qn + " : Queue"));
            category.add(dest);
        }
        category = new DefaultMutableTreeNode(new DestInfo("Topic", "FD", null));
        top.add(category);
        for (i = 0; i < QBrowserV2.destinationNamesForDisplayTopic.size(); ++i) {
            String tn = (String)QBrowserV2.destinationNamesForDisplayTopic.get(i);
            dest = new DefaultMutableTreeNode(new DestInfo(tn, "TOPIC", tn + " : Topic"));
            category.add(dest);
            String dest_with_suffix = tn + " : Topic";
            ArrayList<String> local_dests = LocalStoreManager.getCopyToListOfTheDestination(dest_with_suffix);
            if (local_dests == null) continue;
            for (int j = 0; j < local_dests.size(); ++j) {
                String local_dest = local_dests.get(j);
                if (!this.qb.isSubscriberThreadRunning(dest_with_suffix)) continue;
                vdesti = new DestInfo(local_dest, "C_LOCAL_STORE", local_dest + " : LOCAL_STORE");
                new DestInfo(local_dest, "C_LOCAL_STORE", local_dest + " : LOCAL_STORE").parent_with_suffix = dest_with_suffix;
                DefaultMutableTreeNode ldest = new DefaultMutableTreeNode(vdesti);
                dest.add(ldest);
            }
        }
        category = new DefaultMutableTreeNode(new DestInfo("LocalStore", "FD", null));
        top.add(category);
        Collection<LocalStoreProperty> lspcol = QBrowserV2.lsm.listLocalStoreProperties();
        for (LocalStoreProperty lsp : lspcol) {
            dest = new DefaultMutableTreeNode(new DestInfo(lsp.getDestName(), "LOCAL_STORE", lsp.getDestName() + " : LOCAL_STORE"));
            category.add(dest);
            for (String listen_dest_name_with_suffix : lsp.getFromDests().keySet()) {
                String listen_dest_name_without_suffix = QBrowserUtil.getPureDestName(listen_dest_name_with_suffix);
                if (QBrowserV2.destinationNamesForDisplayTopic.contains(listen_dest_name_without_suffix)) {
                    vdesti = new DestInfo(listen_dest_name_without_suffix, "C_TOPIC", listen_dest_name_with_suffix);
                    new DestInfo(listen_dest_name_without_suffix, "C_TOPIC", listen_dest_name_with_suffix).parent_with_suffix = lsp.getDestNameWithSuffix();
                    DefaultMutableTreeNode sdest = new DefaultMutableTreeNode(vdesti);
                    dest.add(sdest);
                    continue;
                }
                try {
                    lsp.removeFromDests(listen_dest_name_with_suffix);
                    QBrowserV2.lsm.updateAndSaveLocalStoreProperty(lsp);
                    LocalStoreManager.removeRelatedEntryOfSubscribeDest(listen_dest_name_with_suffix);
                }
                catch (Exception exception) {
                    Exception removee = exception;
                    exception.printStackTrace();
                }
            }
        }
    }

    final class QBTreeRenderer
    extends DefaultTreeCellRenderer {
        private Icon queueIcon;
        private Icon topicIcon;
        private Icon localstoreIcon;
        private Icon globeIcon;
        private Icon foIcon;
        private Icon fcIcon;
        private Icon lsIconp;
        private Icon topicIcons;
        private /* synthetic */ TreeIconPanel this$0;

        public QBTreeRenderer(TreeIconPanel treeIconPanel, Icon vtopicIcons, Icon vqueueIconp, Icon vtopicIconp, Icon vlsIconp, Icon vfoIcon, Icon vfcIcon, Icon vglobeIcon, Icon vqueueIcon, Icon vtopicIcon, Icon vlocalstoreIcon) {
            this.this$0 = treeIconPanel;
            this.queueIcon = vqueueIcon;
            this.topicIcon = vtopicIcon;
            this.localstoreIcon = vlocalstoreIcon;
            this.globeIcon = vglobeIcon;
            this.foIcon = vfoIcon;
            this.fcIcon = vfcIcon;
            this.lsIconp = vlsIconp;
            this.topicIcons = vtopicIcons;
        }

        /*
         * Unable to fully structure code
         */
        public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            block16: {
                block18: {
                    block17: {
                        block15: {
                            super.getTreeCellRendererComponent((JTree)tree, value, sel, expanded, leaf, row, hasFocus);
                            if (row != 0) break block15;
                            this.setIcon(this.globeIcon);
                            break block16;
                        }
                        tree = value;
                        sel = (DefaultMutableTreeNode)tree;
                        expanded = sel.getUserObject();
                        if (!(expanded instanceof DestInfo)) ** GOTO lbl-1000
                        sel = (DestInfo)expanded;
                        tree = sel.destinationType;
                        if (tree.equals("QUEUE")) {
                            v0 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v0 = false;
                        }
                        if (!v0) break block17;
                        this.setIcon(this.queueIcon);
                        this.setToolTipText("Queue");
                        break block16;
                    }
                    tree = value;
                    sel = (DefaultMutableTreeNode)tree;
                    expanded = sel.getUserObject();
                    if (!(expanded instanceof DestInfo)) ** GOTO lbl-1000
                    sel = (DestInfo)sel.getUserObject();
                    tree = sel.destinationType;
                    if (tree.equals("TOPIC") || tree.equals("C_TOPIC")) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) break block18;
                    tree = this;
                    sel = (DefaultMutableTreeNode)value;
                    expanded = sel.getUserObject();
                    if (expanded instanceof DestInfo) {
                        sel = (DestInfo)expanded;
                        v2 = tree.this$0.qb.isSubscriberThreadRunning(sel.name_with_suffix);
                    } else {
                        v2 = false;
                    }
                    if (v2) {
                        this.setIcon(this.topicIcons);
                    } else {
                        this.setIcon(this.topicIcon);
                    }
                    this.setToolTipText("Topic");
                    break block16;
                }
                tree = value;
                sel = (DefaultMutableTreeNode)tree;
                expanded = sel.getUserObject();
                if (!(expanded instanceof DestInfo)) ** GOTO lbl-1000
                sel = (DestInfo)sel.getUserObject();
                tree = sel.destinationType;
                if (tree.equals("LOCAL_STORE") || tree.equals("C_LOCAL_STORE")) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (v3) {
                    if (QBTreeRenderer.isLocalStorePaused(value)) {
                        this.setIcon(this.lsIconp);
                    } else {
                        this.setIcon(this.localstoreIcon);
                    }
                    this.setToolTipText("LocalStore");
                } else if (!leaf) {
                    this.setOpenIcon(this.foIcon);
                    this.setClosedIcon(this.fcIcon);
                }
            }
            return this;
        }

        private static boolean isLocalStorePaused(Object value) {
            Object node = (DefaultMutableTreeNode)value;
            Object obj = ((DefaultMutableTreeNode)node).getUserObject();
            if (obj instanceof DestInfo) {
                Object nodeInfo = (DestInfo)obj;
                try {
                    return !QBrowserV2.lsm.getLocalStoreProperty(((DestInfo)nodeInfo).destinationName).isValid();
                }
                catch (Throwable throwable) {
                    return false;
                }
            }
            return false;
        }
    }

    public static final class DestInfo {
        public String destinationName;
        public String destinationType;
        public String name_with_suffix;
        public String parent_with_suffix;

        public DestInfo(String vdest, String vtype, String vname_with_suffix) {
            this.destinationName = vdest;
            this.destinationType = vtype;
            this.name_with_suffix = vname_with_suffix;
        }

        public final String toString() {
            return this.destinationName;
        }
    }
}

