/*
 * Copyright (C) 2010 root42 Inc. All rights reserved.
 */

/**
 * R42t[[N
 *
 * i荞ݑIXgB
 *
 * @author root42 Inc.
 * @version $Id: NarrowDownSelectionList.js 27 2010-05-01 06:37:40Z takahashikzn $
 */
function NarrowDownSelectionList(/* Document */ document) {

    /** {@link #this} */
    var self = this;

    /** document */
    /* Document */ self.document = document;

    /** listItemOfLevels */
    /* Map<String, Object> */ self.listItems = {};

    /** initialvalue */
    /* String */ self.initialValue = null;

    /** warnIncompleteInput */
    /* boolean */ self.warnIncompleteInput = true;

    /** initialAutoSelected */
    /* boolean */ self.initialAutoSelected = false;


    /**
     * Xg̗vfݒ肷B
     *
     * @param listItems Xg̗vf
     */
    self.setListItems = /* void */ function(/* Map<String, Object> */ listItems) {
        self.listItems = listItems;
    };

    /**
     * lݒ肷B
     *
     * @param initialValue l
     */
    self.setInitialValue = /* void */ function(/* String */ initialValue) {
        self.initialValue = initialValue;
    };

    /**
     * ͂sSȏԂ̎Ax邩ۂw肷B
     *
     * @param warnIncompleteInput ͂sSȏԂ̎AxȂtrue
     */
    self.setWarnIncompleteInput = /* void */ function(/* boolean */ warnIncompleteInput) {
        self.warnIncompleteInput = warnIncompleteInput;
    };

    /**
     * (ʂɍŏɕ\Ƃ)ŁAILɂ邩ۂw肷B
     *
     * @param initialAutoSelected ԂŁAILɂȂtrue
     */
    self.setInitialAutoSelected = /* void */ function(/* boolean */ initialAutoSelected) {
        self.initialAutoSelected = initialAutoSelected;
    };


    /**
     * Optionvf쐬B
     *
     * @param text
     * @param value
     * @return OptionvfB
     */
    /* private Function */ var createOption = /* Option */ function(/* String */ text, /* String */ value) {

        //IEƂ̂ł͓Ȃ
        //return new Option(text, value);

        /* Option */ var option = self.document.createElement("option");

        //IEƂ̓_
        //option.text = text;

        option.appendChild(self.document.createTextNode(text));
        option.value = value;

        return option;
    };

    /**
     * @param listItemValue Xgvf
     * @return Xgvf̒l
     */
    /* private Function */ getValueOf = /* String */ function(/* Map<String, Object> */ listItemValue) {
        return listItemValue[NarrowDownSelectionList.METADATA_KEY].value;
    }

    /**
     * @param listItemValue Xgvf
     * @return Xgvf̒l
     */
    /* private Function */ getNameOf = /* String */ function(/* Map<String, Object> */ listItemValue) {
        return listItemValue[NarrowDownSelectionList.METADATA_KEY].name;
    }

    /**
     * Selectvf쐬B
     *
     * @return SelectvfB
     */
    /* private Function */ var createEmptySelect = /* Selectd */ function() {
        /* Select */ var selectElem = self.document.createElement("select");
        
        // 擪ɋI
        selectElem.appendChild(createOption(NarrowDownSelectionList.EMPTY_VALUE, ""));

        selectElem.setOptions = /* void */ function(/* Map<String, Object> */ listItems) {
            if (!listItems) {
                listItems = {};
            }

            // optionS
            selectElem.options.length = 0;
            // 擪ɋI
            /* Option */ var emptyOption = createOption(NarrowDownSelectionList.EMPTY_VALUE, "");
            selectElem.appendChild(emptyOption);

            // IXgpɎĝŕێĂB
            selectElem.listItems = listItems;

            for (/* String */ var listItemKey in listItems) {
                if (NarrowDownSelectionList.METADATA_KEY == listItemKey) {
                    continue;
                }

                /* Object */ var listItemValue = listItems[listItemKey];

                selectElem.appendChild(
                    createOption(listItemKey, getValueOf(listItemValue)));
            }

            // IȂꍇAIԂɂ
            if (selectElem.options.length == 2) {
                selectElem.options[1].selected = true;

                // Cxgʂ֓`d
                if (!!selectElem.onchange) {
                    selectElem.onchange();
                }
            }

            // ͒l肵ƂAinput.name̒lύX
            Utils.addEventListener(selectElem, "change", /* void */ function() {
                /* String */ var selectedValue = selectElem.value;

                // select.listItemsłȂƃ_
                for (/* String */ var listItemKey in selectElem.listItems) {
                    if (NarrowDownSelectionList.METADATA_KEY == listItemKey) {
                        continue;
                    }

                    /* Map<String, String> */ var listItem = selectElem.listItems[listItemKey];
                    if (selectedValue == getValueOf(listItem)) {
                        selectElem.name = getNameOf(listItem);
                        return;
                    }
                }
            });
        };

        return selectElem;
    }

    /**
     * i荞݃Xg̍ő[擾B
     *
     * @param listItems Xg̗vf
     * @return i荞݃Xg̍ő[BŒ1B
     */
    /* private Function */ var countMaxDepth = /* int */ function(/* Map<String, Object> */ listItems) {
        /* int */ var maxDepth = 0;

        for (/* String */ var listItemKey in listItems) {
            if (NarrowDownSelectionList.METADATA_KEY == listItemKey) {
                continue;
            }

            (function() {
                /* Object */ var listItemValue = listItems[listItemKey];

                if (typeof(listItemValue) == "object") {
                    /* int */ var depth = countMaxDepth(listItemValue);

                    if (maxDepth <= depth) {
                        maxDepth = (depth + 1);
                    }
                }
            })();
        }

        return maxDepth;
    };

    /**
     * l𕜌B
     *
     * @param narrowDownSelects
     * @param initialValue
     */
    /* private Function */ var restoreSelectionState = function(/* List<Select> */ narrowDownSelects, /* Object */ initialValue) {

        // IꂽL[̃Xg
        /* List<String> */ var selectedItemKeys = [];

        /**
         * IꂽL[̃Xg\B
         *
         * @param listItems Xg̗vf
         */
        /* Function */ var searchSelectedKeys = function(/* Map<String, Object> */ listItems) {

            for (/* String */ var listItemKey in listItems) {
                if (NarrowDownSelectionList.METADATA_KEY == listItemKey) {
                    continue;
                }

                selectedItemKeys.push(listItemKey);

                /* Object */ var listItemValue = listItems[listItemKey];

                if (listItemValue[NarrowDownSelectionList.METADATA_KEY].value == initialValue) {
                    // Eo
                    throw 0;
                } else if (typeof(listItemValue) == "object") {
                    searchSelectedKeys(listItemValue);
                }

                selectedItemKeys.pop();
            }
        };


        try {
            searchSelectedKeys(self.listItems);
        } catch(e) {
            // EoȊOȂăX[
            if (e != 0) {
                throw e;
            }
        }


        // IꂽL[̒TɎsꍇ͉Ȃ
        if (selectedItemKeys.length != narrowDownSelects.length) {
            return;
        }


        for (/* int */ var i = 0; i < selectedItemKeys.length; i++) {
            /* String */ var selectedItemKey = selectedItemKeys[i];
            /* Select */ var selectElem = narrowDownSelects[i];

            for (/* int */ var k = 0; k < selectElem.options.length; k++) {
                /* Option */ var option = selectElem.options[k];

                if (option.innerHTML == selectedItemKey) {
                    option.selected = true;
                    selectElem.onchange();

                    break;
                }
            }
        }
    };

    /**
     * i荞ݑIXg܂ރm[h쐬B
     *
     * @return i荞ݑIXg܂ރm[hB
     */
    self.createNarrowDownSelectListElement = function() {
        /* Element */ var div = self.document.createElement("div");
        /* var */ var maxDepth = countMaxDepth(self.listItems);
        /* var */ var narrowDownSelects = [];

        // bZ[Ẅ
        /* Element */ var msgSection = self.document.createElement("span");

        /**
         * ͂sSł邱ƂxB
         */
        /* Function */ var doWarnIncompleteInput = /* void */ function() {
            /* boolean */ var firstSelectedState = (narrowDownSelects[0].selectedIndex != 0);
            /* boolean */ var lastSelectedState = (narrowDownSelects[narrowDownSelects.length - 1].selectedIndex != 0);

            if (firstSelectedState && !lastSelectedState) {
                msgSection.style.fontSize = "x-small";
                msgSection.style.color = "red";
                msgSection.innerHTML = NarrowDownSelectionList.WARN_INCOMPLETE_INPUT;
            } else {
                msgSection.style.fontSize = "";
                msgSection.style.color = "";
                msgSection.innerHTML = "";
            }
        };

        for (/* int */ var i = 0; i < maxDepth; i++) {

            (function() {
                /* int */ var depth = i;
                /* Select */ var narrowDownSelect = createEmptySelect();

                Utils.addEventListener(narrowDownSelect, "change", /* void */ function() {
                    if (self.warnIncompleteInput) {
                        doWarnIncompleteInput();
                    }

                    /* Option */ var selectedOption = narrowDownSelect.options[narrowDownSelect.selectedIndex];
                    /* Map<String, Object> */ var listItems = narrowDownSelect.listItems[selectedOption.text];

                    /* boolean */ var isLastDepth = (narrowDownSelects.length == (depth + 1));

                    if (!isLastDepth) {
                        /* Select */ var nextDepthNarrowDownSelect = narrowDownSelects[depth + 1];
                        nextDepthNarrowDownSelect.setOptions(listItems);

                        // SelectփCxg`d
                        nextDepthNarrowDownSelect.onchange();
                    }
                });

                narrowDownSelects.push(narrowDownSelect);

                // ----
                // span쐬div֒ǉB
                /* Element */ var span = self.document.createElement("span");
                span.appendChild(narrowDownSelect);

                div.appendChild(span);
                div.appendChild(self.document.createTextNode("@"));
            })();
        }

        // bZ[ẄZbg
        div.appendChild(msgSection);

        // gbvx
        narrowDownSelects[0].setOptions(self.listItems);


        // lΏԂ𕜌
        if (!!self.initialValue) {
            restoreSelectionState(narrowDownSelects, self.initialValue);
        }
        // Ԃɂ鎩Iς݂B(lw肳ĂȂꍇ̂)
        else if (!self.initialAutoSelected) {
            narrowDownSelects[0].selectedIndex = 0;
            narrowDownSelects[0].onchange();
        }


        return div;
    };
}


/**
 * 萔錾
 */
(function() {
    NarrowDownSelectionList.EMPTY_VALUE = "@@@@@@";
    NarrowDownSelectionList.WARN_INCOMPLETE_INPUT = "@@Ō܂őIĉ";
    NarrowDownSelectionList.METADATA_KEY = "@";
})();
