/*
 * Decompiled with CFR 0.152.
 */
package bl.radio;

import bl.radio.ConfigBox;
import bl.radio.DjPlayer;
import bl.radio.RadioKaras;
import bl.radio.StatusBox;
import bl.radio.channel.ChannelFactory;
import bl.radio.channel.ChannelModel;
import bl.radio.channel.SelfishFactory;
import bl.radio.config.ListedProperty;
import bl.radio.config.Property;
import bl.radio.config.StationModel;
import bl.radio.engine.PlayerListener;
import bl.radio.engine.PlayerStreamer;
import bl.radio.task.UpdateListener;
import bl.radio.ui.notify.NotificationType;
import bl.radio.ui.notify.NotifierDialog;
import bl.radio.util.TwitterHelper;
import bl.radio.util.WebClientUtil;
import ch.qos.logback.classic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.slf4j.LoggerFactory;

public abstract class AbsRadioKaras
implements PlayerListener,
UpdateListener {
    private static Logger logger = (Logger)LoggerFactory.getLogger(AbsRadioKaras.class);
    public static final String osName = System.getProperty("os.name").toLowerCase();
    protected RadioKaras radioKaras;
    protected PlayerStreamer player;
    protected boolean isSuperDjMode;
    protected boolean isDjMode;
    protected DjPlayer djPlayer;
    protected ChannelModel channelModel;
    protected Map<String, List<ChannelModel>> channelMemory;
    protected List<ChannelModel> appendixMemory;
    protected File dbPath;

    public void boot(RadioKaras radioKaras) throws Exception {
        String string;
        logger.debug("Booting Karas...");
        StatusBox statusBox = StatusBox.getInstance();
        statusBox.setPlay(false);
        this.radioKaras = radioKaras;
        this.channelMemory = new HashMap<String, List<ChannelModel>>();
        this.updateChannel();
        ConfigBox configBox = ConfigBox.getInstance();
        String string2 = configBox.getStringVal("radioKaras", "defaultRadio");
        if (string2.isEmpty()) {
            string2 = "sky.fm";
        }
        if ((string = configBox.getStringVal("radioKaras", "defaultChannel")).isEmpty()) {
            string = "80's Rock Hits";
        }
        if (string2.equals("appendix")) {
            for (ChannelModel channelModel : this.appendixMemory) {
                if (!channelModel.getStation().equals(string)) continue;
                this.channelModel = channelModel;
                break;
            }
        } else {
            this.channelModel = this.getDefaultData(string2, string);
        }
        if (this.channelModel == null) {
            this.channelModel = this.getDefaultData("sky.fm");
        }
        this.raidingTray();
    }

    protected ChannelModel getDefaultData(String string) throws Exception {
        ChannelModel channelModel = null;
        List<ChannelModel> list = this.channelMemory.get(string);
        if (list.size() > 0) {
            channelModel = list.get(0);
        }
        return channelModel;
    }

    protected ChannelModel getDefaultData(String string, String string2) throws Exception {
        List<ChannelModel> list = this.channelMemory.get(string);
        if (list != null) {
            for (ChannelModel channelModel : list) {
                if (!channelModel.getStation().equals(string2)) continue;
                return channelModel;
            }
        }
        return null;
    }

    abstract void raidingTray() throws Exception;

    public void setDbPath(File file) {
        this.dbPath = file;
    }

    protected void updateChannel() throws Exception {
        ConfigBox configBox = ConfigBox.getInstance();
        for (StationModel stationModel : configBox.getStationModels()) {
            List<ChannelModel> list = ChannelFactory.getChannels(this.dbPath.getPath(), stationModel.getDisplayName(), stationModel.getName());
            this.channelMemory.put(stationModel.getName(), list);
        }
        this.appendixMemory = ChannelFactory.getChannels(this.dbPath.getPath(), "Appendix", "appendix");
    }

    protected List<ChannelModel> getCategories(String string) throws Exception {
        List<ChannelModel> list;
        ArrayList<ChannelModel> arrayList = new ArrayList<ChannelModel>();
        String string2 = this.getCondition(string);
        if (string2.equals("%")) {
            list = new File(this.dbPath, "listen.log");
            string2 = SelfishFactory.getConditions((File)((Object)list));
        }
        for (String object : this.channelMemory.keySet()) {
            List<ChannelModel> list2 = this.channelMemory.get(object);
            for (ChannelModel channelModel : list2) {
                if (!this.matchCategory(channelModel, string2)) continue;
                arrayList.add(channelModel);
            }
        }
        list = this.appendixMemory;
        for (ChannelModel channelModel : list) {
            if (!this.matchCategory(channelModel, string2)) continue;
            arrayList.add(channelModel);
        }
        Collections.shuffle(arrayList);
        logger.debug("[conds] -> " + string2);
        return arrayList;
    }

    private String getCondition(String string) throws Exception {
        String string2 = "";
        ConfigBox configBox = ConfigBox.getInstance();
        ListedProperty listedProperty = configBox.getListedProperty("radioKaras", "categories");
        for (Property property : listedProperty.getProperties()) {
            if (!string.toLowerCase().matches(property.getName().toLowerCase())) continue;
            string2 = property.getValue();
            break;
        }
        return string2;
    }

    private boolean matchCategory(ChannelModel channelModel, String string) throws Exception {
        String[] stringArray;
        if (string.equals("*")) {
            return true;
        }
        for (String string2 : stringArray = string.split(",")) {
            if (string2.isEmpty()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(channelModel.getStation().trim().toLowerCase());
            stringBuilder.append(" ");
            stringBuilder.append(channelModel.getDescription().trim().toLowerCase());
            stringBuilder.append(" ");
            stringBuilder.append(channelModel.getCategory().trim().toLowerCase());
            Pattern pattern = Pattern.compile("\\b(" + string2.toLowerCase().trim() + ")");
            Matcher matcher = pattern.matcher(stringBuilder.toString());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private String getGenre(String string) throws Exception {
        ConfigBox configBox = ConfigBox.getInstance();
        ListedProperty listedProperty = configBox.getListedProperty("radioKaras", "categories");
        for (Property property : listedProperty.getProperties()) {
            String[] stringArray;
            String string2 = property.getValue();
            if (string2.equals("*")) continue;
            for (String string3 : stringArray = string2.split(",")) {
                Pattern pattern = Pattern.compile("(" + string3.toLowerCase().trim() + ")");
                Matcher matcher = pattern.matcher(string);
                if (!matcher.find()) continue;
                return property.getName();
            }
        }
        return "...More";
    }

    protected Map<String, List<ChannelModel>> getCategoryMap(List<ChannelModel> list) throws Exception {
        TreeMap<String, List<ChannelModel>> treeMap = new TreeMap<String, List<ChannelModel>>();
        for (ChannelModel channelModel : list) {
            List<ChannelModel> list2;
            String string = channelModel.getCategory();
            String string2 = this.getGenre(string);
            if (string2 == null || string2.isEmpty()) continue;
            if (treeMap.containsKey(string2)) {
                list2 = (List)treeMap.get(string2);
                list2.add(channelModel);
                continue;
            }
            list2 = new ArrayList();
            list2.add(channelModel);
            treeMap.put(string2, list2);
        }
        return treeMap;
    }

    protected String getRadio(String string) throws Exception {
        ConfigBox configBox = ConfigBox.getInstance();
        for (StationModel stationModel : configBox.getStationModels()) {
            if (!stationModel.getName().equals(string)) continue;
            return stationModel.getDisplayName();
        }
        return "";
    }

    protected void callYoutube() {
        StatusBox statusBox = StatusBox.getInstance();
        try {
            if (statusBox.getSong() != null) {
                WebClientUtil.queryYouTube(statusBox.getSong());
            } else {
                this.showNotify(statusBox.getStation(), statusBox.getFormatSong());
            }
        }
        catch (Exception exception) {
            logger.error("YouTube Error !!", (Throwable)exception);
        }
    }

    protected void displaySong() {
        StatusBox statusBox = StatusBox.getInstance();
        this.showNotify(statusBox.getStation(), statusBox.getFormatSong());
    }

    protected void copySong() {
        StatusBox statusBox = StatusBox.getInstance();
        Clipboard clipboard = new Clipboard(Display.getDefault());
        clipboard.setContents(new Object[]{statusBox.getFormatSong() + " (" + statusBox.getUrl() + ")"}, new Transfer[]{TextTransfer.getInstance()});
    }

    protected void tweetSong() {
        StatusBox statusBox = StatusBox.getInstance();
        try {
            if (TwitterHelper.isEnabledTwitter()) {
                TwitterHelper.updateTwitter(statusBox.getSong(), statusBox.getUrl());
            }
        }
        catch (Exception exception) {
            logger.error("Twitter Update Error !!", (Throwable)exception);
        }
    }

    protected boolean authTwitter(boolean bl) {
        try {
            ConfigBox configBox = ConfigBox.getInstance();
            configBox.setConfigValue("radioKaras", "useTwitter", bl);
            if (bl) {
                TwitterHelper.initTwitter();
            }
            return configBox.getBoolVal("radioKaras", "useTwitter");
        }
        catch (Exception exception) {
            logger.error("Twitter Init Error !!", (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showNotify(String string, String string2) {
        AbsRadioKaras absRadioKaras = this;
        synchronized (absRadioKaras) {
            final String string3 = string;
            final String string4 = string2;
            Display display = Display.getDefault();
            logger.debug("Notifier... {} - {}", (Object)string3, (Object)string4);
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    NotifierDialog.notify(string3, string4, NotificationType.RADIOKARAS);
                }
            });
        }
    }

    public PlayerStreamer getPlayer() {
        return this.player;
    }

    public DjPlayer getDjPlayer() {
        return this.djPlayer;
    }
}

