/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkColorSelectionDialog;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        boolean bl;
        long l;
        int n;
        long l2;
        long l3;
        long l4;
        Display display;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        long l5 = OS.gtk_color_selection_dialog_new(byArray);
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        if (this.parent != null) {
            l4 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(l5, l4);
            l3 = OS.gtk_window_get_icon_list(l4);
            if (l3 != 0L) {
                OS.gtk_window_set_icon_list(l5, l3);
                OS.g_list_free(l3);
            }
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            l4 = OS.gtk_window_get_group(0L);
            OS.gtk_window_group_add_window(l4, l5);
        }
        OS.gtk_window_set_modal(l5, true);
        GtkColorSelectionDialog gtkColorSelectionDialog = new GtkColorSelectionDialog();
        OS.memmove(gtkColorSelectionDialog, l5);
        GdkColor gdkColor = new GdkColor();
        if (this.rgb != null) {
            gdkColor.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
            gdkColor.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
            gdkColor.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
            OS.gtk_color_selection_set_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
        }
        OS.gtk_color_selection_set_has_palette(gtkColorSelectionDialog.colorsel, true);
        if (this.rgbs != null) {
            l3 = OS.g_malloc(GdkColor.sizeof * this.rgbs.length);
            int n2 = 0;
            while (n2 < this.rgbs.length) {
                RGB rGB = this.rgbs[n2];
                if (rGB != null) {
                    gdkColor.red = (short)(rGB.red & 0xFF | (rGB.red & 0xFF) << 8);
                    gdkColor.green = (short)(rGB.green & 0xFF | (rGB.green & 0xFF) << 8);
                    gdkColor.blue = (short)(rGB.blue & 0xFF | (rGB.blue & 0xFF) << 8);
                    OS.memmove(l3 + (long)(n2 * GdkColor.sizeof), gdkColor, (long)GdkColor.sizeof);
                }
                ++n2;
            }
            l2 = OS.gtk_color_selection_palette_to_string(l3, this.rgbs.length);
            n = OS.strlen(l2);
            byArray = new byte[n];
            OS.memmove(byArray, l2, (long)n);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            byArray = Converter.wcsToMbcs(null, string, true);
            OS.g_free(l3);
            l = OS.gtk_settings_get_default();
            if (l != 0L) {
                OS.gtk_settings_set_string_property(l, OS.gtk_color_palette, byArray, Converter.wcsToMbcs(null, "gtk_color_selection_palette_to_string", true));
            }
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(l5)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n3 = 0;
        l2 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n3 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l2 = OS.g_signal_add_emission_hook(n3, 0, display.emissionProc, l5, 0L);
        }
        n = OS.gtk_dialog_run(l5);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n3, l2);
        }
        if (OS.gtk_window_get_modal(l5)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n == -5;
        if (bl) {
            OS.gtk_color_selection_get_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
            int n4 = gdkColor.red >> 8 & 0xFF;
            int n5 = gdkColor.green >> 8 & 0xFF;
            int n6 = gdkColor.blue >> 8 & 0xFF;
            this.rgb = new RGB(n4, n5, n6);
        }
        if ((l = OS.gtk_settings_get_default()) != 0L) {
            long[] lArray = new long[1];
            OS.g_object_get(l, OS.gtk_color_palette, lArray, 0L);
            if (lArray[0] != 0L) {
                int n7 = OS.strlen(lArray[0]);
                byArray = new byte[n7];
                OS.memmove(byArray, lArray[0], (long)n7);
                OS.g_free(lArray[0]);
                String[] stringArray = null;
                if (n7 > 0) {
                    String string = new String(Converter.mbcsToWcs(null, byArray));
                    stringArray = ColorDialog.splitString(string, ':');
                    n7 = stringArray.length;
                }
                this.rgbs = new RGB[n7];
                int n8 = 0;
                while (n8 < n7) {
                    String string = stringArray[n8];
                    byArray = Converter.wcsToMbcs(null, string, true);
                    OS.gdk_color_parse(byArray, gdkColor);
                    int n9 = gdkColor.red >> 8 & 0xFF;
                    int n10 = gdkColor.green >> 8 & 0xFF;
                    int n11 = gdkColor.blue >> 8 & 0xFF;
                    this.rgbs[n8] = new RGB(n9, n10, n11);
                    ++n8;
                }
            }
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l5);
        if (!bl) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        this.rgbs = rGBArray;
    }

    static String[] splitString(String string, char c) {
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(c, n);
            if (n2 == -1) {
                stringArray[stringArray.length - 1] = string.substring(n);
                continue;
            }
            stringArray[stringArray.length - 1] = string.substring(n, n2);
            n = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

