/*
 * Decompiled with CFR 0.152.
 */
package bl.radio;

import bl.radio.channel.ChannelModel;
import bl.radio.engine.PlayerEvent;
import bl.radio.engine.PlayerListener;
import bl.radio.engine.PlayerStreamer;
import bl.radio.task.FeadOutTask;
import ch.qos.logback.classic.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class DjPlayer
implements Runnable {
    private static Logger logger = (Logger)LoggerFactory.getLogger(DjPlayer.class);
    private static final long ON_AIR_TERM_SEC = 180L;
    private static final long ON_AIR_TERM_SEC_SUPER = 12L;
    private static final int FADE_OUT = 5;
    private List<ChannelModel> list;
    private PlayerListener listener;
    private boolean isPlay;
    private LinkedList<PlayerStreamer> msList;
    private LinkedList<Timer> timerList;
    private long onAirTerm = 180L;

    public DjPlayer(List<ChannelModel> list, PlayerListener playerListener, boolean bl) {
        this.list = new ArrayList<ChannelModel>(list);
        this.listener = playerListener;
        this.isPlay = true;
        if (bl) {
            logger.info("Super DJ Mode...");
            this.onAirTerm = 12L;
        }
    }

    @Override
    public void run() {
        this.msList = new LinkedList();
        this.timerList = new LinkedList();
        block6: while (this.isPlay) {
            Collections.shuffle(this.list);
            block7: for (ChannelModel channelModel : this.list) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isPlay) continue block6;
                PlayerStreamer playerStreamer = null;
                try {
                    playerStreamer = new PlayerStreamer(channelModel, this.listener, true);
                    this.msList.offer(playerStreamer);
                    Thread thread = new Thread(playerStreamer);
                    thread.start();
                    long l = 0L;
                    while (this.isPlay) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (playerStreamer.isSoundless()) {
                            playerStreamer.stop();
                            this.msList.pollLast();
                            continue block7;
                        }
                        if (++l <= this.onAirTerm) continue;
                        Timer timer = new Timer("stop.timer");
                        this.timerList.add(timer);
                        FeadOutTask feadOutTask = new FeadOutTask(this.msList, this.timerList);
                        timer.schedule((TimerTask)feadOutTask, TimeUnit.SECONDS.toMillis(5L));
                    }
                }
                catch (Exception exception) {
                    logger.error("Dj Thread Error !", (Throwable)exception);
                }
            }
        }
    }

    public void stop() {
        this.isPlay = false;
        if (this.msList != null) {
            for (PlayerStreamer object : this.msList) {
                if (object == null) continue;
                object.stop();
            }
        }
        if (this.timerList != null) {
            for (Timer timer : this.timerList) {
                if (timer == null) continue;
                timer.cancel();
            }
        }
        ChannelModel channelModel = new ChannelModel("DJ MODE");
        channelModel.setStation("DJ MODE");
        this.listener.notifyPlayer(new PlayerEvent(channelModel, false, true, 6));
    }

    public LinkedList<PlayerStreamer> getPlayerStreamers() {
        return this.msList;
    }
}

