/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.channel;

import bl.radio.channel.ChannelModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ChannelFactory {
    private ChannelFactory() {
    }

    public static List<ChannelModel> getChannels(String string, String string2, String string3) throws Exception {
        ArrayList<ChannelModel> arrayList = new ArrayList<ChannelModel>();
        File file = new File(string, string3);
        File[] fileArray = file.listFiles(ChannelFactory.getFileExtensionFilter(".db"));
        if (fileArray == null || fileArray.length == 0) {
            return arrayList;
        }
        for (File file2 : fileArray) {
            ChannelModel channelModel = new ChannelModel(string2);
            channelModel.setRadioKey(string3);
            try (FileInputStream fileInputStream = new FileInputStream(file2);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String string4 = null;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n = 0;
                while ((string4 = bufferedReader.readLine()) != null) {
                    switch (n) {
                        case 0: {
                            channelModel.setStation(string4);
                            break;
                        }
                        case 1: {
                            channelModel.setDescription(string4);
                            break;
                        }
                        case 2: {
                            channelModel.setCategory(string4);
                            break;
                        }
                        default: {
                            arrayList2.add(string4);
                        }
                    }
                    ++n;
                }
                channelModel.setUrls(arrayList2);
                channelModel.setRawName(file2.getName());
            }
            arrayList.add(channelModel);
        }
        Collections.sort(arrayList, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                ChannelModel channelModel = (ChannelModel)object;
                ChannelModel channelModel2 = (ChannelModel)object2;
                if (channelModel.getStation().compareTo(channelModel2.getStation()) > 0) {
                    return 1;
                }
                if (channelModel.getStation().compareTo(channelModel2.getStation()) < 0) {
                    return -1;
                }
                return 0;
            }
        });
        return arrayList;
    }

    private static FilenameFilter getFileExtensionFilter(String string) {
        final String string2 = string;
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                boolean bl = string.endsWith(string2);
                return bl;
            }
        };
    }

    public static Map<String, ChannelModel> getLoglist(File file) throws Exception {
        return ChannelFactory.getLoglist(file, true);
    }

    public static Map<String, ChannelModel> getLoglist(File file, boolean bl) throws Exception {
        HashMap<String, ChannelModel> hashMap = new HashMap<String, ChannelModel>();
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string == null) continue;
                    String[] stringArray = string.split("\t");
                    if (bl) {
                        if (!stringArray[7].equals("Normal")) continue;
                        ChannelFactory.setChannelModel(stringArray, hashMap);
                        continue;
                    }
                    ChannelFactory.setChannelModel(stringArray, hashMap);
                }
            }
        }
        return hashMap;
    }

    private static void setChannelModel(String[] stringArray, Map<String, ChannelModel> map) {
        ChannelModel channelModel = new ChannelModel(stringArray[3]);
        channelModel.setListenTime(stringArray[0]);
        channelModel.setDescription(stringArray[1]);
        channelModel.setRadioKey(stringArray[2]);
        channelModel.setStation(stringArray[4]);
        channelModel.setCategory(stringArray[5]);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stringArray[6]);
        channelModel.setUrls(arrayList);
        String string = channelModel.getTitle();
        if (!map.containsKey(string)) {
            channelModel.setCount(1);
            map.put(string, channelModel);
        } else {
            ChannelModel channelModel2 = map.get(string);
            channelModel2.setCount(channelModel2.getCount() + 1);
            map.put(string, channelModel2);
        }
    }
}

