/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.util;

import ch.qos.logback.classic.Logger;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.slf4j.LoggerFactory;

public final class FontHelper {
    private static Logger logger = (Logger)LoggerFactory.getLogger(FontHelper.class);

    private FontHelper() {
    }

    public static Font getMessageFont() {
        ArrayList<Font> arrayList = FontHelper.getLocaleFonts();
        Font font = null;
        for (Font font2 : arrayList) {
            if (font2.getName().startsWith("Meiryo UI")) {
                font = font2;
                break;
            }
            if (font2.getName().startsWith("VL PGothic")) {
                font = font2;
                break;
            }
            font = font2;
        }
        logger.debug("Use Font : " + font.getName());
        return font;
    }

    private static ArrayList<Font> getLocaleFonts() {
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Locale locale = Locale.getDefault();
        ArrayList<Font> arrayList = new ArrayList<Font>();
        for (int i = 0; i < fontArray.length; ++i) {
            if (locale.equals(Locale.JAPANESE)) {
                if (!fontArray[i].canDisplay('\u65e5')) continue;
                arrayList.add(fontArray[i]);
                continue;
            }
            if (locale.equals(Locale.KOREAN)) {
                if (!fontArray[i].canDisplay('\ud55c')) continue;
                arrayList.add(fontArray[i]);
                continue;
            }
            if (locale.equals(Locale.CHINESE)) {
                if (!fontArray[i].canDisplay('\u65e0')) continue;
                arrayList.add(fontArray[i]);
                continue;
            }
            if (locale.equals(Locale.TRADITIONAL_CHINESE)) {
                if (!fontArray[i].canDisplay('\u96fb')) continue;
                arrayList.add(fontArray[i]);
                continue;
            }
            arrayList.add(fontArray[i]);
        }
        return arrayList;
    }

    public static void setUIFont(Font font) {
        FontUIResource fontUIResource = new FontUIResource(font);
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            if (!entry.getKey().toString().toLowerCase().endsWith("font")) continue;
            UIManager.put(entry.getKey(), fontUIResource);
        }
    }
}

