/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.util;

import bl.radio.ConfigBox;
import bl.radio.config.AccessTokenModel;
import bl.radio.config.MessageFactory;
import bl.radio.engine.meta.MetaEvent;
import bl.radio.util.SystemUtil;
import ch.qos.logback.classic.Logger;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.simpleframework.xml.core.Persister;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

public final class TwitterHelper {
    private static Logger logger = (Logger)LoggerFactory.getLogger(TwitterHelper.class);

    private TwitterHelper() {
    }

    public static void initTwitter() throws Exception {
        Twitter twitter = TwitterFactory.getSingleton();
        ConfigBox configBox = ConfigBox.getInstance();
        boolean bl = configBox.getBoolVal("radioKaras", "useTwitter");
        if (bl) {
            AccessToken accessToken = TwitterHelper.loadAccessToken();
            if (accessToken == null) {
                RequestToken requestToken = TwitterHelper.getPinCode();
                String string = null;
                InputDialog inputDialog = new InputDialog(Display.getDefault().getActiveShell(), "RadioKaras", MessageFactory.getMessage("Info.Twitter.Pin"), "", null);
                if (inputDialog.open() == 0) {
                    string = inputDialog.getValue();
                }
                if (string != null) {
                    TwitterHelper.doAuth(requestToken, string);
                } else {
                    twitter.setOAuthAccessToken(null);
                    configBox.setConfigValue("radioKaras", "useTwitter", false);
                }
            } else {
                twitter.setOAuthAccessToken(accessToken);
            }
        }
    }

    private static RequestToken getPinCode() throws Exception {
        Twitter twitter = TwitterFactory.getSingleton();
        RequestToken requestToken = twitter.getOAuthRequestToken();
        String string = requestToken.getAuthorizationURL();
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(new URI(string));
        return requestToken;
    }

    private static void doAuth(RequestToken requestToken, String string) throws Exception {
        Twitter twitter = TwitterFactory.getSingleton();
        AccessToken accessToken = twitter.getOAuthAccessToken(requestToken, string);
        TwitterHelper.storeAccessToken(twitter.verifyCredentials().getId(), accessToken);
    }

    private static void storeAccessToken(long l, AccessToken accessToken) throws Exception {
        ConfigBox configBox = ConfigBox.getInstance();
        Persister persister = new Persister();
        AccessTokenModel accessTokenModel = new AccessTokenModel(l, accessToken.getToken(), accessToken.getTokenSecret());
        File file = new File(configBox.getStringVal("radioKaras", "accessTokenPath"));
        persister.write((Object)accessTokenModel, file);
    }

    private static AccessToken loadAccessToken() throws Exception {
        ConfigBox configBox = ConfigBox.getInstance();
        Persister persister = new Persister();
        File file = new File(configBox.getStringVal("radioKaras", "accessTokenPath"));
        if (!file.exists()) {
            return null;
        }
        AccessTokenModel accessTokenModel = (AccessTokenModel)persister.read(AccessTokenModel.class, file);
        return new AccessToken(accessTokenModel.getToken(), accessTokenModel.getTokenSecret());
    }

    public static boolean updateTwitter(MetaEvent metaEvent) throws Exception {
        ConfigBox configBox;
        boolean bl;
        if (!SystemUtil.matchTag(metaEvent.getSong()) && (bl = (configBox = ConfigBox.getInstance()).getBoolVal("radioKaras", "useTwitter"))) {
            String string = "\u266b {0} - Listening to {1} #nowplaying, #radiokaras";
            String string2 = MessageFormat.format(string, metaEvent.getSong(), metaEvent.getUrl());
            Twitter twitter = TwitterFactory.getSingleton();
            string2 = StringUtils.left((String)string2, (int)140);
            twitter.updateStatus(string2);
            logger.debug("Twitter update..." + string2);
            return true;
        }
        return false;
    }

    public static void updateTwitter(String string, String string2) throws Exception {
        String string3 = string;
        if (string == null) {
            string3 = "(No Title)";
        }
        String string4 = "\u266a {0} - Listening to {1} #nowplaying, #radiokaras";
        String string5 = MessageFormat.format(string4, string3, string2);
        Twitter twitter = TwitterFactory.getSingleton();
        string5 = StringUtils.left((String)string5, (int)140);
        twitter.updateStatus(string5);
        logger.debug("Twitter update..." + string5);
    }

    public static void opningUpdateTwitter() throws Exception {
        ConfigBox configBox = ConfigBox.getInstance();
        boolean bl = configBox.getBoolVal("radioKaras", "useTwitter");
        if (bl) {
            String string = "{0} - {1} Powered by #RadioKaras";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(System.getProperty("os.name"));
            stringBuilder.append(" / ");
            stringBuilder.append(System.getProperty("os.arch"));
            stringBuilder.append(" / Java");
            stringBuilder.append(System.getProperty("java.version"));
            stringBuilder.append(")");
            Twitter twitter = TwitterFactory.getSingleton();
            String string2 = MessageFormat.format(string, MessageFactory.getFormatMessage("Info.Launch.Twitter", twitter.getScreenName()), stringBuilder.toString());
            string2 = StringUtils.left((String)string2, (int)140);
            twitter.updateStatus(string2);
            logger.debug("Twitter update..." + string2);
        }
    }

    public static void sleepingUpdateTwitter() throws Exception {
        ConfigBox configBox = ConfigBox.getInstance();
        boolean bl = configBox.getBoolVal("radioKaras", "useTwitter");
        if (bl) {
            String string = "{0} Powered by #RadioKaras";
            Twitter twitter = TwitterFactory.getSingleton();
            String string2 = MessageFormat.format(string, MessageFactory.getMessage("Info.Timer.Twitter"));
            string2 = StringUtils.left((String)string2, (int)140);
            twitter.updateStatus(string2);
            logger.debug("Twitter update..." + string2);
        }
    }

    public static boolean isEnabledTwitter() {
        try {
            Twitter twitter = TwitterFactory.getSingleton();
            AccessToken accessToken = TwitterHelper.loadAccessToken();
            twitter.setOAuthAccessToken(accessToken);
            return accessToken != null;
        }
        catch (Exception exception) {
            logger.error("System Error!", (Throwable)exception);
            return false;
        }
    }
}

