/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class MozillaDelegate {
    Browser browser;
    Shell eventShell;
    Listener listener;
    boolean hasFocus;
    static final String MOZILLA_RUNNING = "org.eclipse.swt.internal.mozillaRunning";

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(long l) {
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(l);
    }

    static String getCacheParentPath() {
        Object object;
        if (OS.VERSION >= 4192 && ((NSArray)(object = NSFileManager.defaultManager().URLsForDirectory(13L, 1L))).count() > 0L) {
            NSURL nSURL = new NSURL(((NSArray)object).objectAtIndex(0L));
            return String.valueOf(nSURL.path().getString()) + Mozilla.SEPARATOR_OS + "eclipse";
        }
        object = System.getProperty("user.home");
        return String.valueOf(object) + "/Library/Caches/eclipse";
    }

    static String getJSLibraryName() {
        return "libxpcom.dylib";
    }

    static String getJSLibraryName_Pre4() {
        return "libmozjs.dylib";
    }

    static String getLibraryName() {
        return "libxpcom.dylib";
    }

    static String getProfilePath() {
        String string = System.getProperty("user.home");
        return String.valueOf(string) + Mozilla.SEPARATOR_OS + ".mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String getSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    static void loadAdditionalLibraries(String string) {
        String string2 = String.valueOf(string) + Mozilla.SEPARATOR_OS + "libmozutils.dylib";
        byte[] byArray = MozillaDelegate.wcsToMbcs(null, string2, true);
        OS.NSAddImage(byArray, 9);
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        return new String(byArray).toCharArray();
    }

    static boolean needsSpinup() {
        return false;
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        if (bl) {
            string2 = String.valueOf(string2) + "\u0000";
        }
        return string2.getBytes();
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow nsIBaseWindow2) {
        this.browser.getDisplay().setData(MOZILLA_RUNNING, Boolean.TRUE);
        NSApplication nSApplication = NSApplication.sharedApplication();
        NSMenu nSMenu = nSApplication.mainMenu();
        if (nSMenu != null) {
            nSMenu.retain();
        }
        int n = nsIBaseWindow2.Create();
        nSApplication.setMainMenu(nSMenu);
        if (nSMenu != null) {
            nSMenu.release();
        }
        ((Mozilla)this.browser.webBrowser).Activate();
        return n;
    }

    long getHandle() {
        return this.browser.view.id;
    }

    long getSiteWindow() {
        return this.browser.view.id;
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        ((Mozilla)this.browser.webBrowser).Activate();
        this.browser.setFocus();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                if (event.type != 12) {
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                    MozillaDelegate.this.hasFocus = false;
                }
                MozillaDelegate.this.eventShell.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.eventShell.removeListener(27, this);
                MozillaDelegate.this.eventShell.removeListener(12, this);
                MozillaDelegate.this.eventShell = null;
                MozillaDelegate.this.listener = null;
            }
        };
        this.eventShell = this.browser.getShell();
        this.eventShell.getDisplay().addFilter(15, this.listener);
        this.eventShell.addListener(27, this.listener);
        this.eventShell.addListener(12, this.listener);
    }

    void handleMouseDown() {
        Mozilla mozilla = (Mozilla)this.browser.webBrowser;
        if (!mozilla.isActive) {
            mozilla.Activate();
        }
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
    }

    void onDispose(long l) {
        if (this.listener != null) {
            this.eventShell.getDisplay().removeFilter(15, this.listener);
            this.eventShell.removeListener(27, this.listener);
            this.eventShell.removeListener(12, this.listener);
            this.eventShell = null;
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    boolean sendTraverse() {
        return true;
    }

    void setSize(long l, int n, int n2) {
    }
}

