<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class Config {

  const INDEX_FILENAME = 'index.php';

  const DEFINE_SITEURL = 'REGISTER_SITEURL';

  const ON = '1';
  const OFF = '0';

  const SJIS = 'Shift_JIS';
  const EUC = 'EUC-JP';
  const UTF = 'UTF-8';

  const NORMAL_ACCESS = '0';
  const CLICK_LINK = '1';
  const CLICK_BTN = '2';
  const CLICK_ADSENSE = 'g';

  const JC_ENABLED_JC= '有効/有効';
  const JC_ENABLED_J= '有効/無効';
  const JC_ENABLED_C= '無効/有効';
  const JC_ENABLED_N= '無効/不明';

  const CLICK_REL = '_RAclick';

  const NOSELECT_PAGE = '全てのページ';
  const NOSELECT_UID = '全ての訪問者';

  const FROM_NO_SCRIPT = 'FROM NO SCRIPT';
  const FROM_BOOKMARK = 'ブックマーク等';
  const NO_DATA = 'unknown';

  const STANDARD_DIGIT = 4;
  const MAX_PAGE = 10;
  const MAX_DISP_LENGTH = 45;

  const SEARCH_URL = 'http://www.google.co.jp/search?q=';

  const COOKIE_ENABLE_DAYS = 365;
  const AUTOLOGIN_DAYS = 30;

  const COOKIE_LOGINID = '_ra_loginid';
  const COOKIE_LOGINKEY = '_ra_loginkey';
  const COOKIE_UID = '_ra_uid';

  const RELEASE_YEAR = 2009;

  const MINIMUM_MEMORY_LIMIT = 16;

  const UPGRADE_FILECHAR = '_';

  const CREATE_LOG_MONTHS = 1;

  const IMAGE_DIR_BROWSER = 'browser/';
  const IMAGE_DIR_OS = 'os/';
  const IMAGE_DIR_HOST = 'host/';
  const IMAGE_DIR_COUNTRY = 'country/';
  const IMAGE_DIR_PREF = 'pref/';

  public static function getCookieKeyAdminNocount() {
    return md5(constant(self::DEFINE_SITEURL));
  }

  public static $jpSecondLevelDomains = array(
                    'ac',
                    'ad',
                    'co',
                    'ed',
                    'go',
                    'gr',
                    'lg',
                    'ne',
                    'or'
  );

  public static $orgJpSecondLevelDomains = array(
                    'ac',
                    'co',
                    'ed',
                    'go',
                    'gr',
                    'lg',
                    'or'
  );

  public static $otherJpSecondLevelDomains = array(
                    'ad',
                    'ne',
                    'bbiq',
                    'zoot',
                    'commufa',
                    'doubleroute',
                    'j-cnet',
                    'bbiq',	
                    'itscom',
                    'bbexcite'
  );

  public static $otherJpThirdLevelDomains = array(
                    'plala',
                    'excite',
                    'bbiq',	
                    'dsn',
                    'itscom',
                    'j-cnet',
                    'jig',
                    'cnc',
                    'tcv',
                    'asahi-net',
                    'iij4u',
                    'index',
                    'din',
                    'interq',
                    'nifty',
                    'coara',
                    'tgn',
                    'commufa'
  );

    public static $countryTopLevelDomains = array(
                    'ad'=>'アンドラ',
                    'ae'=>'アラブ首長国連邦',
                    'af'=>'アフガニスタン',
                    'ag'=>'アンティグア・バーブーダ',
                    'ai'=>'アンギラ',
                    'al'=>'アルバニア',
                    'am'=>'アルメニア',
                    'an'=>'オランダ領アンティル',
                    'ao'=>'アンゴラ',
                    'ar'=>'アルゼンチン',
                    'as'=>'アメリカ領サモア',
                    'at'=>'オーストリア',
                    'au'=>'オーストラリア',
                    'aw'=>'アルバ',
                    'ax'=>'オーランド諸島',
                    'az'=>'アゼルバイジャン',
                    'ba'=>'ボスニア・ヘルツェゴビナ',
                    'bb'=>'バルバドス',
                    'bd'=>'バングラデシュ',
                    'be'=>'ベルギー',
                    'bf'=>'ブルキナファソ',
                    'bg'=>'ブルガリア',
                    'bh'=>'バーレーン',
                    'bi'=>'ブルンジ',
                    'bj'=>'ベナン',
                    'bm'=>'バミューダ諸島',
                    'bn'=>'ブルネイ',
                    'bo'=>'ボリビア',
                    'br'=>'ブラジル',
                    'bs'=>'バハマ',
                    'bt'=>'ブータン',
                    'bv'=>'ブーベ島',
                    'bw'=>'ボツワナ',
                    'by'=>'ベラルーシ',
                    'bz'=>'ベリーズ',
                    'ca'=>'カナダ',
                    'cc'=>'ココス諸島',
                    'cd'=>'コンゴ民主共和国',
                    'cf'=>'中央アフリカ共和国',
                    'cg'=>'コンゴ共和国',
                    'ch'=>'スイス',
                    'ci'=>'コートジボワール',
                    'ck'=>'クック諸島',
                    'cl'=>'チリ',
                    'cm'=>'カメルーン',
                    'cn'=>'中国',
                    'co'=>'コロンビア',
                    'cr'=>'コスタリカ',
                    'cu'=>'キューバ',
                    'cv'=>'カーボベルデ',
                    'cx'=>'クリスマス島',
                    'cy'=>'キプロス',
                    'cz'=>'チェコ',
                    'de'=>'ドイツ',
                    'dj'=>'ジブチ',
                    'dk'=>'デンマーク',
                    'dm'=>'ドミニカ国',
                    'do'=>'ドミニカ共和国',
                    'dz'=>'アルジェリア',
                    'ec'=>'エクアドル',
                    'ee'=>'エストニア',
                    'eg'=>'エジプト',
                    'eh'=>'西サハラ',
                    'er'=>'エリトリア',
                    'es'=>'スペイン',
                    'et'=>'エチオピア',
                    'fi'=>'フィンランド',
                    'fj'=>'フィジー',
                    'fm'=>'ミクロネシア連邦',
                    'fo'=>'フェロー諸島',
                    'fr'=>'フランス',
                    'fx'=>'フランス',
                    'ga'=>'ガボン',
                    'gb'=>'イギリス',
                    'gd'=>'グレナダ',
                    'ge'=>'グルジア',
                    'gf'=>'フランス領ギアナ',
                    'gh'=>'ガーナ',
                    'gi'=>'ジブラルタル',
                    'gl'=>'グリーンランド',
                    'gm'=>'ガンビア',
                    'gn'=>'ギニア',
                    'gp'=>'グアドループ',
                    'gq'=>'赤道ギニア',
                    'gr'=>'ギリシャ',
                    'gs'=>'サウスジョージア・サウスサンドウィッチ諸島',
                    'gt'=>'グアテマラ',
                    'gu'=>'グアム',
                    'gw'=>'ギニアビサウ',
                    'gy'=>'ガイアナ',
                    'hk'=>'香港',
                    'hm'=>'ハード島・マクドナルド諸島',
                    'hn'=>'ホンジュラス',
                    'hr'=>'クロアチア',
                    'ht'=>'ハイチ',
                    'hu'=>'ハンガリー',
                    'id'=>'インドネシア',
                    'ie'=>'アイルランド',
                    'il'=>'イスラエル',
                    'in'=>'インド',
                    'io'=>'インド洋地域',
                    'iq'=>'イラク',
                    'ir'=>'イラン',
                    'is'=>'アイスランド',
                    'it'=>'イタリア',
                    'jm'=>'ジャマイカ',
                    'jo'=>'ヨルダン',
                    'jp'=>'日本',
                    'ke'=>'ケニア',
                    'kg'=>'キルギス',
                    'kh'=>'カンボジア',
                    'ki'=>'キリバス',
                    'km'=>'コモロ',
                    'kn'=>'セントクリストファー・ネイビス',
                    'kp'=>'北朝鮮',
                    'kr'=>'韓国',
                    'kw'=>'クウェート',
                    'ky'=>'ケイマン諸島',
                    'kz'=>'カザフスタン',
                    'la'=>'ラオス',
                    'lb'=>'レバノン',
                    'lc'=>'セントルシア',
                    'li'=>'リヒテンシュタイン',
                    'lk'=>'スリランカ',
                    'lr'=>'リベリア',
                    'ls'=>'レソト',
                    'lt'=>'リトアニア',
                    'lu'=>'ルクセンブルグ',
                    'lv'=>'ラトビア',
                    'ly'=>'リビア',
                    'ma'=>'モロッコ',
                    'mc'=>'モナコ',
                    'md'=>'モルドバ',
                    'me'=>'モンテネグロ',
                    'mg'=>'マダガスカル',
                    'mh'=>'マーシャル諸島',
                    'mk'=>'マケドニア',
                    'ml'=>'マリ',
                    'mm'=>'ミャンマー',
                    'mn'=>'モンゴル',
                    'mo'=>'マカオ',
                    'mp'=>'北マリアナ諸島',
                    'mq'=>'マルティニーク',
                    'mr'=>'モーリタニア',
                    'ms'=>'モントセラト',
                    'mt'=>'マルタ',
                    'mu'=>'モーリシャス',
                    'mv'=>'モルディブ',
                    'mw'=>'マラウイ',
                    'mx'=>'メキシコ',
                    'my'=>'マレーシア',
                    'mz'=>'モザンビーク',
                    'na'=>'ナミビア',
                    'nc'=>'ニューカレドニア',
                    'ne'=>'ニジェール',
                    'nf'=>'ノーフォーク島',
                    'ng'=>'ナイジェリア',
                    'ni'=>'ニカラグア',
                    'nl'=>'オランダ',
                    'no'=>'ノルウェー',
                    'np'=>'ネパール',
                    'nr'=>'ナウル',
                    'nu'=>'ニウエ',
                    'nz'=>'ニュージーランド',
                    'om'=>'オマーン',
                    'pa'=>'パナマ',
                    'pe'=>'ペルー',
                    'pf'=>'ポリネシア',
                    'pg'=>'パプアニューギニア',
                    'ph'=>'フィリピン',
                    'pk'=>'パキスタン',
                    'pl'=>'ポーランド',
                    'pm'=>'サンピエール島・ミクロン島',
                    'pn'=>'ピトケアン諸島',
                    'pr'=>'プエルトリコ',
                    'ps'=>'パレスチナ自治区',
                    'pt'=>'ポルトガル',
                    'pw'=>'パラオ',
                    'py'=>'パラグアイ',
                    'qa'=>'カタール',
                    're'=>'レユニオン',
                    'ro'=>'ルーマニア',
                    'rs'=>'セルビア',
                    'ru'=>'ロシア連邦',
                    'rw'=>'ルワンダ',
                    'sa'=>'サウジアラビア',
                    'sb'=>'ソロモン諸島',
                    'sc'=>'セーシェル',
                    'sd'=>'スーダン',
                    'se'=>'スウェーデン',
                    'sg'=>'シンガポール',
                    'sh'=>'セントヘレナ',
                    'si'=>'スロベニア',
                    'sj'=>'スヴァールバル諸島、ヤンマイエン島',
                    'sk'=>'スロバキア',
                    'sl'=>'シエラレオネ',
                    'sm'=>'サンマリノ',
                    'sn'=>'セネガル',
                    'so'=>'ソマリア',
                    'sr'=>'スリナム',
                    'st'=>'サントメ・プリンシペ',
                    'sv'=>'エルサルバドル',
                    'sy'=>'シリア',
                    'sz'=>'スワジランド',
                    'tc'=>'タークス・カイコス諸島',
                    'td'=>'チャド',
                    'tf'=>'フランス領南方・南極地域',
                    'tg'=>'トーゴ',
                    'th'=>'タイ',
                    'tj'=>'タジキスタン',
                    'tk'=>'トケラウ',
                    'tl'=>'東ティモール',
                    'tm'=>'トルクメニスタン',
                    'tn'=>'チュニジア',
                    'to'=>'トンガ',
                    'tr'=>'トルコ',
                    'tt'=>'トリニダード・トバゴ',
                    'tv'=>'ツバル',
                    'tw'=>'台湾',
                    'tz'=>'タンザニア',
                    'ua'=>'ウクライナ',
                    'ug'=>'ウガンダ',
                    'um'=>'アメリカ領太平洋諸島',
                    'us'=>'アメリカ合衆国',
                    'uy'=>'ウルグアイ',
                    'uz'=>'ウズベキスタン',
                    'va'=>'バチカン市国',
                    'vc'=>'セントビンセント及びグレナディーン諸島',
                    've'=>'ベネズエラ',
                    'vg'=>'イギリス領ヴァージン諸島',
                    'vi'=>'アメリカ領ヴァージン諸島',
                    'vn'=>'ベトナム',
                    'vu'=>'バヌアツ',
                    'wf'=>'ウォリス・フツナ',
                    'ws'=>'サモア',
                    'ye'=>'イエメン',
                    'yt'=>'マヨット',
                    'za'=>'南アフリカ',
                    'zm'=>'ザンビア',
                    'zw'=>'ジンバブエ',
                    );

    public static $prefs = array(
                    '01'=>'北海道',
                    '02'=>'青森県',
                    '03'=>'岩手県',
                    '04'=>'宮城県',
                    '05'=>'秋田県',
                    '06'=>'山形県',
                    '07'=>'福島県',
                    '08'=>'茨城県',
                    '09'=>'栃木県',
                    '10'=>'群馬県',
                    '11'=>'埼玉県',
                    '12'=>'千葉県',
                    '13'=>'東京都',
                    '14'=>'神奈川県',
                    '15'=>'新潟県',
                    '16'=>'富山県',
                    '17'=>'石川県',
                    '18'=>'福井県',
                    '19'=>'山梨県',
                    '20'=>'長野県',
                    '21'=>'岐阜県',
                    '22'=>'静岡県',
                    '23'=>'愛知県',
                    '24'=>'三重県',
                    '25'=>'滋賀県',
                    '26'=>'京都府',
                    '27'=>'大阪府',
                    '28'=>'兵庫県',
                    '29'=>'奈良県',
                    '30'=>'和歌山県',
                    '31'=>'鳥取県',
                    '32'=>'島根県',
                    '33'=>'岡山県',
                    '34'=>'広島県',
                    '35'=>'山口県',
                    '36'=>'徳島県',
                    '37'=>'香川県',
                    '38'=>'愛媛県',
                    '39'=>'高知県',
                    '40'=>'福岡県',
                    '41'=>'佐賀県',
                    '42'=>'長崎県',
                    '43'=>'熊本県',
                    '44'=>'大分県',
                    '45'=>'宮崎県',
                    '46'=>'鹿児島県',
                    '47'=>'沖縄県'
                               );

    public static $prefKeywords = array(
                    'a-nagoya'=>'23',
                    'aic'=>'23',
                    'aichi'=>'23',
                    'aici'=>'23',
                    'aizu'=>'07',
                    'akatsuka'=>'08',
                    'aki'=>'05',
                    'akit'=>'05',
                    'akita'=>'05',
                    'akitaa'=>'05',
                    'aksh'=>'28',
                    'akt'=>'05',
                    'akta'=>'05',
                    'aom'=>'02',
                    'aomori'=>'02',
                    'aomoria'=>'02',
                    'aomr'=>'02',
                    'asahikawa'=>'01',
                    'asaka'=>'11',
                    'ashikaga'=>'09',
                    'ashk'=>'01',
                    'askg'=>'09',
                    'atgi'=>'14',
                    'atsugi'=>'14',
                    'beppu'=>'44',
                    'chb'=>'12',
                    'chba'=>'12',
                    'chfu'=>'13',
                    'chib'=>'12',
                    'chiba'=>'12',
                    'chitose'=>'01',
                    'chofu'=>'13',
                    'choushi'=>'12',
                    'ctse'=>'01',
                    'd-kobe'=>'28',
                    'd-nagoya'=>'23',
                    'd-osaka'=>'27',
                    'ebina'=>'14',
                    'ehim'=>'38',
                    'ehime'=>'38',
                    'ehimea'=>'38',
                    'ehm'=>'38',
                    'fchu'=>'13',
                    'fjnm'=>'22',
                    'fjsw'=>'14',
                    'fkcy'=>'26',
                    'fki'=>'18',
                    'fkk'=>'40',
                    'fko'=>'40',
                    'fkok'=>'40',
                    'fks'=>'07',
                    'fksm'=>'07',
                    'fkui'=>'18',
                    'fkym'=>'34',
                    'fnbs'=>'12',
                    'fuchu'=>'13',
                    'fuji'=>'22',
                    'fujisawa'=>'14',
                    'fujiyoshida'=>'22',
                    'fuki'=>'18',
                    'fuku'=>'40',
                    'fukuchiyama'=>'26',
                    'fukui'=>'18',
                    'fukuia'=>'18',
                    'fukuoka'=>'40',
                    'fukuokaa'=>'40',
                    'fukushima'=>'07',
                    'fukushimaa'=>'07',
                    'fukusima'=>'07',
                    'fukuyama'=>'34',
                    'funabashi'=>'12',
                    'funabasi'=>'12',
                    'gif'=>'21',
                    'gifu'=>'21',
                    'gnm'=>'10',
                    'gunm'=>'10',
                    'gunma'=>'10',
                    'hachinohe'=>'02',
                    'hachioji'=>'13',
                    'hachiouji'=>'13',
                    'haci'=>'13',
                    'hakata'=>'40',
                    'hakodate'=>'01',
                    'hamamatsu'=>'22',
                    'handa'=>'23',
                    'hann'=>'11',
                    'hanno'=>'11',
                    'hashimoto'=>'30',
                    'hcnh'=>'02',
                    'hcou'=>'13',
                    'hgsh'=>'34',
                    'hgsm'=>'11',
                    'hhrs'=>'34',
                    'higashi-matsuyama'=>'11',
                    'higashimatsuyama'=>'11',
                    'hikn'=>'25',
                    'himeji'=>'28',
                    'himj'=>'28',
                    'hino'=>'13',
                    'hirakata'=>'27',
                    'hiratsuka'=>'14',
                    'hirosaki'=>'02',
                    'hiroshima'=>'34',
                    'hiroshimaa'=>'34',
                    'hirosima'=>'34',
                    'hitachi'=>'08',
                    'hitachiota'=>'08',
                    'hkd'=>'01',
                    'hkdt'=>'01',
                    'hkid'=>'01',
                    'hkne'=>'25',
                    'hmji'=>'28',
                    'hmmt'=>'22',
                    'hmty'=>'11',
                    'hnda'=>'23',
                    'hnjo'=>'11',
                    'hnnu'=>'11',
                    'hokkaido'=>'01',
                    'hokkaidoa'=>'01',
                    'honjo'=>'11',
                    'hrs'=>'34',
                    'hrsk'=>'02',
                    'hrsm'=>'34',
                    'hrtk'=>'14',
                    'htch'=>'08',
                    'hyg'=>'28',
                    'hyog'=>'28',
                    'hyogo'=>'28',
                    'iba'=>'08',
                    'ibaragi'=>'08',
                    'ibaraki'=>'08',
                    'ibrk'=>'27',
                    'ibr'=>'08',
                    'ichihara'=>'12',
                    'ichikawa'=>'12',
                    'ichinomiya'=>'23',
                    'ichr'=>'12',
                    'ickw'=>'12',
                    'icnm'=>'23',
                    'iida'=>'20',
                    'ikda'=>'27',
                    'iked'=>'27',
                    'ikeda'=>'27',
                    'imbr'=>'38',
                    'ina-'=>'20',
                    'ingi'=>'13',
                    'ise-'=>'24',
                    'isesaki'=>'10',
                    'isex'=>'24',
                    'ishikawa'=>'17',
                    'ishioka'=>'08',
                    'isk'=>'17',
                    'ismk'=>'04',
                    'isnm'=>'04',
                    'isok'=>'08',
                    'iszk'=>'10',
                    'itak'=>'08',
                    'itako'=>'08',
                    'itami'=>'28',
                    'ito'=>'22',
                    'itox'=>'22',
                    'iwa'=>'03',
                    'iwade'=>'03',
                    'iwak'=>'07',
                    'iwaki'=>'07',
                    'iwata'=>'22',
                    'iwate'=>'03',
                    'iwat'=>'03',
                    'iwki'=>'07',
                    'iwkn'=>'35',
                    'iwta'=>'22',
                    'izmi'=>'27',
                    'izms'=>'27',
                    'izum'=>'32',
                    'izumi'=>'27',
                    'izumo'=>'32',
                    'joetsu'=>'15',
                    'jyouetsu'=>'15',
                    'k-fujisawa'=>'14',
                    'k-tokyo'=>'13',
                    'kagawa'=>'37',
                    'kagoshima'=>'46',
                    'kakogawa'=>'28',
                    'kakokawa'=>'28',
                    'kanagawa'=>'14',
                    'kanagawashinmachi'=>'14',
                    'kanazawa'=>'17',
                    'kani'=>'21',
                    'kariya'=>'23',
                    'kary'=>'23',
                    'kasai'=>'28',
                    'kashiwa'=>'12',
                    'kashiwazaki'=>'15',
                    'kasugai'=>'23',
                    'kasw'=>'12',
                    'kawagoe'=>'11',
                    'kawaguchi'=>'11',
                    'kawasaki'=>'14',
                    'kawasakibekkan'=>'14',
                    'kbe'=>'28',
                    'kch'=>'39',
                    'kgci'=>'11',
                    'kgs'=>'46',
                    'kgsm'=>'46',
                    'kgw'=>'37',
                    'kichijoji'=>'13',
                    'kiryu'=>'10',
                    'kisarazu'=>'12',
                    'kishiwada'=>'27',
                    'kishiwada-kaizuka'=>'27',
                    'kitakyushu'=>'40',
                    'kitakyusyu'=>'40',
                    'kitk'=>'40',
                    'kkeg'=>'22',
                    'kkgw'=>'28',
                    'kkog'=>'28',
                    'kmgy'=>'11',
                    'kmm'=>'43',
                    'kmmt'=>'43',
                    'kmok'=>'26',
                    'kng'=>'14',
                    'kngw'=>'14',
                    'knzw'=>'17',
                    'kob'=>'28',
                    'kobe'=>'28',
                    'koc'=>'39',
                    'kochi'=>'39',
                    'koci'=>'39',
                    'kodaira'=>'13',
                    'kofu'=>'19',
                    'koga'=>'08',
                    'koganei'=>'13',
                    'kokubunji'=>'13',
                    'kooriyama'=>'07',
                    'koriyama'=>'07',
                    'koshigaya'=>'11',
                    'kouchi'=>'39',
                    'koufu'=>'19',
                    'krme'=>'40',
                    'krsk'=>'33',
                    'krya'=>'23',
                    'krym'=>'07',
                    'kryu'=>'10',
                    'ksgi'=>'23',
                    'ksgy'=>'11',
                    'ksma'=>'08',
                    'ksro'=>'01',
                    'ksrz'=>'12',
                    'kswa'=>'12',
                    'kswd'=>'27',
                    'ktks'=>'40',
                    'ktmi'=>'01',
                    'kufu'=>'19',
                    'kuki'=>'11',
                    'kumagaya'=>'11',
                    'kumamoto'=>'43',
                    'kumamotoa'=>'43',
                    'kunitachi'=>'13',
                    'kurashiki'=>'33',
                    'kure'=>'34',
                    'kurm'=>'40',
                    'kurume'=>'40',
                    'kushiro'=>'01',
                    'kusr'=>'01',
                    'kuwana'=>'24',
                    'kwgc'=>'11',
                    'kwge'=>'11',
                    'kwgw'=>'11',
                    'kwna'=>'24',
                    'kwsk'=>'14',
                    'kyot'=>'26',
                    'kyoto'=>'26',
                    'kyt'=>'26',
                    'kyto'=>'26',
                    'm-hiroshima'=>'34',
                    'm-yokohama'=>'14',
                    'ma-shizuoka'=>'22',
                    'machida'=>'13',
                    'maebashi'=>'10',
                    'makuhari'=>'12',
                    'marugame'=>'37',
                    'matsudo'=>'12',
                    'matsue'=>'32',
                    'matsumoto'=>'20',
                    'matsuyama'=>'38',
                    'matumoto'=>'20',
                    'mbra'=>'12',
                    'mcda'=>'13',
                    'mebs'=>'10',
                    'mi-shizuoka'=>'22',
                    'mie'=>'24',
                    'mie-'=>'24',
                    'miki'=>'28',
                    'minamiosaka'=>'27',
                    'minokamo'=>'21',
                    'mitaka'=>'13',
                    'mito'=>'08',
                    'miyagi'=>'04',
                    'miyagia'=>'04',
                    'miyazaki'=>'45',
                    'miyazakia'=>'45',
                    'miyg'=>'04',
                    'mnkc'=>'25',
                    'mnkm'=>'21',
                    'mobara'=>'12',
                    'mobr'=>'12',
                    'morioka'=>'03',
                    'mrgm'=>'37',
                    'mrok'=>'03',
                    'mrrn'=>'01',
                    'mtak'=>'13',
                    'mtdo'=>'12',
                    'mtki'=>'08',
                    'mtmt'=>'20',
                    'mtue'=>'32',
                    'mtym'=>'38',
                    'mtzk'=>'24',
                    'muroran'=>'01',
                    'musashino'=>'13',
                    'musashino-mitaka'=>'13',
                    'myg'=>'04',
                    'myz'=>'45',
                    'myzk'=>'45',
                    'n-nishinomiya'=>'28',
                    'n-osaka'=>'27',
                    'n-yokohama'=>'14',
                    'nagano'=>'20',
                    'naganoa'=>'20',
                    'nagaoka'=>'15',
                    'nagasaki'=>'42',
                    'nagasakia'=>'42',
                    'nagoya'=>'23',
                    'nah'=>'47',
                    'naha'=>'47',
                    'nara'=>'29',
                    'narita'=>'12',
                    'nbok'=>'45',
                    'nbri'=>'24',
                    'neyagawa'=>'27',
                    'nghm'=>'25',
                    'ngn'=>'20',
                    'ngno'=>'20',
                    'ngok'=>'15',
                    'ngs'=>'42',
                    'ngsk'=>'42',
                    'ngya'=>'23',
                    'nig'=>'15',
                    'nigata'=>'15',
                    'nigt'=>'15',
                    'nihm'=>'38',
                    'nihonbashi'=>'13',
                    'niigata'=>'15',
                    'niigataa'=>'15',
                    'niihama'=>'38',
                    'nishinomiya'=>'28',
                    'nishitokyo'=>'13',
                    'nmzu'=>'22',
                    'nobeoka'=>'45',
                    'nra'=>'29',
                    'nrit'=>'12',
                    'nrta'=>'12',
                    'nsnm'=>'28',
                    'numazu'=>'22',
                    'numz'=>'22',
                    'nygw'=>'27',
                    'o-ichikawa'=>'12',
                    'obhr'=>'01',
                    'obihiro'=>'01',
                    'odawara'=>'14',
                    'odwr'=>'14',
                    'ogak'=>'21',
                    'ogaki'=>'21',
                    'ogki'=>'21',
                    'ogwr'=>'04',
                    'ohgaki'=>'21',
                    'ohita'=>'44',
                    'oit'=>'44',
                    'oita'=>'44',
                    'okayama'=>'33',
                    'okayamaa'=>'33',
                    'okazaki'=>'23',
                    'okinawa'=>'47',
                    'okinawaa'=>'47',
                    'okn'=>'47',
                    'oknw'=>'47',
                    'oky'=>'33',
                    'okym'=>'33',
                    'okzk'=>'23',
                    'ome'=>'13',
                    'omiya'=>'11',
                    'omut'=>'40',
                    'omuta'=>'40',
                    'onomichi'=>'34',
                    'oots'=>'25',
                    'ootsu'=>'25',
                    'os'=>'27',
                    'osa'=>'27',
                    'osak'=>'27',
                    'osaka'=>'27',
                    'osakakita'=>'27',
                    'osk'=>'27',
                    'oska'=>'27',
                    'ota'=>'10',
                    'otaru'=>'01',
                    'otawara'=>'09',
                    'otru'=>'01',
                    'otsu'=>'25',
                    'otwr'=>'09',
                    'oume'=>'13',
                    'oyam'=>'09',
                    'oyama'=>'09',
                    'rygs'=>'08',
                    'ryugasaki'=>'08',
                    's-kawasaki'=>'14',
                    's-tokyo'=>'13',
                    'sag'=>'41',
                    'saga'=>'41',
                    'sagamihara'=>'14',
                    'saiki'=>'44',
                    'saitama'=>'11',
                    'sakado'=>'11',
                    'sakai'=>'27',
                    'sakaide'=>'37',
                    'sakata'=>'06',
                    'sand'=>'28',
                    'sanda'=>'28',
                    'sanjyo'=>'15',
                    'sano'=>'09',
                    'sapporo'=>'01',
                    'sapporokita'=>'01',
                    'sapporonishi'=>'01',
                    'sasebo'=>'42',
                    'sawara'=>'12',
                    'sbkw'=>'10',
                    'sendai'=>'04',
                    'setaka'=>'40',
                    'seto'=>'23',
                    'sgmi'=>'14',
                    'shiboguchi'=>'14',
                    'shiga'=>'25',
                    'shiki'=>'11',
                    'shimane'=>'32',
                    'shimizu'=>'22',
                    'shimodate'=>'08',
                    'shimonoseki'=>'35',
                    'shinjuku'=>'13',
                    'shinkurashiki'=>'33',
                    'shirakawa'=>'07',
                    'shizuoka'=>'22',
                    'shra'=>'12',
                    'sig'=>'25',
                    'siga'=>'25',
                    'sitm'=>'11',
                    'sizuoka'=>'22',
                    'skai'=>'27',
                    'skta'=>'06',
                    'smdt'=>'08',
                    'smiz'=>'22',
                    'smn'=>'32',
                    'smzu'=>'22',
                    'snda'=>'28',
                    'sndi'=>'04',
                    'soka'=>'11',
                    'souka'=>'11',
                    'sppr'=>'01',
                    'spro'=>'01',
                    'srga'=>'18',
                    'ssbo'=>'42',
                    'stm'=>'11',
                    'sumoto'=>'28',
                    'suwa'=>'20',
                    'szo'=>'22',
                    'szok'=>'22',
                    't-osaka'=>'27',
                    't-tokyo'=>'13',
                    'tachikawa'=>'13',
                    'tajimi'=>'21',
                    'tajm'=>'21',
                    'takada'=>'29',
                    'takamatsu'=>'37',
                    'takaoka'=>'16',
                    'takasaki'=>'10',
                    'takatsuki'=>'27',
                    'takatuki'=>'27',
                    'tama'=>'13',
                    'tanabe'=>'30',
                    'tatebayashi'=>'10',
                    'tcg'=>'09',
                    'tocg'=>'09',
                    'tcgi'=>'09',
                    'tckw'=>'13',
                    'tcur'=>'08',
                    'te-fukuoka'=>'40',
                    'tjmi'=>'21',
                    'tk'=>'13',
                    'tkba'=>'08',
                    'tkct'=>'23',
                    'tkgw'=>'01',
                    'tkmt'=>'37',
                    'tkok'=>'16',
                    'tkrz'=>'11',
                    'tks'=>'36',
                    'tksk'=>'10',
                    'tksm'=>'36',
                    'tktk'=>'27',
                    'tky'=>'13',
                    'tkym'=>'35',
                    'tkyo'=>'13',
                    'tmkm'=>'01',
                    'tndb'=>'27',
                    'tochigi'=>'09',
                    'togane'=>'12',
                    'togn'=>'12',
                    'tokai'=>'23',
                    'toki'=>'23',
                    'tokorozawa'=>'11',
                    'tokushima'=>'36',
                    'toky'=>'13',
                    'tokyo'=>'13',
                    'tond'=>'27',
                    'tondabayashi'=>'27',
                    'totr'=>'31',
                    'tottori'=>'31',
                    'tottoria'=>'31',
                    'toyama'=>'16',
                    'toyamaa'=>'16',
                    'toym'=>'16',
                    'toyohashi'=>'23',
                    'toyota'=>'23',
                    'toyt'=>'23',
                    'trok'=>'06',
                    'tsma'=>'23',
                    'tsu'=>'24',
                    'tsu-'=>'24',
                    'tsuchiura'=>'08',
                    'tsukuba'=>'08',
                    'tsushima'=>'23',
                    'tsux'=>'24',
                    'ttby'=>'10',
                    'ttr'=>'31',
                    'ttri'=>'31',
                    'ttse'=>'01',
                    'tyhs'=>'23',
                    'tym'=>'16',
                    'tyma'=>'16',
                    'tyta'=>'23',
                    'ube'=>'35',
                    'ube-'=>'35',
                    'ubex'=>'35',
                    'ueda'=>'20',
                    'ueno'=>'24',
                    'uji'=>'26',
                    'uji-'=>'26',
                    'ujix'=>'26',
                    'uraw'=>'11',
                    'urawa'=>'11',
                    'urayasu'=>'12',
                    'urw'=>'11',
                    'urwa'=>'11',
                    'usuki'=>'44',
                    'utnm'=>'09',
                    'utsunomiya'=>'09',
                    'utunomiya'=>'09',
                    'wakayama'=>'30',
                    'wky'=>'30',
                    'wkym'=>'30',
                    'yamagata'=>'06',
                    'yamagataa'=>'06',
                    'yamaguchi'=>'35',
                    'yamaguchia'=>'35',
                    'yamanashi'=>'19',
                    'yamasaki'=>'28',
                    'yamatokashihara'=>'29',
                    'yamatotakada'=>'29',
                    'yao'=>'27',
                    'yao-'=>'27',
                    'yaox'=>'27',
                    'yatsushiro'=>'43',
                    'ygc'=>'35',
                    'ygt'=>'06',
                    'ykh'=>'14',
                    'ykhm'=>'14',
                    'ykic'=>'24',
                    'yksk'=>'14',
                    'ymg'=>'06',
                    'ymgc'=>'35',
                    'ymgt'=>'06',
                    'ymn'=>'19',
                    'ymtk'=>'29',
                    'yngo'=>'31',
                    'ynzw'=>'06',
                    'yokkaichi'=>'24',
                    'yokohama'=>'14',
                    'yokohamako'=>'14',
                    'yokosuka'=>'14',
                    'yonago'=>'31',
                    'yonezawa'=>'06',
                    'yong'=>'31',
                    'yono'=>'11',
                    'ytsr'=>'43',
                    'yuib'=>'12',
                    'kita-kyushu'=>'40',
                    'narashino'=>'12',
                    'isehara'=>'14',
                    'hikone'=>'25',
                    'sagami'=>'14',
                    'yamato'=>'14',
                    'yamato-takada'=>'29',
                    'ohtsu'=>'25',
                    'miex'=>'24',
                    'aich'=>'23',
                    'hygo'=>'28',
                    'mygi'=>'04',
                    'iwte'=>'03',
                    'gnma'=>'10',
                    'ehme'=>'38',
                    'kgwa'=>'37',
                    'ymns'=>'19',
                    'iskw'=>'17',
                    'hachiohji'=>'13',
                    'hkata'=>'40',
                    'kasiw'=>'12',
                    'kkysh'=>'40',
                    'chgsk'=>'14',
                    'nrima'=>'13',
                    'yoksk'=>'14',
                    'maebs'=>'10',
                    'itabs'=>'13',
                    'stama'=>'11',
                    'fkoka'=>'40',
                    'kkbnj'=>'13',
                    'edgwa'=>'13',
                    'sappr'=>'01',
                    'fjswa'=>'14',
                    'sagam'=>'14',
                    'ntkyo'=>'13',
                    'shmki'=>'35',
                    'ksrzu'=>'12',
                    'yamat'=>'14',
                    'shga'=>'25',
                    'kuch'=>'39',
                    'smne'=>'32',
                    'ooit'=>'44',
                    'ohta'=>'13',
                    'ktsk'=>'13',
                    'kyma'=>'09',
                    'nkno'=>'13',
                    'aksi'=>'28',
                    'rccx'=>'08',
                    'oyma'=>'09',
                    'oumi'=>'25',
                    'oomt'=>'40',
                    'tugn'=>'12',
                    'kshr'=>'29',
                    'hrkt'=>'27',
                    'nnao'=>'17',
                    'kmts'=>'12',
                    'mtse'=>'32',
                    'kmts'=>'17',
                    'fjys'=>'19',
                    'imabari'=>'38',
                    'higashi-hiroshima'=>'34',
                    'furukawa'=>'08',
                    'nagahama'=>'25',
                    'ohtawara'=>'09',
                    'tokuyama'=>'35',
                    'tomakomai'=>'01',
                    'komatsu'=>'17',
                    'iwakuni'=>'35',
                    'shibukawa'=>'10',
                    'ichinoseki'=>'03',
                    'ohme'=>'13',
                    'takikawa'=>'01',
                    'nishiwaki'=>'28',
                    'o-tokyo'=>'13',
                    'hitachioota'=>'08',
                    'nar'=>'29',
                    'szk'=>'22',
                    'a001'=>'01',
                    'a002'=>'02',
                    'a003'=>'03',
                    'a004'=>'04',
                    'a005'=>'05',
                    'a006'=>'06',
                    'a007'=>'07',
                    'a008'=>'08',
                    'a009'=>'09',
                    'a010'=>'10',
                    'a011'=>'11',
                    'a012'=>'12',
                    'a013'=>'13',
                    'a014'=>'14',
                    'a015'=>'15',
                    'a016'=>'16',
                    'a017'=>'17',
                    'a018'=>'18',
                    'a019'=>'19',
                    'a020'=>'20',
                    'a021'=>'21',
                    'a022'=>'22',
                    'a023'=>'23',
                    'a024'=>'24',
                    'a025'=>'25',
                    'a026'=>'26',
                    'a027'=>'27',
                    'a028'=>'28',
                    'a029'=>'29',
                    'a030'=>'30',
                    'a031'=>'31',
                    'a032'=>'32',
                    'a033'=>'33',
                    'a034'=>'34',
                    'a035'=>'35',
                    'a036'=>'36',
                    'a037'=>'37',
                    'a038'=>'38',
                    'a039'=>'39',
                    'a040'=>'40',
                    'a041'=>'41',
                    'a042'=>'42',
                    'a043'=>'43',
                    'a044'=>'44',
                    'a045'=>'45',
                    'a046'=>'46',
                    'a047'=>'47',
                    'tkbn'=>'13',
                    'toyizu'=>'22',
                    'kube'=>'28',
                    'totigi'=>'09',
                    'kagw'=>'37',
                    'simn'=>'32',
                    'ntky'=>'13',
                    'SOD'=>'01',
                    'OKI'=>'02',
                    'MRN'=>'03',
                    'AOB'=>'04',
                    'NKD'=>'05',
                    'IMZ'=>'06',
                    'HNZ'=>'07',
                    'AKA'=>'08',
                    'HRD'=>'09',
                    'KKR'=>'10',
                    'SKN'=>'11',
                    'FNA'=>'12',
                    'HDO'=>'14',
                    'NGN'=>'15',
                    'TYN'=>'16',
                    'KNN'=>'17',
                    'FKN'=>'18',
                    'KFN'=>'19',
                    'SYD'=>'20',
                    'SDD'=>'22',
                    'SSJ'=>'23',
                    'YKM'=>'24',
                    'OTU'=>'25',
                    'KYN'=>'26',
                    'NWT'=>'27',
                    'KBM'=>'28',
                    'DAJ'=>'29',
                    'WKN'=>'30',
                    'TTN'=>'31',
                    'SMN'=>'32',
                    'IMM'=>'33',
                    'NIH'=>'34',
                    'YGN'=>'35',
                    'TKN'=>'36',
                    'TMN'=>'37',
                    'MYN'=>'38',
                    'KCM'=>'39',
                    'FKC'=>'40',
                    'TGS'=>'41',
                    'SCO'=>'42',
                    'OBY'=>'43',
                    'OMC'=>'44',
                    'MZN'=>'45',
                    'KMI'=>'46',
                    'YRM'=>'47'
                                      );
                                      
    public static $prefWords = array(
                    'hokkaido'=>'01',
                    'aomori'=>'02',
                    'iwate'=>'03',
                    'miyagi'=>'04',
                    'akita'=>'05',
                    'yamagata'=>'06',
                    'fukushima'=>'07',
                    'ibaraki'=>'08',
                    'tochigi'=>'09',
                    'gunma'=>'10',
                    'saitama'=>'11',
                    'chiba'=>'12',
                    'tokyo'=>'13',
                    'kanagawa'=>'14',
                    'niigata'=>'15',
                    'toyama'=>'16',
                    'ishikawa'=>'17',
                    'fukui'=>'18',
                    'yamanashi'=>'19',
                    'nagano'=>'20',
                    'gifu'=>'21',
                    'shizuoka'=>'22',
                    'aichi'=>'23',
                    'mie'=>'24',
                    'shiga'=>'25',
                    'kyoto'=>'26',
                    'osaka'=>'27',
                    'hyogo'=>'28',
                    'nara'=>'29',
                    'wakayama'=>'30',
                    'tottori'=>'31',
                    'shimane'=>'32',
                    'okayama'=>'33',
                    'hiroshima'=>'34',
                    'yamaguchi'=>'35',
                    'tokushima'=>'36',
                    'kagawa'=>'37',
                    'ehime'=>'38',
                    'kochi'=>'39',
                    'fukuoka'=>'40',
                    'saga'=>'41',
                    'nagasaki'=>'42',
                    'kumamoto'=>'43',
                    'oita'=>'44',
                    'miyazaki'=>'45',
                    'kagoshima'=>'46',
                    'okinawa'=>'47'
                                      );

    public static $prefOrgDomains = array(
                    'hokudai.ac.jp'=>'01',
                    'hokkyodai.ac.jp'=>'01',
                    'muroran-it.ac.jp'=>'01',
                    'otaru-uc.ac.jp'=>'01',
                    'obihiro.ac.jp'=>'01',
                    'asahikawa-med.ac.jp'=>'01',
                    'kitami-it.ac.jp'=>'01',
                    'hirosaki-u.ac.jp'=>'02',
                    'iwate-u.ac.jp'=>'03',
                    'tohoku.ac.jp'=>'04',
                    'miyakyo-u.ac.jp'=>'04',
                    'akita-u.ac.jp'=>'05',
                    'yamagata-u.ac.jp'=>'06',
                    'fukushima-u.ac.jp'=>'07',
                    'ibaraki.ac.jp'=>'08',
                    'tsukuba.ac.jp'=>'08',
                    'utsunomiya-u.ac.jp'=>'09',
                    'gunma-u.ac.jp'=>'10',
                    'saitama-u.ac.jp'=>'11',
                    'chiba-u.ac.jp'=>'12',
                    'u-tokyo.ac.jp'=>'13',
                    'tmd.ac.jp'=>'13',
                    'tufs.ac.jp'=>'13',
                    'u-gakugei.ac.jp'=>'13',
                    'tuat.ac.jp'=>'13',
                    'geidai.ac.jp'=>'13',
                    'titech.ac.jp'=>'13',
                    'tosho-u.ac.jp'=>'13',
                    'tokyo-u-fish.ac.jp'=>'13',
                    'ocha.ac.jp='=>'13',
                    'uec.ac.jp'=>'13',
                    'hit-u.ac.jp'=>'13',
                    'ynu.ac.jp'=>'14',
                    'niigata-u.ac.jp'=>'15',
                    'toyama-u.ac.jp'=>'16',
                    'kanazawa-u.ac.jp'=>'17',
                    'fukui-u.ac.jp'=>'18',
                    'yamanashi.ac.jp'=>'19',
                    'shinshu-u.ac.jp'=>'20',
                    'gifu-u.ac.jp'=>'21',
                    'shizuoka.ac.jp'=>'22',
                    'nagoya-u.ac.jp'=>'23',
                    'aichi-edu.ac.jp'=>'23',
                    'nitech.ac.jp'=>'23',
                    'mie-u.ac.jp'=>'24',
                    'shiga-u.ac.jp'=>'25',
                    'kyoto-u.ac.jp'=>'26',
                    'kyokyo-u.ac.jp'=>'26',
                    'kit.ac.jp'=>'26',
                    'osaka-u.ac.jp'=>'27',
                    'osaka-gaidai.ac.jp'=>'27',
                    'osaka-kyoiku.ac.jp'=>'27',
                    'kobe-u.ac.jp'=>'28',
                    'kshosen.ac.jp'=>'28',
                    'nara-edu.ac.jp'=>'29',
                    'nara-wu.ac.jp'=>'29',
                    'wakayama-u.ac.jp'=>'30',
                    'tottori-u.ac.jp'=>'31',
                    'shimane-u.ac.jp'=>'32',
                    'okayama-u.ac.jp'=>'33',
                    'hiroshima-u.ac.jp'=>'34',
                    'yamaguchi-u.ac.jp'=>'35',
                    'tokushima-u.ac.jp'=>'36',
                    'kagawa-u.ac.jp'=>'37',
                    'ehime-u.ac.jp'=>'38',
                    'kochi-u.ac.jp'=>'39',
                    'fukuoka-edu.ac.jp'=>'40',
                    'kyushu-u.ac.jp'=>'40',
                    'kyushu-id.ac.jp'=>'40',
                    'kyutech.ac.jp'=>'40',
                    'saga-u.ac.jp'=>'41',
                    'nagasaki-u.ac.jp'=>'42',
                    'kumamoto-u.ac.jp'=>'43',
                    'oita-u.ac.jp'=>'44',
                    'miyazaki-u.ac.jp'=>'45',
                    'kagoshima-u.ac.jp'=>'46',
                    'u-ryukyu.ac.jp'=>'47',
                    'hama-med.ac.jp'=>'22',
                    'shiga-med.ac.jp'=>'25',
                    'miyazaki-med.ac.jp'=>'45',
                    'toyama-mpu.ac.jp'=>'16',
                    'shimane-med.ac.jp'=>'32',
                    'nagaokaut.ac.jp'=>'15',
                    'tut.ac.jp'=>'23',
                    'kochi-ms.ac.jp'=>'39',
                    'saga-med.ac.jp'=>'41',
                    'oita-med.ac.jp'=>'44',
                    'juen.ac.jp'=>'20',
                    'fukui-med.ac.jp'=>'18',
                    'yamanashi-med.ac.jp'=>'19',
                    'hyogo-u.ac.jp'=>'28',
                    'kms.ac.jp'=>'37',
                    'ulis.ac.jp'=>'08',
                    'naruto-u.ac.jp'=>'36',
                    'nifs-k.ac.jp'=>'46',
                    'soken.ac.jp'=>'14',
                    'jaist.ac.jp'=>'17',
                    'aist-nara.ac.jp'=>'29',
                    'sophia.ac.jp'=>'13',
                    'chukyo-u.ac.jp'=>'23',
                    'waseda.ac.jp'=>'13',
                    'keio.ac.jp'=>'13',
                    'ritsumei.ac.jp'=>'26',
                    'aoyama.ac.jp'=>'13',
                    'chubu.ac.jp'=>'13',
                    'hal.ac.jp'=>'27',
                    'kuis.ac.jp'=>'12',
                    'teu.ac.jp'=>'13',
                    'adachi.ne.jp'=>'13',
                    'avis.ne.jp'=>'20',
                    'cable-net.ne.jp'=>'25',
                    'catvy.ne.jp'=>'06',
                    'cc9.ne.jp'=>'09',
                    'ccn.ne.jp'=>'11',
                    'c-d-k.ne.jp'=>'23',
                    'cna.ne.jp'=>'05',
                    'cncm.ne.jp'=>'42',
                    'ctk.ne.jp'=>'21',
                    'ctt.ne.jp'=>'16',
                    'ecatv.ne.jp'=>'15',
                    'e-catv.ne.jp'=>'38',
                    'fctv.ne.jp'=>'18',
                    'hinocatv.ne.jp'=>'13',
                    'htv-net.ne.jp'=>'02',
                    'icntv.ne.jp'=>'12',
                    'i-younet.ne.jp'=>'22',
                    'kamakuranet.ne.jp'=>'14',
                    'katch.ne.jp'=>'23',
                    'kcn.ne.jp'=>'27',
                    'kcn-tv.ne.jp'=>'43',
                    'kct.ne.jp'=>'33',
                    'kctv.ne.jp'=>'23',
                    'kobe-catv.ne.jp'=>'28',
                    'kumin.ne.jp'=>'40',
                    'lan-do.ne.jp'=>'01',
                    'mctv.ne.jp'=>'24',
                    'mecha.ne.jp'=>'24',
                    'nava21.ne.jp'=>'24',
                    'nns.ne.jp'=>'19',
                    'oct-net.ne.jp'=>'44',
                    'parkcity.ne.jp'=>'13',
                    'scn-net.ne.jp'=>'14',
                    'seaple-n.icc.ne.jp'=>'12',
                    'spacelan.ne.jp'=>'17',
                    'tcat.ne.jp'=>'11',
                    'tcn.ne.jp'=>'36',
                    'tcn-catv.ne.jp'=>'13',
                    'tcnet.ne.jp'=>'16',
                    'tctv.ne.jp'=>'13',
                    'thn.ne.jp'=>'22',
                    'ttv.ne.jp'=>'13',
                    'tv-naruto.ne.jp'=>'36',
                    'wainet.ne.jp'=>'45',
                    'ctktv.ne.jp'=>'14',
                    'ict.ne.jp'=>'24',
                    'kitanet.ne.jp'=>'13',
                    'tst.ne.jp'=>'16',
                    'cc22.ne.jp'=>'34',
                    'cty-net.ne.jp'=>'24',
                    '7-dj.com'=>'02',
                    'aba.ne.jp'=>'23',
                    'accsnet.ne.jp'=>'08',
                    'aikis.or.jp'=>'30',
                    'akina.ne.jp'=>'07',
                    'akira.ne.jp'=>'13',
                    'asama.ne.jp'=>'20',
                    'aya.or.jp'=>'11',
                    'comlink.ne.jp'=>'19',
                    'coms.ne.jp'=>'11',
                    'dreams.ne.jp'=>'08',
                    'hokkai.net'=>'01',
                    'infoaomori.ne.jp'=>'02',
                    'janis.or.jp'=>'20',
                    'miyazaki-nw.or.jp'=>'45',
                    'wbs.ne.jp'=>'22',
                    'yanbaru.ne.jp'=>'47',
                    'yin.or.jp'=>'19',
                    'enshu-net.or.jp'=>'22',
                    'valley.ne.jp'=>'20',
                    'biwa.ne.jp'=>'25',
                    'campus.ne.jp'=>'13',
                    'canal.ne.jp'=>'14',
                    'cds.ne.jp'=>'14',
                    'echna.ne.jp'=>'03',
                    'ttcn.ne.jp'=>'13',
                    'me-h.ne.jp'=>'01',
                    'ttnet.ad.jp'=>'13',
                    'cts.ne.jp'=>'13',
                    'metallic.ne.jp'=>'13',
                    'portnet.ne.jp'=>'28',
                    'starcat.ne.jp'=>'23',
                    'ztv.ne.jp'=>'24',
                    'infonia.ne.jp'=>'23',
                    'clio.ne.jp'=>'20',
                    'mct.ne.jp'=>'46',
                    't-net.ne.jp'=>'13',
                    'edit.ne.jp'=>'13',
                    'clovernet.ne.jp'=>'23',
                    'ueda.ne.jp'=>'20',
                    'synapse.ne.jp'=>'46',
                    'cablenet.ne.jp'=>'11',
                    'tctvnet.ne.jp'=>'23',
                    'mine.ne.jp'=>'13',
                    'mis.ne.jp'=>'23',
                    'doshisha.ac.jp'=>'26',
                    'cosmos.ne.jp'=>'47',
                    'hicat.ne.jp'=>'34',
                    'tam.ne.jp'=>'16',
                    'tochigi-ip.ne.jp'=>'09',
                    'takauji.or.jp'=>'09',
                    't-cnet.or.jp'=>'09',
                    'nasu-net.or.jp'=>'09',
                    'nasuinfo.or.jp'=>'09',
                    'csf.ne.jp'=>'40',
                    'oitaweb.ne.jp'=>'44',
                    'safins.ne.jp'=>'07',
                    'cac-net.ne.jp'=>'23',
                    'tama.or.jp'=>'13',
                    'tamatele.ne.jp'=>'33',
                    'sainet.or.jp'=>'11',
                    'intership.ne.jp'=>'12',
                    'rinku.or.jp'=>'27',
                    'jah.ne.jp'=>'13',
                    'miyazaki-catv.ne.jp'=>'45',
                    'internetway.or.jp'=>'27',
                    'webport.ne.jp'=>'01',
                    'hbs.ne.jp'=>'34',
                    'nmt.ne.jp'=>'36',
                    'kix.or.jp'=>'40',
                    'psn.ne.jp'=>'27',
                    'hakodate.or.jp'=>'01',
                    'mitene.or.jp'=>'18',
                    'wide.ne.jp'=>'10',
                    'mni.ne.jp'=>'04',
                    'cypress.ne.jp'=>'30',
                    'ccnet.ne.jp'=>'23',
                    'sky-net.or.jp'=>'34',
                    'ctb.ne.jp'=>'44',
                    'chukai.ne.jp'=>'31',
                    'ictv.ne.jp'=>'11',
                    'eagle-net.ne.jp'=>'17',
                    'ayu.ne.jp'=>'14',
                    'wombat.or.jp'=>'27',
                    '246.ne.jp'=>'13',
                    'nma.ne.jp'=>'23',
                    'wind.ne.jp'=>'10',
                    'gctv.ne.jp'=>'23',
                    'meta.ne.jp'=>'27',
                    'ccv.ne.jp'=>'34',
                    'cjn.or.jp'=>'23',
                    'd-b.ne.jp'=>'44',
                    'hotcn.ne.jp'=>'01',
                    'chichibu.ne.jp'=>'11',
                    'southernx.ne.jp'=>'47',
                    'kagoya.net'=>'26',
                    'net-ibaraki.ne.jp'=>'08',
                    'fureai-ch.ne.jp'=>'34',
                    'col.ne.jp'=>'13',
                    'lancenet.or.jp'=>'09',
                    'big-c.or.jp'=>'18',
                    'naxnet.or.jp'=>'30',
                    'omp.ne.jp'=>'27',
                    'rmc.ne.jp'=>'25',
                    'e-sense.ne.jp'=>'07',
                    'winknet.ne.jp'=>'28',
                    'baynet.ne.jp'=>'13',
                    'catv296.ne.jp'=>'12',
                    'owari.ne.jp'=>'23',
                    'satsuma.ne.jp'=>'46',
                    'amie.or.jp'=>'13',
                    'cats.ne.jp'=>'11',
                    'planet.ne.jp'=>'14',
                    'hidecnet.ne.jp'=>'08',
                    'infosakyu.ne.jp'=>'31',
                    'i-kochi.or.jp'=>'39',
                    'net0726.ne.jp'=>'27',
                    'infosnow.ne.jp'=>'01',
                    'toshima.ne.jp'=>'13',
                    'catvmics.ne.jp'=>'23',
                    'iwami.or.jp'=>'32',
                    'hachigamenet.ne.jp'=>'41',
                    'rosenet.ne.jp'=>'13',
                    'c3-net.ne.jp'=>'14',
                    'ccsnet.ne.jp'=>'35',
                    'mcbnet.ne.jp'=>'37',
                    'tokyo-bay.ne.jp'=>'12',
                    'kinet.or.jp'=>'14',
                    'maxs.ne.jp'=>'20',
                    'cat-v.ne.jp'=>'04',
                    'intio.or.jp'=>'08',
                    'dokidoki.ne.jp'=>'38',
                    'snu.ne.jp'=>'12',
                    'tees.ne.jp'=>'23',
                    'kcb-net.ne.jp'=>'39',
                    'izumo.ne.jp'=>'32',
                    'dcn.ne.jp'=>'20',
                    'tvm.ne.jp'=>'20',
                    'm-net.ne.jp'=>'13',
                    'nct9.ne.jp'=>'15',
                    'kamome.or.jp'=>'14',
                    'ccnw.ne.jp'=>'23',
                    'oninet.ne.jp'=>'33',
                    'koalanet.ne.jp'=>'12',
                    'tnc.ne.jp'=>'22',
                    'icv-net.ne.jp'=>'42',
                    'h555.net'=>'28',
                    'c-able.ne.jp'=>'35',
                    'cypress.ad.jp'=>'30',
                    'cts-net.ne.jp'=>'44',
                    'canet.ne.jp'=>'16',
                    'ncv.ne.jp'=>'01',
                    'cnh.ne.jp'=>'16',
                    'seaple.ne.jp'=>'12',
                    'medias.ne.jp'=>'23',
                    'fruits.ne.jp'=>'19',
                    'tvs12.jp'=>'42',
                    'ccjnet.ne.jp'=>'34',
                    'ucatv.ne.jp'=>'09',
                    'actv.ne.jp'=>'02',
                    'nirai.ne.jp'=>'47',
                    'keihanna.ne.jp'=>'26',
                    'ttn.ne.jp'=>'18',
                    'across.or.jp'=>'22',
                    'yutopia.or.jp'=>'05',
                    'harenet.ne.jp'=>'33',
                    'netyou.jp'=>'14',
                    'watv.ne.jp'=>'09',
                    'icn-tv.ne.jp'=>'35',
                    'mco.ne.jp'=>'47',
                    'sctv.jp'=>'09',
                    'tcbnet.ne.jp'=>'31',
                    'haginet.ne.jp'=>'35',
                    'cnc.jp'=>'12',
                    'warp.or.jp'=>'28',
                    'bc9.ne.jp'=>'09',
                    'tontonme.ne.jp'=>'47',
                    'ccnetmie.ne.jp'=>'24',
                    'speedway.ne.jp'=>'08',
                    'heart-y.ne.jp'=>'28',
                    'orihime.ne.jp'=>'23',
                    'meon.ne.jp'=>'33',
                    'otc.ne.jp'=>'47',
                    'oct-net.jp'=>'44',
                    'bunbun.ne.jp'=>'41',
                    'fctv-net.jp'=>'42',
                    'intsurf.ne.jp'=>'24',
                    'banban.jp'=>'28',
                    'kbctv.ne.jp'=>'36',
                    'tmtv.ne.jp'=>'14',
                    'echigo.ne.jp'=>'15',
                    'kinet-tv.ne.jp'=>'26',
                    'amigo.ne.jp'=>'24',
                    'amigo2.ne.jp'=>'24',
                    'inforyoma.or.jp'=>'39',
                    'ii-okinawa.ne.jp'=>'47',
                    'hearts.ne.jp'=>'38',
                    'inet-shibata.or.jp'=>'15',
                    'icnet.ne.jp'=>'12',
                    'octv.ne.jp'=>'01',
                    'kyoto-inetbb.jp'=>'26',
                    'matsumoto.ne.jp'=>'20',
                    'icv.ne.jp'=>'32',
                    'kibi.ne.jp'=>'33',
                    'kvision.ne.jp'=>'35',
                    'sensyu.ne.jp'=>'27',
                    'tvkumagaya.ne.jp'=>'11',
                    'people-i.ne.jp'=>'41',
                    'tvt.ne.jp'=>'33',
                    'ktv.ne.jp'=>'10',
                    'mable.ne.jp'=>'32',
                    'kcv.ne.jp'=>'33',
                    'ibara.ne.jp'=>'33',
                    'ictweb.ne.jp'=>'47',
                    'bbbn.jp'=>'34',
                    'yabu-catv.or.jp'=>'28',
                    'octp-net.ne.jp'=>'42',
                    'netfour.ne.jp'=>'41',
                    'ybnet.jp'=>'05',
                    'asagaotv.ne.jp'=>'17',
                    'ictnet.ne.jp'=>'03',
                    'hbb.jp'=>'01',
                    'ipa.go.jp'=>'13',
                    'affrc.go.jp'=>'08',
                    'hot-cha.tv'=>'35',
                    'lcnet.jp'=>'19',
                    'knei.jp'=>'16',
                    'rcn.ne.jp'=>'18',
                    'kcnet.ne.jp'=>'19',
                    'kct.ad.jp'=>'33',
                    'kokufu.net'=>'21',
                    'hottv.ne.jp'=>'25',
                    'waiwai-net.ne.jp'=>'03',
                    'rcctv.jp'=>'08',
                    'mm22.jp'=>'22',
                    'ttmy.ne.jp'=>'14',
                    'marukotv.jp'=>'20',
                    'joetsu.ne.jp'=>'15',
                    'hokkaido.jp'=>'01',
                    'aomori.jp'=>'02',
                    'iwate.jp'=>'03',
                    'miyagi.jp'=>'04',
                    'akita.jp'=>'05',
                    'yamagata.jp'=>'06',
                    'fukushima.jp'=>'07',
                    'ibaraki.jp'=>'08',
                    'tochigi.jp'=>'09',
                    'gunma.jp'=>'10',
                    'saitama.jp'=>'11',
                    'chiba.jp'=>'12',
                    'tokyo.jp'=>'13',
                    'kanagawa.jp'=>'14',
                    'niigata.jp'=>'15',
                    'toyama.jp'=>'16',
                    'ishikawa.jp'=>'17',
                    'fukui.jp'=>'18',
                    'yamanashi.jp'=>'19',
                    'nagano.jp'=>'20',
                    'gifu.jp'=>'21',
                    'shizuoka.jp'=>'22',
                    'aichi.jp'=>'23',
                    'mie.jp'=>'24',
                    'shiga.jp'=>'25',
                    'kyoto.jp'=>'26',
                    'osaka.jp'=>'27',
                    'hyogo.jp'=>'28',
                    'nara.jp'=>'29',
                    'wakayama.jp'=>'30',
                    'tottori.jp'=>'31',
                    'shimane.jp'=>'32',
                    'okayama.jp'=>'33',
                    'hiroshima.jp'=>'34',
                    'yamaguchi.jp'=>'35',
                    'tokushima.jp'=>'36',
                    'kagawa.jp'=>'37',
                    'ehime.jp'=>'38',
                    'kochi.jp'=>'39',
                    'fukuoka.jp'=>'40',
                    'saga.jp'=>'41',
                    'nagasaki.jp'=>'42',
                    'kumamoto.jp'=>'43',
                    'oita.jp'=>'44',
                    'miyazaki.jp'=>'45',
                    'kagoshima.jp'=>'46',
                    'okinawa.jp'=>'47',
                    'sapporo.jp'=>'01',
                    'sendai.jp'=>'04',
                    'yokohama.jp'=>'14',
                    'kawasaki.jp'=>'14',
                    'nagoya.jp'=>'23',
                    'kobe.jp'=>'28',
                    'kitakyushu.jp'=>'40'
                                        );

  public static $searchEngines = array(
                    'yahoo' => array('?p=', '?w=', '?va=', '&p=', '&w=', '&va='),
                    'google' => array('?q=', '?as_epq=', '?as_q=', '&q=', '&as_epq=', '&as_q='),
                    'msn' => array('?q=', '&q='),
                    'bing' => array('?q=', '&q='),
                    'goo' => array('?mt=', '?queryword=', '&mt=', '&queryword='),
                    'nifty' => array('?text=', '&text=', '?q=', '&q='),
                    'biglobe' => array('?q=', '&q='),
                    'infoseek' => array('?qt=', '&qt='),
                    'rakuten' => array('?qt=', '&qt='),
                    'excite' => array('?search=', '&search='),
                    'livedoor' => array('?q=', '&q='),
                    'aol' => array('?query=', '?query_contain=', '&query=', '&query_contain='),
                    'jword' => array('?name=', '&name='),
                    'fresheye' => array('?kw=', '&kw='),
                    'alltheweb' => array('?q=', '&q='),
                    'hatena' => array('?word=', '&word='),
                    'marsflag' => array('?phrase=', '&phrase='),
                    'baidu' => array('?wd=', '&wd='),
                    'gigablast' => array('?q=', '&q='),
                    'sagool' => array('?q=', '&q='),
                    'technorati' => array('search/'),
                    'ceek' => array('?q=', '&q='),
                    'luna' => array('?q=', '&q='),
                    'default' => array(
                         '?q=',
                         '?search=',
                         '?query=',
                         '?word=',
                         '?words=',
                         '?keyword=',
                         '?keywords=',
                         '&q=',
                         '&search=',
                         '&query=',
                         '&word=',
                         '&words=',
                         '&keyword=',
                         '&keywords='
                    )
  );

  public static $searchEnginesContainMail = array(
                    'yahoo',
                    'google',
                    'msn',
                    'goo',
                    'infoseek'
  );
  
  public static $osLists = array(
                    'windowsnt5.1' => 'WindowsXP',
                    'windowsnt5.2' => 'WindowsXP',
                    'windowsxp' => 'WindowsXP',
                    'arachmo' => 'WindowsXP',
                    'iphone;' => 'iPhone',
                    'windowsnt6.0' => 'WindowsVista',
                    'windowsnt5.0' => 'Windows2000',
                    'windows2000' => 'Windows2000',
                    'windows98' => 'Windows98',
                    'win98' => 'Windows98',
                    'macosx' => 'MacOSX',
                    'linux' => 'Linux',
                    'konqueror' => 'Linux',
                    'macos9' => 'MacOS9',
                    'mac_powerpc' => 'MacOS9',
                    'macintosh' => 'Macintosh',
                    'sunos' => 'SunOS',
                    'freebsd' => 'FreeBSD',
                    'netbsd' => 'NetBSD',
                    'sleipnir' => 'Windows2000 or XP or Vista (Sleipnir)',
                    'windows95' => 'Windows95',
                    'win95' => 'Windows95',
                    'windowsce' => 'WindowsCE',
                    'windowsme' => 'WindowsME',
                    'win9x4.90' => 'WindowsME',
                    'win9x' => 'Windows9x',
                    'windowsnt3' => 'WindowsNT3.x',
                    'windowsnt4' => 'WindowsNT4.x',
                    'winnt' => 'WindowsNT4.x',
                    'windowsnt' => 'WindowsNT',
                    'w3m' => 'Unix',
                    'docomo' => 'Docomo',
                    'portalmmm' => 'Docomo',
                    'ibisbrowser' => 'Docomo',
                    'foma;' => 'Docomo',
                    'up.browser' => 'AU',
                    'kddi-' => 'AU',
                    'kc31' => 'AU',
                    ';ca31' => 'AU',
                    ';sa33' => 'AU',
                    'j-phone' => 'Softbank',
                    'vodafone' => 'Softbank',
                    'softbank' => 'Softbank',
                    'mot-' => 'Softbank',
                    'kyocera/ah-k3001v' => 'Air H"',
                    'pda;' => 'Zaurus',
                    'os/2;u;warp' => 'OS2 Warp',
                    'psp' => 'PlayStation',
                    'playstationportable' => 'PlayStation',
                    'playstation' => 'PlayStation',
                    'beos' => 'BeOS',
                    'pockey-gethtml' => 'Pockey-GetHTML',
                    'palmos' => 'PalmOS',
                    'nf32ppc3ar' => 'PDA',
                    'willcom' => 'WILLCOM',
                    'amigaos' => 'AmigaOS',
                    'wii;' => 'Wii'
  );

  public static $browserLists = array(
                    'msie' => 'Internet Exploer',
                    'firefox' => 'Firefox',
                    'chrome' => 'Google Chrome',
                    'opera' => 'Opera',
                    'safari' => 'Safari',
                    'version' => 'Safari',
                    'konqueror' => 'Konqueror',
                    'netscape' => 'NetScape',
                    'camino' => 'Camino',
                    'sleipnir' => 'Sleipnir',
                    'iceweasel' => 'Iceweasel',
                    'thunderbrowse' => 'ThunderBrowse',
                    'icab' => 'iCab',
                    'w3m' => 'w3m',
                    'sharppdabrowser' => 'SHARP PDA Browser',
                    'ibisbrowser' => 'ibisBrowser',
                    'pda;' => 'NetFront',
                    'netfront' => 'NetFront',
                    'warp' => 'OS2 Warp',
                    'psp' => 'PlayStation',
                    'playstationportable' => 'PlayStation',
                    'playstation' => 'PlayStation',
                    'netpositive' => 'NetPositive',
                    'arachmo' => 'Arachmo',
                    'pockey-gethtml' => 'Pockey-GetHTML',
                    'ibrowse' => 'IBrowse',
                    'epiphany' => 'Epiphany',
                    'seamonkey' => 'SeaMonkey',
                    'jigbrowser' => 'jig browser'
  );

  public static $osImageLists = array(
                    'WindowsXP' => 'winxp.png',
                    'WindowsVista' => 'winvista.png',
                    'Windows2000' => 'win.png',
                    'Windows98' => 'win.png',
                    'iPhone' => 'macosx.png',
                    'MacOSX' => 'macosx.png',
                    'Linux' => 'linux.png',
                    'MacOS9' => 'macos9.png',
                    'Macintosh' => 'macosx.png',
                    'SunOS' => 'solaris.png',
                    'FreeBSD' => 'freebsd.png',
                    'NetBSD' => 'netbsd.png',
                    'Windows2000 or XP or Vista (Sleipnir)' => 'winxp.png',
                    'Windows95' => 'win.png',
                    'WindowsCE' => 'win.png',
                    'WindowsME' => 'win.png',
                    'Windows9x' => 'win.png',
                    'WindowsNT3.x' => 'win.png',
                    'WindowsNT4.x' => 'win.png',
                    'WindowsNT' => 'win.png',
                    'Docomo' => 'docomo.png',
                    'AU' => 'au.png',
                    'Softbank' => 'softbank.png'
  );

  public static $browserImageLists = array(
                    'Internet Exploer' => 'ie.png',
                    'Firefox' => 'firefox.png',
                    'Google Chrome' => 'chrome.png',
                    'iPhone' => 'iphone.png',
                    'Safari' => 'safari.png',
                    'Opera' => 'opera.png',
                    'Konqueror' => 'konqueror.png',
                    'NetScape' => 'netscape.png',
                    'Camino' => 'camino.png',
                    'Sleipnir' => 'sleipnir.png',
                    'Docomo' => 'docomo.png',
                    'AU' => 'au.png',
                    'Softbank' => 'softbank.png',
                    'iCab' => 'icab.png',
                    'Mozilla' => 'mozilla.png'
  );

  public static $hostImageLists = array(
                    'yahoo' => 'yahoo.png',
                    'google' => 'google.png',
                    'msn' => 'msn.png',
                    'goo' => 'goo.png',
                    'bing' => 'bing.png',
                    'nifty' => 'nifty.png',
                    'biglobe' => 'biglobe.png',
                    'infoseek' => 'infoseek.png',
                    'excite' => 'excite.png',
                    'livedoor' => 'livedoor.png',
                    'aol' => 'aol.png',
                    'fresheye' => 'fresheye.png',
                    'hatena' => 'hatena.png',
                    'web-artisan' => 'WArtisan.png',
                    'research-artisan' => 'RArtisan.png'
  );

  public static $crawlerLists = array(
                    'googlebot' => 'Google Crawler',
                    'mediapartners-google' => 'Google Crawler(Adsense)',
                    'feedfetcher-google;' => 'Google Crawler(Reader)',
                    'yahoo!slurp/' => 'Yahoo Crawler',
                    'y!j-bri/' => 'Yahoo Crawler',
                    'yahoo!deslurp;' => 'Yahoo Crawler',
                    'yeti/1.0' => 'Naver Crawler',
                    'naverbot/1.0' => 'Naver Crawler',
                    'baiduspider' => '百度 Crawler',
                    'msnbot' => 'MSN Crawler',
                    'amznkassocbot' => 'Amazon Crawler',
                    'infoseek' => 'InfoSeek Crawler',
                    'hatenaantenna' => 'Hatena Antenna',
                    'metadatafetcher/' => 'FeedHub Crawler',
                    'mj12bot/' => 'MJ12bot',
                    'twiceler-' => 'Twiceler Robot',
                    'crawler@alexa.com' => 'Alexa Crawler',
                    'ia_archiver' => 'Internet Archive Contacts',
                    'libwww-perl/' => 'Crawler',
                    'mozilla/4.0(compatible;)' => 'Crawler',
                    'mozilla/3.01(compatible;)' => 'Crawler',
                    'spider' => 'Crawler',
                    'crawler' => 'Crawler',
                    'bot' => 'Robot'
  );

}
?>
