#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bhv_dango.h"
#include "opuci_move.h"
#include "opuci_search_ball.h"
#include "opuci_kick.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_Dango::execute( rcsc::PlayerAgent * agent )
{
  rcsc::dlog.addText( rcsc::Logger::TEAM,
		      "%s:%d:Bhv_Dango"
		      ,__FILE__, __LINE__ );

  const rcsc::WorldModel & wm = agent->world();

  if( ! wm.ball().posValid() )
    {
      Opuci_SearchBall().execute( agent );
    }
  else if( wm.self().pos().dist( wm.ball().pos() ) < wm.self().playerType().kickableArea() )
    {
      rcsc::Vector2D target_point( rcsc::ServerParam::i().pitchHalfLength(), 0.0 );
      Opuci_Kick( target_point ).execute( agent );
    }
  else
    {
      Opuci_Move( wm.ball().pos() ).execute( agent );
      agent->doTurnNeck( - wm.self().neck() );
    }

  return true;
}
