#ifndef BHV_DEFENSE_H
#define BHV_DEFENSE_H

#include <rcsc/player/soccer_action.h>
#include <rcsc/player/world_model.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/vector_2d.h>

class Bhv_defense
    : public rcsc::SoccerBehavior {
 private:
      const rcsc::Vector2D M_home_pos;

 public:
      Bhv_defense()
      { }

      bool execute( rcsc::PlayerAgent * agent );
      double getDashPower( const rcsc::PlayerAgent * agent,
			   const rcsc::Vector2D & target_point );
      std::vector<int> oppForward( rcsc::PlayerAgent * agent );
      std::vector<int> oppSemiForward( rcsc::PlayerAgent * agent );
      rcsc::Vector2D defendOpponent( rcsc::PlayerAgent * agent,
				     const int opp_unum,
				     const rcsc::Vector2D goal_pos,
				     const rcsc::Vector2D mark_pos,
				     int * reach_cycle,
				     const int cost_cycle = 10 );
      bool oppMarked( rcsc::PlayerAgent * agent, 
		     const int opp_unum );
      double oppFwLineX( rcsc::PlayerAgent * agent );
      double oppSemiFwLineX( rcsc::PlayerAgent * agent );
      rcsc::PlayerPtrCont oppOffenseCluster( rcsc::PlayerAgent * agent );
      rcsc::Vector2D offsideTrap( rcsc::PlayerAgent * agent,
				  rcsc::Vector2D default_pos );
      bool defenseMessage( rcsc::PlayerAgent * agent );
      bool defenseAttention( rcsc::PlayerAgent * agent );
      rcsc::Vector2D ballInertiaPoint( rcsc::PlayerAgent * agent );
      bool prepareTackle( rcsc::PlayerAgent * agent );
      bool ourDefenseLine( rcsc::PlayerAgent * agent, std::vector< rcsc::PlayerObject* > & def_line );
      bool surroundOppNum( rcsc::PlayerAgent * agent, std::vector< rcsc::PlayerObject* > & def_line, std::vector< int > & opp_num );
};

#endif
