#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bhv_formation1.h"
#include "opuci_move.h"
#include "opuci_search_ball.h"
#include "opuci_kick.h"
#include "opuci_neck.h"
#include "opuci_intercept_cycle.h"
#include "strategy.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/common/say_message_parser.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/angle_deg.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_Formation1::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d:Bhv_Formation1"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    static bool is_memorized = false;
    static rcsc::Vector2D r_pos;

    int self_cycle = Opuci_InterceptCycle().selfCycle( agent );
    int mate_cycle = Opuci_InterceptCycle().mateCycle( agent );
    int nearest_mate = Opuci_InterceptCycle().nearestMate( agent );

    if( ! is_memorized )
    {
//        r_pos = wm.self().pos();
        r_pos = Strategy::i().getBeforeKickOffPos( wm.self().unum() );
        is_memorized = true;
    }

    if( wm.ball().posCount() > 5 )
    {
        Opuci_SearchBall().execute( agent );
    }
    else if( wm.self().pos().dist( wm.ball().pos() ) <= wm.self().playerType().kickableArea() )
    {
        const rcsc::Vector2D goal_pos = rcsc::Vector2D( rcsc::ServerParam::i().pitchHalfLength(), 0.0 );
        Opuci_Kick( goal_pos ).execute( agent );
    }
    else
    {
        if( self_cycle <= mate_cycle )
	{
            const double dash_power = rcsc::ServerParam::i().maxPower();
            Opuci_Move( wm.ball().pos(), dash_power ).execute( agent );
	}
        else
	{
            rcsc::Vector2D offset( 0, 0 );
            if( wm.ball().pos().y > 19.0 )
                offset.y = wm.ball().pos().y - 19;
            else if( wm.ball().pos().y < -19 )
                offset.y = wm.ball().pos().y + 19;

//            rcsc::Vector2D home_pos = wm.ball().pos() + r_pos - offset;
            const rcsc::Vector2D home_pos = Strategy::i().getPosition( wm.self().unum() );
            rcsc::Vector2D target_pos = home_pos;
            if( target_pos.x < wm.ball().pos().x )
            {
                target_pos.x = wm.ball().pos().x;
            }
            if( target_pos.dist( wm.ball().pos() ) > 40 )
            {
                rcsc::Circle2D ball_circle( wm.ball().pos(), 40 );
                rcsc::Line2D y_line( target_pos, 90 );
                rcsc::Vector2D sol1, sol2;
                int sol_num = ball_circle.intersection( y_line, & sol1, & sol2 );
                if( sol_num == 1 )
                {
                    target_pos.y = sol1.y;
                }
                else if( sol_num == 2 )
                {
                    if( sol1.dist( target_pos ) < sol2.dist( target_pos ) )
                    {
                        target_pos.y = sol1.y;
                    }
                    else
                    {
                        target_pos.y = sol2.y;
                    }
                }
            }
            if( target_pos.x > 50 )
            {
                target_pos.x = 50;
            }
            if( target_pos.x < -50 )
            {
                target_pos.x = -50;
            }
            if( target_pos.y > 31 )
            {
                target_pos.y = 31;
            }
            if( target_pos.y < -31 )
            {
                target_pos.y = -31;
            }            
/*
            const rcsc::Vector2D selfToHpos = home_pos - wm.self().pos();
            if( fabs( selfToHpos.th().degree() - wm.self().body().degree() ) < 30.0 
                && selfToHpos.r() > 20.0 )
	    {
                home_pos.rotate( - selfToHpos.th() + wm.self().body() );
                agent->debugClient().addMessage("posModified");
	    }
*/
            double dash_power = rcsc::ServerParam::i().maxPower() * 0.5;
            if( wm.self().pos().x > wm.offsideLineX() )
                dash_power = rcsc::ServerParam::i().maxPower() * 0.75;
            if( !Opuci_Move( target_pos, dash_power ).execute( agent ) )
            {
                //reached
                rcsc::Vector2D turn_pos = wm.ball().pos() + wm.ball().vel();
                rcsc::Vector2D dif = turn_pos - wm.self().pos() - wm.self().vel();
                agent->doTurn( dif.th() - wm.self().body() );
            }
	}

        Opuci_Neck().execute( agent );
    }

    if( self_cycle > mate_cycle )
    {
        if( wm.teammate( nearest_mate ) )
	{
            agent->doAttentionto( wm.teammate( nearest_mate )->side(),
                                  wm.teammate( nearest_mate )->unum() );
	}
    }
    else if( wm.ball().rposCount() < 1 )
    {
        rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
        rcsc::Vector2D next_ball_vel = wm.ball().vel() * rcsc::ServerParam::i().ballDecay();
        agent->addSayMessage( new rcsc::BallMessage( next_ball_pos, 
                                                     next_ball_vel ) );
    }
    agent->debugClient().addMessage("posCount:%d",wm.ball().posCount());

    return true;
}

