#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bhv_jiro_defense.h"

#include "opuci_move.h"
#include "opuci_chase_ball.h"
#include "bhv_basic_tackle.h"
#include "opuci_neck.h"
#include "opuci_intention_dash.h"
#include "strategy.h"
#include "bhv_danger_area_tackle.h"

#include <rcsc/action/body_turn_to_point.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/geom/line_2d.h>
#include <rcsc/geom/circle_2d.h>
#include <rcsc/geom/angle_deg.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_jiroDefense::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: BhvJiroDefense"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & SP = rcsc::ServerParam::i();

    //ball lost
    if( ! wm.ball().state().ghost_count_ > 0 )
    {
        agent->doTurn( 180.0 );
        rcsc::Neck_TurnToBallOrScan().execute( agent );
    }

    const rcsc::Rect2D our_penalty( rcsc::Vector2D( -SP.pitchHalfLength(),
                                                    -SP.penaltyAreaHalfWidth() + 1.0 ),
                                    rcsc::Size2D( SP.penaltyAreaLength() - 1.0,
                                                  SP.penaltyAreaWidth() - 2.0 ) );
    // tackle
    if( our_penalty.contains( wm.ball().pos() )
        && !wm.existKickableTeammate()
        && Bhv_DangerAreaTackle( 0.5 ).execute( agent ) )
    {
        return true;
    }
    else if ( Bhv_BasicTackle( 0.9, 80.0 ).execute( agent ) )
    {
        return true;
    }
    else if( wm.ball().pos().x < -35.0 && wm.ball().distFromSelf() < 3.0 )
    {
        if( Bhv_BasicTackle( 0.5, 80.0 ).execute( agent ) )
        {
            return true;
        }
    }
    else if( wm.ball().pos().x < -32.0 
             && ! wm.existKickableTeammate() 
             && std::abs( wm.ball().pos().y - wm.self().pos().y ) < 2.0 
             && wm.ball().distFromSelf() < 6.0 )
    {
        if( Bhv_BasicTackle( 0.5, 80.0 ).execute( agent ) )
        {
            return true;
        }
    }
    else if( Bhv_defense().prepareTackle( agent ) )
    {
        return true;
    }

    // check ball owner
    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();
    int fastest = 0;
    if( wm.interceptTable()->fastestOpponent() )
    {
        fastest = wm.interceptTable()->fastestOpponent()->unum();
    }
    const rcsc::Vector2D base_pos = Bhv_defense().ballInertiaPoint( agent );

    if ( ! wm.existKickableTeammate()
         && self_min < mate_min
         && self_min <= opp_min
         && wm.ball().inertiaPoint( self_min ).absX() < SP.pitchHalfLength() + 5.0
         && wm.ball().inertiaPoint( self_min ).absY() < SP.pitchHalfWidth() + 5.0 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: intercept"
                            ,__FILE__, __LINE__ );
        rcsc::Body_Intercept().execute( agent );
        //Opuci_ChaseBall().execute( agent );
        rcsc::Neck_TurnToBallOrScan().execute( agent );
        return true;
    }

    // go to home position
    rcsc::Vector2D mark_home_pos = M_home_pos;
    double dist_thr = M_home_pos.dist( wm.self().pos() ) * 0.3;
    double dash_power = Bhv_defense().getDashPower( agent, M_home_pos );
    if ( dist_thr < 0.5 ) dist_thr = 0.5;

    int opp_unum = -2;
    rcsc::Vector2D opp_pos = M_home_pos;
    std::vector<int> opp_fw = Bhv_defense().oppForward( agent );
    const double opp_fw_1st_x = Bhv_defense().oppFwLineX( agent );
    double opp_fw_2nd_x = 0.0;
    for( std::vector<int>::iterator it = opp_fw.begin();
         it != opp_fw.end();
         ++it )
    {
        if( wm.opponent( (*it) )
            && wm.opponent( (*it) )->pos().x > opp_fw_1st_x
            && wm.opponent( (*it) )->pos().x < opp_fw_2nd_x )
        {
            opp_fw_2nd_x = wm.opponent( (*it) )->pos().x;
        }
    }
    double opp_fw_line_x = std::min( std::min( opp_fw_1st_x, base_pos.x ), 0.0 ) - 3.0;
    if( opp_fw_2nd_x - opp_fw_1st_x > 10.0 )
    {
        opp_fw_line_x = std::min( std::min( opp_fw_2nd_x, base_pos.x ), 0.0 ) - 3.0;
    }
    rcsc::Vector2D home_pos( opp_fw_line_x, M_home_pos.y );
    bool no_mark_opp = false;
    rcsc::Vector2D our_goal = SP.ourTeamGoalPos();
    if( base_pos.absY() > 3.0 )
    {
        our_goal = rcsc::Vector2D( -52.5, 6.0 * ( base_pos.y / base_pos.absY() ) );
    }

    //自分が味方よりボールに近い場合，ボールに最も近い敵をマーク
    bool self_nearest_to_ball = true;
    for( int i = 2; i <= 5; i++ )
    {
        if( wm.opponent( fastest )
            && wm.teammate( i )
            && wm.self().unum() != i
            && wm.teammate( i )->pos().dist( wm.opponent( fastest )->pos() ) 
            < wm.self().pos().dist( wm.opponent( fastest )->pos() ) )
        {
            self_nearest_to_ball = false;
            //自分と味方の敵への距離があまり変わらない&敵の方が味方よりゴールに近い場合，ボールに最も近い敵をマーク
            if( wm.self().pos().dist( wm.opponent( fastest )->pos() )
                - wm.teammate( i )->pos().dist( wm.opponent( fastest )->pos() ) < 5.0
                && wm.opponent( fastest )->pos().dist( SP.ourTeamGoalPos() ) <
                wm.teammate( i )->pos().dist( SP.ourTeamGoalPos() )  )
            {
                self_nearest_to_ball = true;
            }
            break;
        }
    }
    if( self_nearest_to_ball )
    {
        for( std::vector<int>::iterator it = opp_fw.begin();
             it != opp_fw.end();
             it++ )
        {
            if( fastest == (*it) )
            {
                opp_unum = fastest;
                break;
            }
        }
    }
    else
    {    
        //敵フォワードが存在しない場合はマークしない
        if( opp_fw.empty() )
        {
            no_mark_opp = true;
        }
        else
        {
            rcsc::Vector2D opp_pos( 52.5, 0.0 );
            for( std::vector<int>::iterator it = opp_fw.begin();
                 it != opp_fw.end();
                 ++it )
            {
                if( wm.opponent( (*it ) )
                    && wm.opponent( (*it) )->pos().dist( wm.self().pos() ) < opp_pos.dist( wm.self().pos() ) )

                {
                    opp_pos = wm.opponent( (*it) )->pos();
                    opp_unum = (*it);
                }
            }
            //自分に最も近い敵に，自分が最も近い場合，その敵をマーク
            for( int i = 2; i <= 5; i++ )
            {
                if( wm.teammate( i )
                    && i != wm.self().unum() )
                {
                    if( wm.self().pos().dist( opp_pos ) > wm.teammate( i )->pos().dist( opp_pos ) )
                        //&& our_goal.dist( wm.teammate( i )->pos() ) < our_goal.dist( opp_pos ) )
                    {
                        no_mark_opp = true;
                        opp_unum = 0;
                        break;
                    }
                }
            }
            //マークするべき敵がいない場合
            if( no_mark_opp )
            {
                double centroid_y = 0.0;
                for( std::vector<int>::iterator it = opp_fw.begin();
                     it != opp_fw.end();
                     ++it )
                {
                    if( wm.opponent( (*it) ) )
                    {
                        centroid_y += wm.opponent( (*it) )->pos().y;
                    }
                }
                centroid_y /= opp_fw.size();
                if( wm.self().unum() == 2
                    && wm.opponent( opp_fw.back() )
                    && base_pos.y < M_home_pos.y )
                {
                    home_pos.y = centroid_y * 0.7 + wm.opponent( opp_fw.back() )->pos().y * 0.3;
                }
                else if( wm.self().unum() == 3
                         && wm.opponent( opp_fw.front() )
                         && base_pos.y > M_home_pos.y ) 
                {
                    home_pos.y = centroid_y * 0.7 + wm.opponent( opp_fw.front() )->pos().y * 0.3;
                }
            }
        }
    }

    if( wm.opponent( opp_unum ) )
    {
        opp_pos = wm.opponent( opp_unum )->pos();
        rcsc::Vector2D second_opp_pos = base_pos;
        const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
        for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
             it != opps.end();
             ++it )
        {
            if( (*it)->unum() != opp_unum
                && opp_pos.dist( (*it)->pos() ) < opp_pos.dist( second_opp_pos ) )
            {
                second_opp_pos = (*it)->pos();
            }
        }
        int ball_cycle = (int)rcsc::calc_length_geom_series( SP.ballSpeedMax(), 
                                                             second_opp_pos.dist( opp_pos ),
                                                             SP.ballDecay() );
        const rcsc::Line2D opp_line( opp_pos, SP.ourTeamGoalPos() );
        if( ball_cycle < 0
            || ball_cycle > 15 )
        {
            home_pos.x = opp_fw_line_x;
            home_pos.y = opp_line.getY( opp_fw_line_x );
            if( opp_pos.absY() < 10.0 )
            {
                home_pos.y = opp_pos.y;
            }
        }
        else
        {
            rcsc::Vector2D mark_pos = opp_pos;
            const rcsc::AngleDeg angle = ( opp_pos - our_goal ).th();
            if( ball_cycle < 3 )
            {
                mark_pos.x = opp_fw_line_x;
                mark_pos.y = opp_line.getY( opp_fw_line_x );
                if( opp_pos.absY() < 10.0 )
                {
                    mark_pos.y = opp_pos.y;
                }
                agent->debugClient().addMessage("ballNearOpp");
            }
            else
            {
                const double dash_r = wm.self().playerTypePtr()->dashDistanceTable().at( ball_cycle - 3 );
                mark_pos.x = opp_fw_line_x;
                if( wm.self().unum() == 2 )
                {
                    if( opp_line.getY( opp_fw_line_x ) - dash_r > base_pos.y )
                    {
                        mark_pos.y = opp_line.getY( opp_fw_line_x ) - dash_r;
                    }
                    else if( opp_pos.y < base_pos.y )
                    {
                        mark_pos.y = opp_pos.y;
                    }
                    else
                    {
                        mark_pos.y = base_pos.y;
                    }
                }
                else if( wm.self().unum() == 3 )
                {
                    if( opp_line.getY( opp_fw_line_x ) + dash_r < base_pos.y )
                    {
                        mark_pos.y = opp_line.getY( opp_fw_line_x ) + dash_r;
                    }
                    else if( opp_pos.y > base_pos.y )
                    {
                        mark_pos.y = opp_pos.y;
                    }
                    else
                    {
                        mark_pos.y = base_pos.y;
                    }
                }
                else
                {
                    mark_pos.y = opp_line.getY( opp_fw_line_x );
                }
            }
            home_pos = mark_pos;
        }
        agent->debugClient().addMessage( "Mark:%d", opp_unum );
    }
    else if( no_mark_opp )
    {
        agent->debugClient().addMessage("NoMarkOpp");
    }
    else
    {
        if( ! Opuci_Move( home_pos, dash_power, dist_thr ).execute( agent ) )
        {
            agent->doTurn( 180.0 );
        }
        rcsc::Neck_TurnToBallOrScan().execute( agent );
        agent->debugClient().addMessage("OppLost");
        return true;
    }

    //shoot situation
    if( rcsc::Segment2D( wm.ball().pos(), wm.ball().inertiaFinalPoint() ).existIntersection( 
            rcsc::Segment2D( rcsc::Vector2D( -52.5, -9.0 ), rcsc::Vector2D( -52.5, 9.0 ) ) )
        && wm.self().pos().x < wm.ball().pos().x
        && base_pos.x < -52.0 )
    {
        agent->debugClient().addMessage("shootM");
        if( wm.ball().inertiaPoint( self_min ).x > -52.0 )
        {
            rcsc::Body_Intercept().execute( agent );
        }
        else
        {
            rcsc::Vector2D move_point = rcsc::Line2D( wm.ball().pos(), wm.ball().inertiaFinalPoint() ).intersection(
                rcsc::Line2D( rcsc::Vector2D( -52.5, -9.0 ), rcsc::Vector2D( -52.5, 9.0 ) ) );
            int cycle = 1;
            for( int i = 1; i < 15; i++ )
            {
                if( wm.ball().inertiaPoint( i ).dist( wm.self().pos() ) < move_point.dist( wm.self().pos() ) )
                {
                    move_point = wm.ball().inertiaPoint( i );
                    cycle = i;
                }
                else
                {
                    break;
                }
            }
            Opuci_Move( move_point, SP.maxDashPower() ).execute( agent );
            rcsc::Neck_TurnToBallOrScan().execute( agent );
            return true;
        }
    }

    bool danger_mode = false;
    if( base_pos.x < -30.0
        && Bhv_defense().oppFwLineX( agent ) < -30.0 )
    {
        danger_mode = true;
    }
    //danger area situation
    if( danger_mode )
    {
        agent->debugClient().addMessage("dangerM");
        const rcsc::Line2D opp_line( base_pos, SP.ourTeamGoalPos() );
        //ボールに近い場合，ボールに近づく
        if( wm.self().pos().dist( base_pos ) < 3.0
            && opp_line.dist( wm.self().pos() ) < 1.0 )
        {
            mark_home_pos = base_pos;
            dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
            dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
            if ( dist_thr < 0.5 ) dist_thr = 0.5;
            agent->setIntention( new Opuci_IntentionDash( mark_home_pos, 3, dash_power, dist_thr ) );
        }
        //自分が味方よりもボールに近い場合，ボールに近づく
        else if( self_nearest_to_ball )
        {
            agent->debugClient().addMessage("chaseOpp");
            if( opp_line.dist( wm.self().pos() ) < 1.0 )
            {
                mark_home_pos = opp_pos;
            }
            else
            {
                mark_home_pos = Bhv_defense().defendOpponent( agent, fastest, SP.ourTeamGoalPos(), opp_pos, NULL, 15 );
                dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
                dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
                if ( dist_thr < 0.5 ) dist_thr = 0.5;
                agent->setIntention( new Opuci_IntentionDash( mark_home_pos, 2, dash_power, dist_thr ) );
            }
        }
        else
        {
            mark_home_pos.x = opp_fw_1st_x;
            if( base_pos.y < -10.0 )
            {
                if( wm.self().unum() == 2 )
                {
                    mark_home_pos.y = -6.0;
                }
                else if( wm.self().unum() == 3 )
                {
                    mark_home_pos.y = 0.0;
                }
                else
                {
                    mark_home_pos.y = -2.0;
                }
            }
            else if( base_pos.y > 10.0 )
            {
                if( wm.self().unum() == 2 )
                {
                    mark_home_pos.y = 0.0;
                }
                else if( wm.self().unum() == 3 )
                {
                    mark_home_pos.y = 6.0;
                }
                else
                {
                    mark_home_pos.y = 2.0;
                }
            }
            else
            {
                if( wm.opponent( opp_unum ) )
                {
                    if( wm.self().unum() == 2 )
                    {
                        rcsc::Line2D opp_line( opp_pos, rcsc::Vector2D( -52.5, -6.0 ) );
                        mark_home_pos.y = opp_line.getY( opp_fw_1st_x );
                    }
                    else if( wm.self().unum() == 3 )
                    {
                        rcsc::Line2D opp_line( opp_pos, rcsc::Vector2D( -52.5, 6.0 ) );
                        mark_home_pos.y = opp_line.getY( opp_fw_1st_x );
                    }
                    else
                    {
                        mark_home_pos.y = 0.0;
                    }
                }
                else
                {
                    if( wm.self().unum() == 2 )
                    {
                        mark_home_pos.y = -3.0;
                    }
                    else if( wm.self().unum() == 3 )
                    {
                        mark_home_pos.y = 3.0;
                    }
                    else
                    {
                        mark_home_pos.y = 0.0;
                    }
                }
            }
            //マークする敵がいる場合，その敵に近づく
            /*
            if( wm.opponent( opp_unum ) )
            {
                rcsc::Line2D opp_line( opp_pos, SP.ourTeamGoalPos() );
                if( wm.self().unum() == 2 )
                {
                    opp_line = rcsc::Line2D( opp_pos, rcsc::Vector2D( -SP.pitchHalfLength(), -6.0 ) );
                }
                else if( wm.self().unum() == 3 )
                {
                    opp_line = rcsc::Line2D( opp_pos, rcsc::Vector2D( -SP.pitchHalfLength(), 6.0 ) );
                }
                mark_home_pos.x = std::max( opp_fw_1st_x, -47.0 );
                mark_home_pos.y = opp_line.getY( std::max( opp_fw_1st_x, -47.0 ) );
            }
            if( opp_fw_1st_x < wm.self().pos().x )
            {
                mark_home_pos.x = std::max( opp_fw_1st_x, -47.0 );
                if( wm.self().unum() == 2 )
                {
                    mark_home_pos.y = -2.5; 
                }
                else if( wm.self().unum() == 3 )
                {
                    mark_home_pos.y = 2.5;
                }
                else
                {
                    mark_home_pos.y = 0.0;
                }
            }
            else
            {
                if( wm.self().unum() == 2 )
                {
                    //mark_home_pos.x = opp_fw_1st_x;
                    //mark_home_pos.y = base_pos.y * 0.3 + ( -6.0 ) * 0.7;
                    rcsc::Line2D base_line( base_pos, rcsc::Vector2D( -SP.pitchHalfLength(), -4.0 ) );
                    mark_home_pos.x = std::max( opp_fw_1st_x, -47.0 );
                    mark_home_pos.y = base_line.getY( std::max( opp_fw_1st_x, -47.0 ) );
                    if( mark_home_pos.y < -10.0 )
                    {
                        mark_home_pos.y = -10.0;
                    }
                    else if( mark_home_pos.y > 2.0 )
                    {
                        mark_home_pos.y = 2.0;
                    }
                }
                else if( wm.self().unum() == 3 )
                {
                    //mark_home_pos.x = opp_fw_1st_x;
                    //mark_home_pos.y = base_pos.y * 0.3 + ( 6.0 ) * 0.7;
                    rcsc::Line2D base_line( base_pos, rcsc::Vector2D( -SP.pitchHalfLength(), 4.0 ) );
                    mark_home_pos.x = std::max( opp_fw_1st_x, -47.0 );
                    mark_home_pos.y = base_line.getY( std::max( opp_fw_1st_x, -47.0 ) );
                    if( mark_home_pos.y < -2.0 )
                    {
                        mark_home_pos.y = -2.0;
                    }
                    else if( mark_home_pos.y > 10.0 )
                    {
                        mark_home_pos.y = 10.0;
                    }
                }
                else
                {
                    mark_home_pos = home_pos;
                }
            }
            */
        }
    }
    //mark opponent get ball
    else if( fastest == opp_unum )
    {
        //chase from back
        if( wm.self().pos().x > base_pos.x )
        {
            if( opp_pos.absY() > wm.self().pos().absY() )
            {
                mark_home_pos.x = base_pos.x;
                mark_home_pos.y = wm.self().pos().y;
            }
            else
            {
                mark_home_pos = SP.ourTeamGoalPos();
                dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
                dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
                if ( dist_thr < 0.5 ) dist_thr = 0.5;
                agent->setIntention( new Opuci_IntentionDash( mark_home_pos, 5, dash_power, dist_thr ) );
            }
            agent->debugClient().addMessage( "DashFromBack" );
        }
        //chase from front
        else if( SP.ourTeamGoalPos().dist( wm.self().pos() ) < SP.ourTeamGoalPos().dist( opp_pos ) )
        {
            const rcsc::Line2D opp_line( opp_pos, SP.ourTeamGoalPos() );
            if( opp_line.dist( wm.self().pos() ) < 1.0 )
            {
                mark_home_pos = opp_pos;
            }
            else
            {
                mark_home_pos = Bhv_defense().defendOpponent( agent, opp_unum, SP.ourTeamGoalPos(), home_pos, NULL );
            }
            agent->debugClient().addMessage( "DashFromFw" );
        }
        //yokonarabi situation
        else
        {
            mark_home_pos = home_pos;
            agent->debugClient().addMessage( "Yokonarabi" );
        }
    }
    //return gaol
    else if( opp_fw_1st_x < wm.self().pos().x )
    {
        mark_home_pos.x = opp_fw_1st_x - 5.0;
        mark_home_pos.y = home_pos.y;
        if( base_pos.y > 6.0 )
        {
            if( wm.self().unum() == 2 )
            {
                mark_home_pos.y = 0.0;
            }
            else if( wm.self().unum() == 3 )
            {
                mark_home_pos.y = 6.0;
            }
        }
        else if( base_pos.y < -6.0 )
        {
            if( wm.self().unum() == 2 )
            {
                mark_home_pos.y = -6.0;
            }
            else if( wm.self().unum() == 3 )
            {
                mark_home_pos.y = 0.0;
            }
        }
        agent->debugClient().addMessage("returnGoal");
    }
    //normal move
    else
    {
        mark_home_pos = home_pos;
        agent->debugClient().addMessage( "NormalMove" );
    }

    dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
    dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
    if ( dist_thr < 0.5 ) dist_thr = 0.5;
    if( ! Opuci_Move( mark_home_pos, dash_power, dist_thr ).execute( agent ) )
    {
        if( wm.opponent( opp_unum ) )
        {
            rcsc::Body_TurnToPoint( opp_pos ).execute( agent );
        }
        else
        {
            agent->doTurn( 180.0 );
        }
    }
    Opuci_Neck().exewithmark( agent, opp_unum );
    return true;
}
