#ifndef BHV_NANA_OFFENSE_H
#define BHV_NANA_OFFENSE_H

#include <rcsc/player/soccer_action.h>
#include <rcsc/player/world_model.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/vector_2d.h>

class Bhv_nanaOffense
    : public rcsc::SoccerBehavior {
 private:
      const rcsc::Vector2D M_target_point;

 public:
      Bhv_nanaOffense( const rcsc::Vector2D target_point )
	: M_target_point( target_point )
      { }
      bool execute( rcsc::PlayerAgent * agent );

 private:
      bool doKick( rcsc::PlayerAgent * agent );
      bool doMove( rcsc::PlayerAgent * agent );
      rcsc::Vector2D getPosition( const rcsc::WorldModel & wm, const int unum );
      bool getPassPoint( rcsc::PlayerAgent * agent, std::vector<rcsc::Vector2D> * pass_point );
      bool searchPass( rcsc::PlayerAgent * agent, rcsc::Vector2D * pass_target, int * target_unum );
      bool searchDirectPass( rcsc::PlayerAgent * agnet, rcsc::Vector2D * pass_target, int * target_unum );
      bool searchDribble( rcsc::PlayerAgent * agent,
			  rcsc::Vector2D * dribble_target,
			  int * dash_count );
      double dashPower( rcsc::PlayerAgent * agent,
			const double limit_power = rcsc::ServerParam::i().maxPower() );
      bool neckToMate( rcsc::PlayerAgent * agent );
      double setFormationPos( rcsc::PlayerAgent * agent, std::vector< rcsc::Vector2D > & candidates );
      bool holdBall( rcsc::PlayerAgent * agent );
      bool holdBall( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos );
      bool testPass( rcsc::PlayerAgent * agent, rcsc::Vector2D & target_pos, int & mate_unum, bool allow_back );
      bool checkPassSafe( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos, rcsc::PlayerObject * receiver, int & opp_cycle );
      bool checkDribbleSafe( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos, int dash_cycle );
      bool doSelfPass( rcsc::PlayerAgent * agent, rcsc::AngleDeg angle, int dash_cycle );
      bool checkThroughPass( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * receiver, rcsc::Vector2D & target_pos, double & final_ball_speed );
      bool checkThroughPass2( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * receiver, rcsc::Vector2D & target_pos, double & final_ball_speed );

      void getOppEndLine( rcsc::PlayerAgent * agent, std::vector< rcsc::Vector2D > & oppline, double margin = 3.0 );
};

#endif
