#ifndef BHV_OFFENSE_H
#define BHV_OFFENSE_H

#include <rcsc/player/soccer_action.h>
#include <rcsc/player/world_model.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/vector_2d.h>
#include <rcsc/geom/sector_2d.h>
class Bhv_Offense
    : public rcsc::SoccerBehavior {
 private:
      const rcsc::Vector2D M_target_point;

 public:
      Bhv_Offense( const rcsc::Vector2D target_point )
	: M_target_point( target_point )
      { }
      Bhv_Offense()
          : M_target_point( rcsc::Vector2D( 52, 0 ) )
      { }
      bool execute( rcsc::PlayerAgent * agent );
      int selfReachCycle( rcsc::PlayerAgent * agent );
      int cyclesViaPoint( rcsc::PlayerAgent * agent, rcsc::Vector2D way_pos );
      void getOppEndLine( rcsc::PlayerAgent * agent, std::vector< rcsc::Vector2D > & oppline );
      bool getMateFrontLine( rcsc::PlayerAgent * agent, std::vector< rcsc::Vector2D > & matefront );
      bool doSelfPass( rcsc::PlayerAgent * agent, rcsc::AngleDeg angle, int dash_cycle );
      bool holdBall( rcsc::PlayerAgent * agent );
      bool holdBall( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos );
      double setFormationPos( rcsc::PlayerAgent * agent, std::vector< rcsc::Vector2D > & candidates );
      bool checkThroughPass( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * receiver, rcsc::Vector2D & target_pos, double & final_ball_speed );
      bool checkThroughPass2( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * receiver, rcsc::Vector2D & target_pos, double & final_ball_speed );
      bool testPass( rcsc::PlayerAgent * agent, rcsc::Vector2D & target_pos, int & mate_unum, bool allow_back );
      bool checkPassSafe( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos, rcsc::PlayerObject * receiver, int & opp_cycle );
      bool neckToMate( rcsc::PlayerAgent * agent );
      int checkReceiver( rcsc::PlayerAgent * agent, rcsc::Vector2D receiver_pos );
      int checkReceiver( rcsc::PlayerAgent * agent, rcsc::Vector2D receiver_pos, rcsc::Vector2D target_pos );
      int checkPassReceive( rcsc::PlayerAgent * agent, rcsc::Vector2D passer_pos, rcsc::Vector2D receiver_pos );
      void ranking( rcsc::PlayerAgent * agent, std::vector< rcsc::AbstractPlayerObject* > & candidates );
      int countSectorOpp( rcsc::PlayerAgent * agent, rcsc::Vector2D receiver_pos, rcsc::AngleDeg angle, double length, rcsc::AngleDeg width, bool goalie = false );
      rcsc::Sector2D freeSector( rcsc::PlayerAgent * agent, rcsc::Vector2D receiver_pos, rcsc::AngleDeg & angle, double & length );
      void findFrontFreeMate( std::vector<int> & unumffmate, rcsc::PlayerAgent *agent );
      bool getSubReceiver( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * last_receiver, std::vector< rcsc::PlayerObject* > & subs );
      void surroundOppNum( rcsc::PlayerAgent * agent, std::vector< int > & opp_num );
      bool pointingPass( rcsc::PlayerAgent * agent, rcsc::PlayerObject * receiver, rcsc::Vector2D & pass_target, double & first_speed );
      bool decideTurnAngleWhenImThere( rcsc::PlayerAgent * agent, rcsc::Vector2D & t_receive );
	    
 private:
      bool doKick( rcsc::PlayerAgent * agent );
      bool doMove( rcsc::PlayerAgent * agent );
      rcsc::Vector2D getPosition( const rcsc::WorldModel & wm, const int unum );
      bool getPassPoint( rcsc::PlayerAgent * agent, std::vector<rcsc::Vector2D> * pass_point );
      bool searchPass( rcsc::PlayerAgent * agent, rcsc::Vector2D * pass_target, int * target_unum );
      bool searchDirectPass( rcsc::PlayerAgent * agnet, rcsc::Vector2D * pass_target, int * target_unum );
      bool searchDribble( rcsc::PlayerAgent * agent,
			  rcsc::Vector2D * dribble_target,
			  int * dash_count );
      double dashPower( rcsc::PlayerAgent * agent,
			const double limit_power = rcsc::ServerParam::i().maxPower() );

      bool checkDribbleSafe( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos, int dash_cycle );

};

#endif
