// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "bhv_basic_move.h"
#include "bhv_opuci_center_back_move.h"
#include "bhv_basic_tackle.h"
#include "opuci_move.h"
#include "opuci_chase_ball.h"
#include "opuci_neck.h"
#include "strategy.h"
#include "bhv_defense.h"

#include <rcsc/action/body_turn_to_point.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_opuciCenterBackMove::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Bhv_opuciDefensiveMove"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & SP = rcsc::ServerParam::i();

    //ball lost
    if( ! wm.ball().posCount() > 100 )
    {
        if( ! Opuci_Move( SP.ourTeamGoalPos() ).execute( agent ) )
        {
            agent->doTurn( 180.0 );
        }
        Opuci_Neck().execute( agent );
    }

    // tackle
    if ( Bhv_BasicTackle( 0.9, 80.0 ).execute( agent ) )
    {
        return true;
    }
    else if( wm.ball().pos().x < -35.0 && wm.ball().distFromSelf() < 3.0 )
    {
        if( Bhv_BasicTackle( 0.80, 80.0 ).execute( agent ) )
        {
            return true;
        }
    }
    else if( wm.ball().pos().x < -32.0 
             && ! wm.existKickableTeammate() 
             && std::abs( wm.ball().pos().y - wm.self().pos().y ) < 2.0 
             && wm.ball().distFromSelf() < 6.0 )
    {
        if( Bhv_BasicTackle( 0.80, 80.0 ).execute( agent ) )
        {
            return true;
        }
    }

    // check ball owner
    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();
    int fastest = 0;
    int ball_reach_step = 0;
    if( !wm.existKickableTeammate()
        && !wm.existKickableOpponent() )
    {
        ball_reach_step = std::min( mate_min,
                                    opp_min );
    }
    if( wm.interceptTable()->fastestOpponent() )
    {
        fastest = wm.interceptTable()->fastestOpponent()->unum();
    }
    const rcsc::Vector2D base_pos = wm.ball().inertiaPoint( ball_reach_step );

    if ( ! wm.existKickableTeammate()
         && self_min < mate_min
         && self_min < opp_min )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: intercept"
                            ,__FILE__, __LINE__ );
        //rcsc::Body_Intercept().execute( agent );
        Opuci_ChaseBall().execute( agent );
        Opuci_Neck().execute( agent );
        return true;
    }

    // go to home position
    rcsc::Vector2D mark_home_pos = M_home_pos;
    double dist_thr = M_home_pos.dist( wm.self().pos() ) * 0.1;
    double dash_power = Bhv_defense().getDashPower( agent, M_home_pos );
    if ( dist_thr < 0.5 ) dist_thr = 0.5;

    int opp_unum = 0;
    static int pre_opp_unum = 0;
    bool trace_mode = false;
    rcsc::Vector2D opp_pos = M_home_pos;
    std::vector<int> opp_fw = Bhv_defense().oppForward( agent );

    if( opp_min <= self_min
        && opp_min <= mate_min )
    {
        trace_mode = true;
    }
    
    if( self_min < mate_min )
    {
        opp_unum = fastest;
        trace_mode = false;
    }
    else
    {
        if( opp_fw.empty() )
        {
            if( ! Opuci_Move( M_home_pos, dash_power, dist_thr ).execute( agent ) )
            {
                agent->doTurn( 180.0 );
            }
            Opuci_Neck().execute( agent );
            return true;
        }
        else if( trace_mode
                 && wm.opponent( opp_unum ) )
        {
            agent->debugClient().addMessage( "traceM" );
            opp_unum = pre_opp_unum;
        }
        else
        {
            for( std::vector<int>::iterator it = opp_fw.begin();
                 it != opp_fw.end();
                 ++it )
            {
                if( wm.opponent( (*it) )
                    && M_home_pos.y + 7.0 > wm.opponent( (*it) )->pos().y
                    && M_home_pos.y - 7.0 < wm.opponent( (*it) )->pos().y )
                {
                    opp_unum = (*it);
                }
            }
            /*
            if( opp_forward.size() == 1 )
            {
                if( ! Opuci_Move( M_home_pos, dash_power, dist_thr ).execute( agent ) )
                {
                    agent->doTurn( 180.0 );
                }
                Opuci_Neck().execute( agent );
                return true;
            }
            else if( opp_forward.size() == 2 )
            {
                opp_unum = opp_forward.front();
                for( std::vector<int>::iterator it = opp_forward.begin();
                     it != opp_forward.end();
                     it++ )
                {
                    if( wm.opponent( (*it) )
                        && wm.opponent( opp_unum )
                        && wm.opponent( (*it) )->pos().absY() < wm.opponent( opp_unum )->pos().absY() )
                    {
                        opp_unum = (*it);
                    }
                }
                if( Bhv_defense().oppMarked( agent, opp_unum ) )
                {
                    if( ! Opuci_Move( M_home_pos, dash_power, dist_thr ).execute( agent ) )
                    {
                        agent->doTurn( 180.0 );
                    }
                    Opuci_Neck().execute( agent );
                    return true;
                }
            }
            else
            {
                opp_unum = opp_forward.at( 1 );
            }
            */
        }
    }

    if( wm.opponent( opp_unum ) )
    {
        opp_pos = wm.opponent( opp_unum )->pos();
        pre_opp_unum = opp_unum;
        agent->debugClient().addMessage( "Mark:%d", opp_unum );
    }
    else
    {
        if( ! Opuci_Move( M_home_pos, dash_power, dist_thr ).execute( agent ) )
        {
            agent->doTurn( 180.0 );
        }
        Opuci_Neck().execute( agent );
        return true;
    }
    rcsc::Vector2D home_pos = M_home_pos;
    /*
    rcsc::Vector2D home_pos = Bhv_defense().defendOpponentMate( agent, 
                                                                opp_unum, 
                                                                wm.self().unum(), 
                                                                SP.ourTeamGoalPos(),
                                                                M_home_pos,
                                                                NULL );
    */
    rcsc::AngleDeg angle = ( opp_pos - SP.ourTeamGoalPos() ).th();

    const rcsc::Line2D shoot_line( wm.ball().pos(), base_pos );
    //opponent's shoot situation
    if( base_pos.x < -SP.pitchHalfLength()
        && shoot_line.intersection( rcsc::Line2D( rcsc::Vector2D( -52.0, -10.0 ), 
                                                  rcsc::Vector2D( -52.0, 10.0 ) ) ).absY() < 9.0 )
    {
        mark_home_pos = shoot_line.projection( wm.self().pos() );
        agent->debugClient().addMessage("InterceptDash");
    }
    //danger area situation
    else if( base_pos.x < -SP.pitchHalfLength() + SP.penaltyAreaLength()
  	     && wm.self().pos().x < -30.0 )
    {
        if( self_min < mate_min )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: intercept"
                                ,__FILE__, __LINE__ );
            Opuci_ChaseBall().execute( agent );
            Opuci_Neck().execute( agent );
            return true;
        }
        else if( wm.ball().pos().dist( wm.self().pos() ) < wm.self().playerType().realSpeedMax() 
            + wm.self().playerType().kickableArea() )
	{
            mark_home_pos = wm.ball().pos();
            agent->debugClient().addMessage( "Intercept" );
	}
        else if( self_min < mate_min
                 && base_pos.absY() < SP.penaltyAreaHalfWidth() )
	{
            mark_home_pos = home_pos;
            agent->debugClient().addMessage("NearestBall");
	}
        else if( opp_pos.dist( base_pos ) < 5.0 )
	{
            mark_home_pos = opp_pos * 0.9 + SP.ourTeamGoalPos() * 0.1;
            agent->debugClient().addMessage("MarkNearestOpp");
	}
        else if( base_pos.absY() < SP.goalAreaHalfWidth() )
	{
            mark_home_pos = opp_pos * 0.7 + SP.ourTeamGoalPos() * 0.3;
            agent->debugClient().addMessage("CutShootLine");
	}
        else
	{
            mark_home_pos = M_home_pos;
	}
    }
    //mark opponent get ball
    else if( fastest == opp_unum )
    {
        //dribble situation
        if( base_pos.dist( SP.ourTeamGoalPos() ) > wm.self().pos().dist( SP.ourTeamGoalPos() ) )
        {
            const rcsc::Line2D base_line( base_pos, SP.ourTeamGoalPos() );
            if( base_pos.dist( wm.self().pos() ) < 3.0
                && base_line.dist( wm.self().pos() ) < 1.5 )
            {
                mark_home_pos = base_pos;
            }
            else
            {
                mark_home_pos = home_pos;
            }
            agent->debugClient().addMessage("DefendDribble");
        }
        //through pass situation
        else if( base_pos.x < wm.defenseLineX() )
        {
            rcsc::Line2D opp_line( opp_pos, SP.ourTeamGoalPos() );
            if( opp_pos.absY() > wm.self().pos().absY() )
            {
                mark_home_pos.x = opp_line.getX( wm.self().pos().y );
                mark_home_pos.y = wm.self().pos().y;
            }
            else
            {
                mark_home_pos = SP.ourTeamGoalPos();
            }
            agent->debugClient().addMessage("DefendThrPassA");
        }
        else
        {
            mark_home_pos = home_pos;
        }
    }
    //unmark opponent get ball
    else if( base_pos.x < wm.defenseLineX() + 1.0 )
    {
        mark_home_pos = SP.ourTeamGoalPos();
        agent->debugClient().addMessage( "DefendThrPassB" );
    }
    else
    {
        mark_home_pos = home_pos;
        /*
        if( opp_forward.size() == 3 )
        {
            if( wm.opponent( opp_forward.at( 0 ) )
                && wm.opponent( opp_forward.at( 1 ) )
                && base_pos.y > wm.opponent( opp_forward.at( 1 ) )->pos().y
                && Bhv_defense().oppMarked( agent, opp_forward.at( 1 ) ) )
            {
                mark_home_pos.x = opp_pos.x;
                mark_home_pos.y = wm.opponent( opp_forward.at( 0 ) )->pos().y * 0.5
                    + wm.opponent( opp_forward.at( 1 ) )->pos().y * 0.5;
            }
        }
        */
        agent->debugClient().addMessage("NormalMove");
    }

    if( mark_home_pos.x > 0.0 )
    {
        mark_home_pos.x = 0.0;
    }
    dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.1;
    dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
    if ( dist_thr < 0.5 ) dist_thr = 0.5;
    if( ! Opuci_Move( mark_home_pos, dash_power, dist_thr ).execute( agent ) )
    {
        if( wm.opponent( opp_unum ) )
        {
            rcsc::Body_TurnToPoint( opp_pos ).execute( agent );
        }
        else
        {
            agent->doTurn( 180.0 );
        }
    }
    Opuci_Neck().exewithmark( agent, opp_unum );
    return true;
}
