// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "bhv_basic_move.h"
#include "bhv_opuci_defensivehalf_move.h"

#include "bhv_basic_tackle.h"
#include "opuci_move.h"
#include "opuci_neck.h"
#include "opuci_chase_ball.h"
#include "opuci_intention_dash.h"
#include "bhv_defense.h"
#include "strategy.h"
#include "bhv_danger_area_tackle.h"

#include <rcsc/action/basic_actions.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_opuciDefensiveHalfMove::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Bhv_opuciDefensiveHalfMove"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & SP = rcsc::ServerParam::i();

    //ball lost
    if( ! wm.ball().state().ghost_count_ > 0 )
    {
        agent->doTurn( 180.0 );
        rcsc::Neck_TurnToBallOrScan().execute( agent );
    }

    const rcsc::Rect2D our_penalty( rcsc::Vector2D( -SP.pitchHalfLength(),
                                                    -SP.penaltyAreaHalfWidth() + 1.0 ),
                                    rcsc::Size2D( SP.penaltyAreaLength() - 1.0,
                                                  SP.penaltyAreaWidth() - 2.0 ) );
    // tackle
    if( our_penalty.contains( wm.ball().pos() )
        && !wm.existKickableTeammate()
        && Bhv_DangerAreaTackle( 0.5 ).execute( agent ) )
    {
        return true;
    }
    else if ( Bhv_BasicTackle( 0.9, 80.0 ).execute( agent ) )
    {
        return true;
    }
    else if( wm.ball().pos().x < -38.0 && wm.ball().distFromSelf() < 4.0 )
    {
        if( Bhv_BasicTackle( 0.75, 80.0 ).execute( agent ) )
        {
            return true;
        }
    }
    else if( Bhv_defense().prepareTackle( agent ) )
    {
        return true;
    }

    // check ball owner
    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();
    int fastest = 0;
    if( wm.interceptTable()->fastestOpponent() )
    {
        fastest = wm.interceptTable()->fastestOpponent()->unum();
    }
    const rcsc::Vector2D base_pos = Bhv_defense().ballInertiaPoint( agent );

    if ( ! wm.existKickableTeammate()
         && self_min < mate_min
         && self_min <= opp_min
         && wm.ball().inertiaPoint( self_min ).absX() < SP.pitchHalfLength() + 5.0
         && wm.ball().inertiaPoint( self_min ).absY() < SP.pitchHalfWidth() + 5.0  )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: intercept"
                            ,__FILE__, __LINE__ );
        rcsc::Body_Intercept().execute( agent );
        //Opuci_ChaseBall().execute( agent );
        rcsc::Neck_TurnToBallOrScan().execute( agent );
        return true;
    }

    // go to home position
    rcsc::Vector2D mark_home_pos = M_home_pos;
    double dist_thr = M_home_pos.dist( wm.self().pos() ) * 0.3;
    double dash_power = Bhv_defense().getDashPower( agent, M_home_pos );
    if ( dist_thr < 0.5 ) dist_thr = 0.5;

    int opp_unum = -2;
    rcsc::Vector2D opp_pos = M_home_pos;
    std::vector<int> opp_fw = Bhv_defense().oppForward( agent );
    const double opp_fw_1st_x = Bhv_defense().oppFwLineX( agent );
    double opp_fw_2nd_x = 0.0;
    for( std::vector<int>::iterator it = opp_fw.begin();
         it != opp_fw.end();
         ++it )
    {
        if( wm.opponent( (*it) )
            && wm.opponent( (*it) )->pos().x > opp_fw_1st_x
            && wm.opponent( (*it) )->pos().x < opp_fw_2nd_x )
        {
            opp_fw_2nd_x = wm.opponent( (*it) )->pos().x;
        }
    }
    double opp_fw_line_x = std::min( std::min( opp_fw_1st_x, base_pos.x ), 0.0 ) + 5.0;
    if( opp_fw_2nd_x - opp_fw_1st_x > 10.0 )
    {
        opp_fw_line_x = std::min( std::min( opp_fw_2nd_x, base_pos.x ), 0.0 ) + 5.0;
    }
    rcsc::Vector2D home_pos( opp_fw_line_x, M_home_pos.y );
    bool no_mark_opp = false;

    if( self_min < mate_min )
    {
        opp_unum = fastest;
    }
    else
    {
        if( opp_fw.empty() )
        {
            no_mark_opp = true;
        }
        else
        {
            //フォワードの最も中心の敵をマーク対象とする
            rcsc::Vector2D centroid( 0.0, 0.0 );
            for( std::vector<int>::iterator it = opp_fw.begin();
                 it != opp_fw.end();
                 ++it )
            {
                centroid.x += wm.opponent( (*it) )->pos().x;
                centroid.y += wm.opponent( (*it) )->pos().y;
            }
            centroid.x /= opp_fw.size();
            centroid.y /= opp_fw.size();

            rcsc::Vector2D opp_pos = wm.opponent( opp_fw.front() )->pos();;
            for( std::vector<int>::iterator it = opp_fw.begin();
                 it != opp_fw.end();
                 ++it )
            {
                if( wm.opponent( (*it ) )
                    && wm.opponent( (*it) )->pos().dist( centroid ) < opp_pos.dist( centroid ) )
                {
                    opp_pos = wm.opponent( (*it) )->pos();
                    opp_unum = (*it);
                }
            }
            for( int i = 7; i <= 8; i++ )
            {
                if( wm.teammate( i )
                    && i != wm.self().unum() )
                {
                    if( wm.self().pos().dist( opp_pos ) > wm.teammate( i )->pos().dist( opp_pos )
                        && SP.ourTeamGoalPos().dist( wm.teammate( i )->pos() ) < SP.ourTeamGoalPos().dist( opp_pos ) )
                    {
                        no_mark_opp = true;
                        opp_unum = 0;
                        break;
                    }
                }
            }
        }
    }

    if( wm.opponent( opp_unum ) )
    {
        opp_pos = wm.opponent( opp_unum )->pos();
        const rcsc::Line2D line( base_pos, opp_pos );
        const rcsc::AngleDeg angle = ( base_pos - opp_pos ).th();
        if( angle.degree() > -45.0
            && angle.degree() < 45.0 )
        {
            home_pos.x = opp_pos.x + 5.0;
            home_pos.y = line.getY( opp_pos.x + 5.0 );
        }
        else if( angle.degree() < -90.0
                 || angle.degree() > 90.0 )
        {
            home_pos.x = opp_pos.x;
            home_pos.y = opp_pos.y + 5.0 * ( angle.degree() / angle.abs() );
        }
        else
        {
            home_pos.x = line.getX( opp_pos.y + 5.0 * ( angle.degree() / angle.abs() ) );
            home_pos.y = opp_pos.y + 5.0 * ( angle.degree() / angle.abs() );
        }
        //home_pos = Bhv_defense().defendOpponent( agent, opp_unum, SP.ourTeamGoalPos(), mark_pos, NULL );
        agent->debugClient().addMessage( "Mark:%d", opp_unum );
    }
    else if( no_mark_opp )
    {
        agent->debugClient().addMessage("NoMarkOpp");
    }
    else
    {
        if( ! Opuci_Move( home_pos, dash_power, dist_thr ).execute( agent ) )
        {
            agent->doTurn( 180.0 );
        }
        rcsc::Neck_TurnToBallOrScan().execute( agent );
        agent->debugClient().addMessage("OppLost");
        return true;
    }

    //shoot situation
    if( rcsc::Segment2D( wm.ball().pos(), wm.ball().inertiaFinalPoint() ).existIntersection( 
            rcsc::Segment2D( rcsc::Vector2D( -52.5, -9.0 ), rcsc::Vector2D( -52.5, 9.0 ) ) )
        && wm.self().pos().x < wm.ball().pos().x
        && base_pos.x < -52.0 )
    {
        agent->debugClient().addMessage("shootM");
        rcsc::Vector2D move_point = rcsc::Line2D( wm.ball().pos(), wm.ball().inertiaFinalPoint() ).intersection(
            rcsc::Line2D( rcsc::Vector2D( -52.5, -9.0 ), rcsc::Vector2D( -52.5, 9.0 ) ) );
        int cycle = 1;
        for( int i = 1; i < 15; i++ )
        {
            if( wm.ball().inertiaPoint( i ).dist( wm.self().pos() ) < move_point.dist( wm.self().pos() ) )
            {
                move_point = wm.ball().inertiaPoint( i );
                cycle = i;
            }
            if( wm.ball().inertiaPoint( i + 1 ).x < -52.0 )
            {
                move_point = wm.ball().inertiaPoint( i );
                cycle = i;
                break;
            }
        }
        if( cycle < 3 )
        {
            const rcsc::AngleDeg angle_to_point = ( wm.self().pos() - move_point ).th();
            const rcsc::AngleDeg angle = 180.0 - ( wm.self().body() - angle_to_point ).degree();
            agent->doDash( SP.maxDashPower(), angle );
            agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
            return true;
        }
        else
        {
            rcsc::Body_Intercept().execute( agent );
            rcsc::Neck_TurnToBallOrScan().execute( agent );
            return true;
        }
    }

    bool danger_mode = false;
    if( base_pos.x < -30.0
        && Bhv_defense().oppFwLineX( agent ) < -30.0 )
    {
        danger_mode = true;
    }
    //danger area situation
    if( danger_mode )
    {
        agent->debugClient().addMessage("dangerM");
        const rcsc::Line2D opp_line( base_pos, SP.ourTeamGoalPos() );
        if( wm.self().pos().dist( base_pos ) < 3.0
            && opp_line.dist( wm.self().pos() ) < 1.0 )
        {
            mark_home_pos = base_pos;
            dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
            dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
            if ( dist_thr < 0.5 ) dist_thr = 0.5;
            agent->setIntention( new Opuci_IntentionDash( mark_home_pos, 3, dash_power, dist_thr ) );
        }
        else if( self_min <= mate_min )
        {
            agent->debugClient().addMessage("chaseOpp");
            if( opp_line.dist( wm.self().pos() ) < 1.0 )
            {
                mark_home_pos = base_pos;
            }
            else
            {
                mark_home_pos = Bhv_defense().defendOpponent( agent, fastest, SP.ourTeamGoalPos(), opp_pos, NULL );
                dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
                dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
                if ( dist_thr < 0.5 ) dist_thr = 0.5;
                agent->setIntention( new Opuci_IntentionDash( mark_home_pos, 2, dash_power, dist_thr ) );
            }
        }
        else
        {
            rcsc::Vector2D mark_pos( -36.0, 1.0 * ( base_pos.y / base_pos.absY() ) );
            if( wm.getOpponentNearestTo( mark_pos, 10, NULL ) )
            {
                mark_home_pos = base_pos * 0.1 + wm.getOpponentNearestTo( mark_pos, 10, NULL )->pos() * 0.9;
            }
            else
            {
                mark_home_pos = mark_pos;
            }
            /*
            const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
            rcsc::Vector2D opp_pos = opps.front()->pos();
            for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
                 it != opps.end();
                 ++it )
            {
                if( (*it)->unum() != fastest
                    && (*it)->pos().dist( base_pos ) + (*it)->pos().dist( SP.ourTeamGoalPos() )
                    < opp_pos.dist( base_pos ) + opp_pos.dist( SP.ourTeamGoalPos() ) )
                {
                    opp_pos = (*it)->pos();
                }
            }
            rcsc::Segment2D segment( base_pos, opp_pos );
            mark_home_pos = segment.nearestPoint( wm.self().pos() );
            if( segment.dist( wm.self().pos() ) < 1.0 )
            {
                rcsc::AngleDeg angle = ( base_pos - opp_pos ).th();
                mark_home_pos.x = opp_pos.x + angle.cos() * 3.0;
                mark_home_pos.y = opp_pos.y + angle.sin() * 3.0;
            }
            */
            agent->debugClient().addMessage("CutLine");
        }
    }
    //mark opponent get ball
    else if( fastest == opp_unum )
    {
        //chase from back
        if( wm.self().pos().x > base_pos.x )
        {
            if( opp_pos.absY() < wm.self().pos().absY() )
            {
                mark_home_pos.x = base_pos.x - 1.0;
                mark_home_pos.y = base_pos.y;
            }
            else
            {
                mark_home_pos = SP.ourTeamGoalPos();
                dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
                dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
                if ( dist_thr < 0.5 ) dist_thr = 0.5;
                agent->setIntention( new Opuci_IntentionDash( mark_home_pos, 5, dash_power, dist_thr ) );
            }
            agent->debugClient().addMessage( "DashFromBack" );
        }
        //chase from front
        else if( SP.ourTeamGoalPos().dist( wm.self().pos() ) < SP.ourTeamGoalPos().dist( opp_pos ) )
        {
            const rcsc::Line2D opp_line( opp_pos, SP.ourTeamGoalPos() );
            if( opp_line.dist( wm.self().pos() ) < 1.0 )
            {
                mark_home_pos = opp_pos;
            }
            else
            {
                mark_home_pos = Bhv_defense().defendOpponent( agent, opp_unum, SP.ourTeamGoalPos(), opp_pos, NULL );
            }
            agent->debugClient().addMessage( "DashFromFw" );
        }
        //yokonarabi situation
        else
        {
            mark_home_pos = home_pos;
            agent->debugClient().addMessage( "Yokonarabi" );
        }
    }
    //normal move
    else
    {
        mark_home_pos = home_pos;
        agent->debugClient().addMessage("NormalMove");
    }

    dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
    dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
    if ( dist_thr < 0.5 ) dist_thr = 0.5;
    if( ! Opuci_Move( mark_home_pos, dash_power, dist_thr ).execute( agent ) )
    {
        if( wm.opponent( opp_unum ) )
        {
            rcsc::Body_TurnToPoint( opp_pos ).execute( agent );
        }
        else
        {
            agent->doTurn( 180.0 );
        }
    }
    Opuci_Neck().exewithmark( agent, opp_unum );
    return true;
}
