// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "bhv_basic_move.h"
#include "bhv_opuci_sideback_move.h"
#include "bhv_basic_tackle.h"
#include "opuci_move.h"
#include "opuci_chase_ball.h"
#include "opuci_neck.h"
#include "opuci_intention_dash.h"
#include "strategy.h"
#include "bhv_defense.h"
#include "bhv_danger_area_tackle.h"

#include <rcsc/action/body_turn_to_point.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_opuciSidebackMove::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Bhv_opuciSidebackMove"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & SP = rcsc::ServerParam::i();

    //ball lost
    if( ! wm.ball().state().ghost_count_ > 0 )
    {
        agent->doTurn( 180.0 );
        rcsc::Neck_TurnToBallOrScan().execute( agent );
    }

    const rcsc::Rect2D our_penalty( rcsc::Vector2D( -SP.pitchHalfLength(),
                                                    -SP.penaltyAreaHalfWidth() + 1.0 ),
                                    rcsc::Size2D( SP.penaltyAreaLength() - 1.0,
                                                  SP.penaltyAreaWidth() - 2.0 ) );
    //tackle
    if( our_penalty.contains( wm.ball().pos() )
        && !wm.existKickableTeammate()
        && Bhv_DangerAreaTackle( 0.5 ).execute( agent ) )
    {
        return true;
    }
    else if ( Bhv_BasicTackle( 0.9, 80.0 ).execute( agent ) )
    {
        return true;
    }
    else if( ! wm.existKickableTeammate() && std::abs(wm.ball().pos().x - wm.self().pos().x ) 
             < 1.5 && wm.ball().distFromSelf() < 3.0 )
    {
        if( Bhv_BasicTackle( 0.5, 80.0 ).execute( agent ) )
        {
            return true;
        }
    }
    else if( ! wm.existKickableTeammate() && wm.ball().pos().x < -32.0 && std::abs(wm.ball().pos().y ) 
             < 12.0 && wm.ball().distFromSelf() < 3.0 )
    {
        if( Bhv_BasicTackle( 0.5, 80.0 ).execute( agent ) )
        {
            return true;
        }
    }
    else if( Bhv_defense().prepareTackle( agent ) )
    {
        return true;
    }

    // check ball owner
    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();
    int fastest = 0;
    if( wm.interceptTable()->fastestOpponent()
        && opp_min < mate_min )
    {
        fastest = wm.interceptTable()->fastestOpponent()->unum();
    }
    const rcsc::Vector2D base_pos = Bhv_defense().ballInertiaPoint( agent );

    if( ! wm.existKickableTeammate()
        && self_min < mate_min
        && self_min <= opp_min
        && wm.ball().inertiaPoint( self_min ).absX() < SP.pitchHalfLength() + 5.0
        && wm.ball().inertiaPoint( self_min ).absY() < SP.pitchHalfWidth() + 5.0  )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: intercept"
                            ,__FILE__, __LINE__ );
        rcsc::Body_Intercept().execute( agent );
        //Opuci_ChaseBall().execute( agent );
        rcsc::Neck_TurnToBallOrScan().execute( agent );
        return true;
    }

    // go to home position
    rcsc::Vector2D mark_home_pos = M_home_pos;
    double dist_thr = M_home_pos.dist( wm.self().pos() ) * 0.3;
    double dash_power = Bhv_defense().getDashPower( agent, M_home_pos );
    if ( dist_thr < 0.5 ) dist_thr = 0.5;

    int opp_unum = -2;
    rcsc::Vector2D opp_pos = M_home_pos;
    std::vector<int> opp_fw = Bhv_defense().oppForward( agent );
    const double opp_fw_1st_x = Bhv_defense().oppFwLineX( agent );
    double opp_fw_2nd_x = 0.0;
    for( std::vector<int>::iterator it = opp_fw.begin();
         it != opp_fw.end();
         ++it )
    {
        if( wm.opponent( (*it) )
            && wm.opponent( (*it) )->pos().x > opp_fw_1st_x
            && wm.opponent( (*it) )->pos().x < opp_fw_2nd_x )
        {
            opp_fw_2nd_x = wm.opponent( (*it) )->pos().x;
        }
    }
    double opp_fw_line_x = std::min( std::min( opp_fw_1st_x, base_pos.x ), 0.0 ) - 1.0;
    if( opp_fw_2nd_x - opp_fw_1st_x > 10.0 )
    {
        opp_fw_line_x = std::min( std::min( opp_fw_2nd_x, base_pos.x ), 0.0 ) - 1.0;
    }
    bool no_mark_opp = false;
    rcsc::Vector2D goal_side( -52.5, 10.0 * ( M_home_pos.y / M_home_pos.absY() ) );

    bool danger_mode = false;
    if( base_pos.x < -30.0
        && Bhv_defense().oppFwLineX( agent ) < -30.0 )
    {
        danger_mode = true;
    }
    if( danger_mode )
    {
        goal_side = rcsc::Vector2D( -52.5, 6.0 * ( M_home_pos.y / M_home_pos.absY() ) );
    }

    bool self_nearest_to_ball = true;    for( int i = 2; i <= 5; i++ )
    {
        if( wm.opponent( fastest )
            && wm.teammate( i )
            && wm.self().unum() != i
            && wm.teammate( i )->pos().dist( wm.opponent( fastest )->pos() )
            < wm.self().pos().dist( wm.opponent( fastest )->pos() ) )
        {
            self_nearest_to_ball = false;
            break;
        }
    }
    if( self_nearest_to_ball )
    {
        for( std::vector<int>::iterator it = opp_fw.begin();
             it != opp_fw.end();
             it++ )
        {
            if( fastest == (*it) )
            {
                opp_unum = fastest;
                break;
            }
        }
    }
    else
    {
        if( opp_fw.empty() )
        {
            no_mark_opp = true;
        }
        else
        {
            if( opp_fw.size() > 2 )
            {
                if( wm.self().unum() == 4
                    && wm.opponent( opp_fw.back() ) )
                {
                    opp_unum = opp_fw.back();
                }
                else if( wm.self().unum() == 5
                         && wm.opponent( opp_fw.front() ) )
                {
                    opp_unum = opp_fw.front();
                }
                else
                {
                    no_mark_opp = true;
                }
            }
            else
            {
                no_mark_opp = true;
            }
        }
    }

    rcsc::Vector2D home_pos( opp_fw_line_x, M_home_pos.y );
    if( wm.opponent( opp_unum ) )
    {
        opp_pos = wm.opponent( opp_unum )->pos();
        rcsc::Vector2D second_opp_pos = base_pos;
        const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
        for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
             it != opps.end();
             ++it )
        {
            if( (*it)->unum() != opp_unum
                && opp_pos.dist( (*it)->pos() ) < opp_pos.dist( second_opp_pos ) )
            {
                second_opp_pos = (*it)->pos();
            }
        }
        int ball_cycle = (int)rcsc::calc_length_geom_series( SP.ballSpeedMax(), 
                                                             second_opp_pos.dist( opp_pos ),
                                                             SP.ballDecay() );
        rcsc::Line2D opp_line( opp_pos, goal_side );
        if( ball_cycle < 0
            || ball_cycle > 15 )
        {
            home_pos.x = opp_fw_line_x;
            //home_pos.y = opp_line.getY( opp_fw_line_x );
            home_pos.y = opp_pos.y;
        }
        else
        {
            rcsc::Vector2D mark_pos = opp_pos;
            const rcsc::AngleDeg angle = ( opp_pos - goal_side ).th();
            if( ball_cycle < 3 )
            {
                mark_pos.x = opp_fw_line_x;
                //mark_pos.y = opp_line.getY( opp_fw_line_x );
                mark_pos.y = opp_pos.y;
                agent->debugClient().addMessage("ballNearOpp");
            }
            else
            {
                const double dash_r = wm.self().playerTypePtr()->dashDistanceTable().at( ball_cycle - 2 );
                mark_pos.x = opp_fw_line_x;
                //mark_pos.y = opp_line.getY( opp_fw_line_x ) - dash_r * ( M_home_pos.y / M_home_pos.absY() );
                mark_pos.y = opp_pos.y - dash_r * ( M_home_pos.y / M_home_pos.absY() );   
            }
            home_pos = mark_pos;
        }
        agent->debugClient().addMessage( "Mark:%d", opp_unum );
    }
    else if( no_mark_opp )
    {
        home_pos.x = opp_fw_line_x;
        home_pos.y = M_home_pos.y;
        agent->debugClient().addMessage("NoMarkOpp");
    }
    else
    {
        if( ! Opuci_Move( home_pos, dash_power, dist_thr ).execute( agent ) )
        {
            agent->doTurn( 180.0 );
        }
        rcsc::Neck_TurnToBallOrScan().execute( agent );
        agent->debugClient().addMessage("OppLost");
        return true;
    }

    //shoot situation
    if( rcsc::Segment2D( wm.ball().pos(), wm.ball().inertiaFinalPoint() ).existIntersection( 
            rcsc::Segment2D( rcsc::Vector2D( -52.5, -9.0 ), rcsc::Vector2D( -52.5, 9.0 ) ) )
        && wm.self().pos().x < wm.ball().pos().x
        && base_pos.x < -52.0 )
    {
        agent->debugClient().addMessage("shootM");
        if( wm.ball().inertiaPoint( self_min ).x > -52.0 )
        {
            rcsc::Body_Intercept().execute( agent );
        }
        else
        {
            rcsc::Vector2D move_point = rcsc::Line2D( wm.ball().pos(), wm.ball().inertiaFinalPoint() ).intersection(
                rcsc::Line2D( rcsc::Vector2D( -52.5, -9.0 ), rcsc::Vector2D( -52.5, 9.0 ) ) );
            int cycle = 1;
            for( int i = 1; i < 15; i++ )
            {
                if( wm.ball().inertiaPoint( i ).dist( wm.self().pos() ) < move_point.dist( wm.self().pos() ) )
                {
                    move_point = wm.ball().inertiaPoint( i );
                    cycle = i;
                }
                else
                {
                    break;
                }
            }
            Opuci_Move( move_point, SP.maxDashPower() ).execute( agent );
            rcsc::Neck_TurnToBallOrScan().execute( agent );
            return true;
        }
    }

    //danger area situation
    if( danger_mode )
    {
        agent->debugClient().addMessage("dangerM");
        const rcsc::Line2D opp_line( base_pos, goal_side );
        if( wm.self().pos().dist( base_pos ) < 3.0
            && opp_line.dist( wm.self().pos() ) < 1.0 )
        {
            mark_home_pos = base_pos;
            dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
            dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
            if ( dist_thr < 0.5 ) dist_thr = 0.5;
            agent->setIntention( new Opuci_IntentionDash( mark_home_pos, 3, dash_power, dist_thr ) );
        }
        else if( self_nearest_to_ball )
        {
            agent->debugClient().addMessage("chaseOpp");
            if( opp_line.dist( wm.self().pos() ) < 1.0 )
            {
                mark_home_pos = base_pos;
            }
            else if( opp_pos.absY() > wm.self().pos().absY() )
            {
                mark_home_pos.x = opp_line.getX( wm.self().pos().y );
                mark_home_pos.y = wm.self().pos().y;
            }
            else
            {
                mark_home_pos = goal_side;
                dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
                dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
                if ( dist_thr < 0.5 ) dist_thr = 0.5;
                agent->setIntention( new Opuci_IntentionDash( mark_home_pos, 2, dash_power, dist_thr ) );
            }
        }
        else
        {
            if( wm.opponent( opp_unum ) )
            {
                rcsc::Line2D opp_line = rcsc::Line2D( opp_pos, goal_side );
                mark_home_pos.x = std::max( opp_fw_1st_x, -47.0 );
                mark_home_pos.y = opp_line.getY( std::max( opp_fw_1st_x, -47.0 ) );
            }
            else if( opp_fw_1st_x < wm.self().pos().x )
            {
                mark_home_pos.x = std::max( opp_fw_1st_x, -47.0 );
                mark_home_pos.y = 6.0 * ( M_home_pos.y / M_home_pos.absY() );
            }
            else
            {
                if( wm.self().unum() == 4 )
                {
                    rcsc::Line2D base_line( base_pos, rcsc::Vector2D( -SP.pitchHalfLength(), -6.0 ) );
                    mark_home_pos.x = std::max( opp_fw_1st_x, -47.0 );
                    mark_home_pos.y = base_line.getY( std::max( opp_fw_1st_x, -47.0 ) );
                    if( mark_home_pos.y < -15.0 )
                    {
                        mark_home_pos.y = -15.0;
                    }
                    else if( mark_home_pos.y > -4.0 )
                    {
                        mark_home_pos.y = -4.0;
                    }
                }
                else if( wm.self().unum() == 5 )
                {
                    rcsc::Line2D base_line( base_pos, rcsc::Vector2D( -SP.pitchHalfLength(), 6.0 ) );
                    mark_home_pos.x = std::max( opp_fw_1st_x, -47.0 ) - 1.0;
                    mark_home_pos.y = base_line.getY( std::max( opp_fw_1st_x, -47.0 ) );
                    if( mark_home_pos.y < 4.0 )
                    {
                        mark_home_pos.y = 4.0;
                    }
                    else if( mark_home_pos.y > 15.0 )
                    {
                        mark_home_pos.y = 15.0;
                    }
                }
                else
                {
                    mark_home_pos = home_pos;
                }
            }
        }
    }
    //mark opponent get ball
    else if( fastest == opp_unum )
    {
        //chase from back
        if( wm.self().pos().x > base_pos.x )
        {
            if( opp_pos.absY() > wm.self().pos().absY() )
            {
                mark_home_pos.x = base_pos.x;
                mark_home_pos.y = wm.self().pos().y;
            }
            else
            {
                mark_home_pos = goal_side;
                dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
                dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
                if ( dist_thr < 0.5 ) dist_thr = 0.5;
                agent->setIntention( new Opuci_IntentionDash( mark_home_pos, 5, dash_power, dist_thr ) );
            }
            agent->debugClient().addMessage( "chaseFromBack" );
        }
        //chase from front
        else if( goal_side.dist( wm.self().pos() ) < goal_side.dist( opp_pos ) )
        {
            //const rcsc::Line2D opp_line( opp_pos, goal_side );
            const rcsc::Line2D opp_line( opp_pos, rcsc::Vector2D( -52.5, opp_pos.y ) );
            if( opp_line.dist( wm.self().pos() ) < 1.0 )
            {
                mark_home_pos = base_pos;
            }
            else
            {
                mark_home_pos = Bhv_defense().defendOpponent( agent, opp_unum, goal_side, home_pos, NULL, 15 );
            }
            agent->debugClient().addMessage( "chaseFromFront" );
        }
        //yokonarabi situation
        else
        {
            mark_home_pos = home_pos;
            agent->debugClient().addMessage( "Yokonarabi" );
        }
    }
    //return gaol
    else if( opp_fw_1st_x < wm.self().pos().x )
    {
        mark_home_pos.x = opp_fw_1st_x - 5.0;
        mark_home_pos.y = home_pos.y;
        if( base_pos.y > 0.0 )
        {
            if( wm.self().unum() == 4 )
            {
                mark_home_pos.y = -6.0;
            }
        }
        else if( base_pos.y < 0.0 )
        {
            if( wm.self().unum() == 5 )
            {
                mark_home_pos.y = 6.0;
            }
        }
        agent->debugClient().addMessage("returnGoal");
    }
    //normal move
    else
    {
        mark_home_pos = home_pos;
        agent->debugClient().addMessage("NormalMove");
    }

    dash_power = Bhv_defense().getDashPower( agent, mark_home_pos );
    dist_thr = mark_home_pos.dist( wm.self().pos() ) * 0.3;
    if ( dist_thr < 0.5 ) dist_thr = 0.5;
    agent->debugClient().setTarget( mark_home_pos );
    if( ! Opuci_Move( mark_home_pos, dash_power, dist_thr ).execute( agent ) )
    {
        if( wm.opponent( opp_unum ) )
        {
            rcsc::Body_TurnToPoint( opp_pos ).execute( agent );
        }
        else
        {
            agent->doTurn( 180.0 );
        }
    }
    Opuci_Neck().exewithmark( agent, opp_unum );
    return true;
}
