// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef BHV_SET_PLAY_H
#define BHV_SET_PLAY_H

#include <rcsc/geom/vector_2d.h>
#include <rcsc/player/soccer_action.h>
#include <vector>
class Bhv_SetPlay
    : public rcsc::SoccerBehavior {
private:
    const rcsc::Vector2D M_home_pos;
    static bool S_kicker_canceled;
public:
    Bhv_SetPlay( const rcsc::Vector2D & home_pos )
        : M_home_pos( home_pos )
      { }

    bool execute( rcsc::PlayerAgent * agent );

    static
    double get_set_play_dash_power( const rcsc::PlayerAgent * agent );

private:
    void doBasicTheirSetPlayMove( rcsc::PlayerAgent * agent,
                                  const rcsc::Vector2D & target_point );
    bool isKicker( const rcsc::PlayerAgent * agent );
    bool doKickOffMove( rcsc::PlayerAgent * agent );
    bool doKickOff( rcsc::PlayerAgent * agent );
    bool doGoalKickMove( rcsc::PlayerAgent * agent );
    bool doGoalKick( rcsc::PlayerAgent * agent );
    bool doKickInMove( rcsc::PlayerAgent * agent );
    bool doKickIn( rcsc::PlayerAgent * agent );
    bool doFreeKickMove( rcsc::PlayerAgent * agent );
    bool doFreeKick( rcsc::PlayerAgent * agent );
    bool doIndirectFreeKickMove( rcsc::PlayerAgent * agent );
    bool doIndirectFreeKick( rcsc::PlayerAgent * agent );
    bool goToStaticBall( rcsc::PlayerAgent * agent, rcsc::AngleDeg ball_place_angle );
    bool prepareSetPlayKick( rcsc::PlayerAgent * agent, rcsc::AngleDeg ball_place_angle, int wait_cycle );

    bool doCornerKickMove( rcsc::PlayerAgent * agent );
    bool doCornerKick( rcsc::PlayerAgent * agent );
    rcsc::Vector2D getMovePos( rcsc::PlayerAgent * agent );
    rcsc::Vector2D getKickPos( const rcsc::PlayerAgent * agent, int & receiver );
    double getBestSpeed( double dist );
    void setCandidates( rcsc::Vector2D base_pos, std::vector< rcsc::Vector2D > & candidates );
    rcsc::Vector2D getMiddleMovePos( const rcsc::PlayerAgent * agent );
    rcsc::Vector2D getMiddleKickPos( const rcsc::PlayerAgent * agent, int & receiver );
};

#endif
