#ifndef BHV_SHOOTCHANCE_H
#define BHV_SHOOTCHANCE_H

#include <rcsc/player/soccer_action.h>
#include <rcsc/player/world_model.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/vector_2d.h>

class Bhv_Shootchance
    : public rcsc::SoccerBehavior {
 private:
      const rcsc::Vector2D M_target_point;
      
 public:
      Bhv_Shootchance( const rcsc::Vector2D target_point)
          : M_target_point( target_point )
      { }
      bool execute( rcsc::PlayerAgent * agent );
      bool checkDribbleSafe( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos, int dash_cycle );
      bool existTri( rcsc::PlayerAgent * agent, rcsc::Vector2D player_pos );
 private:
      bool doKick( rcsc::PlayerAgent * agent );
      bool doMove( rcsc::PlayerAgent * agent );
      double dashPower( rcsc::PlayerAgent * agent,
			const double limit_power = rcsc::ServerParam::i().maxPower() );
      bool neckToMate( rcsc::PlayerAgent * agent );
      double setFormationPos( rcsc::PlayerAgent * agent, std::vector< rcsc::Vector2D > & candidates );
      bool holdBall( rcsc::PlayerAgent * agent );
      bool holdBall( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos );
      bool testPass( rcsc::PlayerAgent * agent, rcsc::Vector2D & target_pos, int & mate_unum, bool allow_back );
      bool checkPassSafe( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos, rcsc::PlayerObject * receiver, int & opp_cycle );

      bool doSelfPass( rcsc::PlayerAgent * agent, rcsc::AngleDeg angle, int dash_cycle );
      rcsc::Vector2D getPosition( const rcsc::WorldModel & wm, const int unum );


      void doKick_inProgress( rcsc::PlayerAgent *agent ); //　doKick と置き換える予定
      void kickaction( rcsc::PlayerAgent *agent );
      bool canDribble2GoalieWhenFrontier( rcsc::PlayerAgent *agent );

      static int M_passMate;
      static int M_neck_cnt;
};

#endif
