#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bhv_simple_dribble.h"
#include "opuci_move.h"
#include "opuci_search_ball.h"
#include "opuci_kick.h"
#include "opuci_dribble.h"
#include "opuci_shoot.h"
#include "opuci_intercept_cycle.h"
#include "opuci_chase_ball.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/common/say_message_parser.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/vector_2d.h>
#include <rcsc/geom/angle_deg.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_SimpleDribble::execute( rcsc::PlayerAgent * agent )
{
  rcsc::dlog.addText( rcsc::Logger::TEAM,
		      "%s:%d:Bhv_SimpleDribble"
		      ,__FILE__, __LINE__ );

  const rcsc::WorldModel & wm = agent->world();
  const rcsc::ServerParam & SP = rcsc::ServerParam::i();
  static bool is_memorized = false;
  static rcsc::Vector2D r_pos;

  int self_cycle = Opuci_InterceptCycle().selfCycle( agent );
  int mate_cycle = Opuci_InterceptCycle().mateCycle( agent );
  int nearest_mate = Opuci_InterceptCycle().nearestMate( agent );

  if( ! is_memorized )
    {
      r_pos = wm.self().pos();
      is_memorized = true;
    }

  if( wm.self().pos().dist( wm.ball().pos() ) <= wm.self().playerType().kickableArea() )
    {
      if( wm.ball().pos().x > 35.0 )
	{
	  Opuci_Shoot().execute( agent );
	}
      else
	{
	  rcsc::Vector2D target_pos( SP.pitchHalfLength(), wm.self().pos().y );
	  Opuci_Dribble( target_pos, 2 ).execute( agent );
	}
    }
  else
    {
      const rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();

      if( self_cycle <= mate_cycle )
      {
          int self_min = Opuci_ChaseBall().selfCycle( agent );
	  const double dash_power = SP.maxPower();
	  Opuci_Move( wm.ball().inertiaPoint( self_min ), dash_power ).execute( agent );
      }
      else
	{
	  rcsc::Vector2D home_pos = wm.ball().pos() + r_pos;
	  home_pos.x = wm.ball().pos().x + ( r_pos.x * 2.0 + 30.0 ) - 1.0 / 2.0 * wm.ball().pos().x;
          home_pos.x = std::min( home_pos.x, wm.offsideLineX() );
	  home_pos.y = r_pos.y;
	  double dash_power = SP.maxPower() * 0.7;
	  if( wm.ball().pos().x < -30.0 )
	    {
	      dash_power = SP.maxPower();
	    }
	  Opuci_Move( home_pos, dash_power ).execute( agent );
	}
      
      const rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
      const rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();
      agent->doTurnNeck( ( next_ball_pos - next_self_pos ).th() - ( wm.self().neck() + next_self_body ) );
    }

  if( wm.ball().rposCount() < 1 )
    {
      rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
      rcsc::Vector2D next_ball_vel = wm.ball().vel() * SP.ballDecay();
      agent->addSayMessage( new rcsc::BallPlayerMessage( next_ball_pos, 
							 next_ball_vel,
							 wm.self().unum(),
							 wm.self().pos(),
							 wm.self().body() ) );
      agent->doAttentiontoOff();
    }
  else
    {
      if( wm.teammate( nearest_mate ) )
	{
	  agent->doAttentionto( wm.teammate( nearest_mate )->side(),
				wm.teammate( nearest_mate )->unum() );
	}
      agent->addSayMessage( new rcsc::OnePlayerMessage( wm.self().unum(), wm.self().pos() ) );
    }

  agent->debugClient().addMessage("self:%d,mate:%d", self_cycle, mate_cycle );
  agent->debugClient().addMessage("posCount:%d",wm.ball().posCount());

  return true;
}
