#include "experiment.h"
#include <fstream>

#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/common/audio_memory.h>
#include <rcsc/geom/ray_2d.h>

#include <cstring>

rcsc::Vector2D Experiment::ball_pos = rcsc::Vector2D( 0.0, 0.0 );
rcsc::Vector2D Experiment::mate_pos[5] = {
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 )
};
rcsc::Vector2D Experiment::opp_pos[11] = {
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
    rcsc::Vector2D( 0.0, 0.0 ),
};

std::vector<long> Experiment::game_time;
std::vector<int> Experiment::mate_cycle[3];
std::vector<int> Experiment::opp_cycle[3];
std::vector<bool> Experiment::kick_to_mate[3];

std::vector<long> Experiment::game_time_intercept;
std::vector<int> Experiment::pass_success;

Neuro< 6, 15, 3 > Experiment::nur( 0.01, 0.01 );

/*-------------------------------------------------------------------*/
/*!
パス予測が失敗したときデータを記録するための関数
*/
bool
Experiment::getData( const rcsc::PlayerAgent * agent,
                     const int passer, const int receiver )
{
    const rcsc::WorldModel & wm = agent->world();

/*
    const rcsc::Vector2D goal_pos( 51.5, 0.0 );
    const rcsc::AngleDeg angle_to_goal = ( goal_pos - ball_pos ).th();
    const rcsc::Line2D offense_line( ball_pos, angle_to_goal + 90.0 );

    int front_mate_count = 0;

    const rcsc::PlayerPtrCont & mates = wm.teammatesFromBall();
    for( rcsc::PlayerPtrCont::const_iterator mate = mates.begin();
         mate != mates.end();
         ++mate )
    {
        if( ( offense_line.a() * (*mate)->pos().x + offense_line.b() * (*mate)->pos().y + offense_line.c() )
            * ( offense_line.a() * goal_pos.x + offense_line.b() * goal_pos.y + offense_line.c() ) > 0.0
            && (*mate) != mates.front() )
        {
            front_mate_count++;
        }
    }

    if ( wm.audioMemory().passTime() == wm.time()
         && ! wm.audioMemory().pass().empty()
         && wm.audioMemory().pass().front().sender_ >= 7
         && front_mate_count >= 3 )
*/
    //攻撃を担当するプレイヤかパサーの場合
    if( passer >= 7 )
    {
        //パスが発生した時間を記録
        game_time.push_back( wm.time().cycle() );

        //cycle to mate
        //パサーが7か8の場合，前のプレイヤは9,11,10
        int num[3] = { 9, 11, 10};
        //パサーが9の場合，前のプレイヤは7,11,10
        if( passer == 9 )
        {
            num[0] = 7;
        }
        //パサーが10の場合，前のプレイヤは7,11,8
        else if( passer == 10 )
        {
            num[2] = 8;
        }
        //パサーが11の場合，前のプレイヤは7,9,10
        else if( passer == 11 )
        {
            num[0] = 7;
            num[1] = 9;
        }

        for( int i = 0; i < 3; i++ )
        {
            //レシーバとなりうる味方へのパスサイクル数を計算
            int cycle_to_mate = cycleToMate( ball_pos, mate_pos[ num[i] - 7 ] );
            mate_cycle[i].push_back( cycle_to_mate );

            //その味方を妨害する敵の妨害サイクル数を計算
            int min_opp_cycle = 10;
            const rcsc::PlayerPtrCont & opps = wm.opponentsFromBall();
            for( rcsc::PlayerPtrCont::const_iterator opp = opps.begin();
                 opp != opps.end();
                 ++opp )
            {
                int cycle_to_opp = cycleToOpp( ball_pos, mate_pos[ num[i] - 7 ],
                                               opp_pos[ (*opp)->unum() - 1 ], (*opp) );
                
                if( cycle_to_opp < min_opp_cycle )
                {
                    min_opp_cycle = cycle_to_opp;
                }
            }
            opp_cycle[i].push_back( min_opp_cycle );

            //その味方にパスされていた場合trueを記録
            if( receiver == num[i] )
            {
                kick_to_mate[i].push_back( true );
            }
            //その味方にパスされていなかった場合falseを記録
            else
            {
                kick_to_mate[i].push_back( false );
            }
        }
    }

    return true;
}
/*-------------------------------------------------------------------*/
/*!
ボール，味方，敵の位置情報を更新
*/
void
Experiment::updateCycle( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();

    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: update_cycle_exp"
                        ,__FILE__, __LINE__ );
    //ボールの位置を更新
    if( wm.ball().pos().valid() )
    {
        ball_pos = wm.ball().pos();
    }
    //味方の位置を更新
    for( int num = 7; num <= 11; num++ )
    {
        if( wm.teammate( num ) )
        {
            mate_pos[ num - 7 ] = wm.teammate( num )->pos();
        }
        else
        {
            mate_pos[ num - 7 ] = rcsc::Vector2D( 1000.0, 0.0 );
        }
    }
    //敵の位置を更新
    for( int num = 1; num <= 11; num++ )
    {
        if( wm.opponent( num ) )
        {
            opp_pos[ num - 1 ] = wm.opponent( num )->pos();
        }
        else
        {
            opp_pos[ num - 1 ] = rcsc::Vector2D( 1000.0, 0.0 );
        }
    }
    //agent->debugClient().addMessage("expCyc");

    return;
}
/*-------------------------------------------------------------------*/
/*!
自分がパスレシーバであるかどうかを予測する
*/
bool
Experiment::passedToMe( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();

    const rcsc::Vector2D goal_pos( 51.5, 0.0 ); //相手のゴール
    const rcsc::AngleDeg angle_to_goal = ( goal_pos - wm.ball().pos() ).th();
    const rcsc::Line2D offense_line( wm.ball().pos(), angle_to_goal + 90.0 ); 

    int front_mate_count = 0;

    const rcsc::PlayerPtrCont & mates = wm.teammatesFromBall();
    //自分の前に何人味方がいるかを数える．3人以上いる場合，攻撃フォーメーションになっているとみなす
    for( rcsc::PlayerPtrCont::const_iterator mate = mates.begin();
         mate != mates.end();
         ++mate )
    {
        //味方がボールより前方にいるか判定
        if( ( offense_line.a() * (*mate)->pos().x + offense_line.b() * (*mate)->pos().y + offense_line.c() )
            * ( offense_line.a() * goal_pos.x + offense_line.b() * goal_pos.y + offense_line.c() ) > 0.0
            && (*mate) != mates.front() )
        {
            front_mate_count++;
        }
    }
    //自分がボールより前方にいるか判定
    if( ( offense_line.a() * wm.self().pos().x + offense_line.b() * wm.self().pos().y + offense_line.c() )
        * ( offense_line.a() * goal_pos.x + offense_line.b() * goal_pos.y + offense_line.c() ) > 0.0 )
    {
        front_mate_count++;
    }

    //攻撃を担当するプレイヤがボールを持っている場合
    if( wm.existKickableTeammate() )
    {
      if( wm.getTeammateNearestToBall( 100 ) )
      {
        if( wm.getTeammateNearestToBall( 100 )->unum() >= 7
            && front_mate_count >= 3 )
        {
            double input[6];

            //cycle to mate
            //ボールを持っているプレイヤが7か8の場合，前のプレイヤは9,11,10
            int num[3] = { 9, 11, 10};
            //ボールを持っているプレイヤが9の場合，前のプレイヤは7,11,10
            if( wm.getTeammateNearestToBall( 100 )->unum() == 9 )
            {
                num[0] = 7;
            }
            //ボールを持っているプレイヤが10の場合，前のプレイヤは9,11,8
            else if( wm.getTeammateNearestToBall( 100 )->unum() == 10 )
            {
                num[2] = 8;
            }
            //ボールを持っているプレイヤが11の場合，前のプレイヤは7,9,10
            else if( wm.getTeammateNearestToBall( 100 )->unum() == 11 )
            {
                num[0] = 7;
                num[1] = 9;
            }

            for( int i = 0; i < 3; i++ )
            {
                if( wm.teammate( num[i] ) )
                {
                    //レシーバとなりうる味方へのパスサイクル数を計算
                    int cycle_to_mate = cycleToMate( wm.ball().pos(), wm.teammate( num[i] )->pos() );
                    input[ i * 2 ] = (double)cycle_to_mate * 0.1;

                    //その味方を妨害する敵の妨害サイクル数を計算
                    int min_opp_cycle = 10;
                    const rcsc::PlayerPtrCont & opps = wm.opponentsFromBall();
                    for( rcsc::PlayerPtrCont::const_iterator opp = opps.begin();
                         opp != opps.end();
                         ++opp )
                    {
                        int cycle_to_opp = cycleToOpp( wm.ball().pos(), wm.teammate( num[i] )->pos(),
                                                       (*opp)->pos(), (*opp) );
                    
                        if( cycle_to_opp < min_opp_cycle )
                        {
                            min_opp_cycle = cycle_to_opp;
                        }
                    }
                    input[ i * 2 + 1 ] = (double)min_opp_cycle * 0.1;
                }
                //味方が存在しない場合はサイクル数は最大
                else
                {
                    input[ i * 2 ] = 1.0;
                    input[ i * 2 + 1 ] = 1.0;
                }
            }
            //上で計算した入力信号から出力信号を算出
            double output[3];
            nur.propagate( input, output );
            //自分の番号に対応する出力信号が0.5以上の場合，trueを返す
            for( int i = 0; i < 3; i++ )
            {
                if( wm.self().unum() == num[i]
                    && output[i] > 0.5 )
                {
                    //ボールを取りにいこうとしたサイクル数を記録．ニューロの学習のためのもので，現在は使用していない
                    game_time_intercept.push_back( wm.time().cycle() );
                    return true;
                }
            }
        }
      }
    }
    return false;
}
/*-------------------------------------------------------------------*/
/*!
レシーバ予測が成功しているか失敗しているかを0,1で記録
データを取るためのもので，現在は使用していない
*/
void
Experiment::discrimination( int type )
{
    pass_success.push_back( type );
    return;
}
/*-------------------------------------------------------------------*/
/*!
集めたデータをファイルに書き出す関数．現在は使用していない．
*/
void
Experiment::saveFile( rcsc::PlayerAgent * agent )
{
/*
    int unum = agent->world().self().unum();

    std::ofstream os;
    char st[255];
    sprintf( st, "%s/data%d.txt", filename.c_str(), unum );

    os.open( st, std::ios::out|std::ios::app );
    int i = 0;
    for( std::vector<long>::iterator it = game_time.begin();
         it != game_time.end();
         ++it )
    {
        os<< (*it) << " ";

        for( int j = 0; j < 3; j++ )
        {
            int mate = mate_cycle[j].at( i );
            int opp = opp_cycle[j].at( i );
            os << mate << " " << opp << " ";
        }
        for( int j = 0; j < 3; j++ )
        {
            os << kick_to_mate[j].at( i ) << " ";
        }
        os << "\n";
        i++;
    }
    os << "\n";
    os.close();

    sprintf( st, "%s/pass_success%d.txt", filename.c_str(), unum );
    os.open( st, std::ios::out|std::ios::app );
    for( std::vector<int>::iterator it = pass_success.begin();
         it != pass_success.end();
         ++it )
    {
        os << (*it) << "\n";
    }
    os << "\n";
    os.close();

    sprintf( st, "data/intercept%d.txt", unum );
    os.open( st, std::ios::out|std::ios::app );
    for( std::vector<long>::iterator it = game_time_intercept.begin();
         it != game_time_intercept.end();
         ++it )
    {
        os << (*it) << "\n";
    }
    os << "\n";
    os.close();
*/
    return;
}
/*-------------------------------------------------------------------*/
/*!
指定されたファイルのニューラルネットワークを読み込む
*/
bool
Experiment::setNeuralNet( std::string config_dir )
{
    nur.init();
    std::ifstream fi;
    char st[255];
    sprintf( st, "%s/weight15.txt", config_dir.c_str() );
    fi.open( st );
    if( ! nur.loadfile( fi ) )
    {
        //std::cout<<"no neuro"<<std::endl;
        return false;
    }
    fi.close();
    //std::cout<<"get neuro"<<std::endl;
    return true;
}
/*-------------------------------------------------------------------*/
/*!
ボールが味方に到達するまでのサイクル数を計算する
*/
int
Experiment::cycleToMate( const rcsc::Vector2D ball_pos,
                         const rcsc::Vector2D mate_pos )
{
    double pass_dist = ball_pos.dist( mate_pos ); //ボールと味方との距離
    double ball_speed = 1.2; //ボール他味方に到達した時の速度
    for( int i = 0; i < 10; i++ )
    {
        pass_dist -= ball_speed;
        ball_speed /= rcsc::ServerParam::i().ballDecay();
        if( pass_dist < 0.0 )
        {
            return i;
        }
    }

    return 10;
}

/*-------------------------------------------------------------------*/
/*!
パスが敵に妨害されるまでのサイクル数を計算する
*/
int
Experiment::cycleToOpp( const rcsc::Vector2D ball_pos,
                        const rcsc::Vector2D mate_pos,
                        const rcsc::Vector2D opp_pos,
                        const rcsc::PlayerObject * opp )
{
    const rcsc::Segment2D pass_line( ball_pos, mate_pos ); //ボールと味方を結ぶ直線
    //敵が存在する領域を区切るための直線
    const rcsc::Line2D l1( ball_pos, ( mate_pos - ball_pos ).th() + 90.0 ); //ボールを通り，ボールと味方を結ぶ直線と直交する線
    const rcsc::Line2D l2( mate_pos, ( mate_pos - ball_pos ).th() + 90.0 ); //味方を通り，ボールと味方を結ぶ直線と直交する線

    //指定された領域内に敵が存在するかどうかを判定
    if( ( l1.a() * opp_pos.x + l1.b() * opp_pos.y + l1.c() )
        * ( l1.a() * mate_pos.x + l1.b() * mate_pos.y + l1.c() ) > 0.0
        && ( l2.a() * opp_pos.x + l2.b() * opp_pos.y + l2.c() )
        * ( l2.a() * ball_pos.x + l2.b() * ball_pos.y + l2.c() ) > 0.0 )
    {
        double dist_opp_to_line = pass_line.dist( opp_pos ) - opp->playerTypePtr()->kickableArea();
        //敵がライン上に存在する場合は妨害サイクル数は0
        if( dist_opp_to_line < 0.0 )
        {
            return 0;
        }
        //それ以外の場合はdashDistanceTableから移動距離を計算しサイクル数を算出
        for( int i = 0; i < 10; i++ )
        {
            if( dist_opp_to_line <= opp->playerTypePtr()->dashDistanceTable().at( i ) )
            {
                return i;
            }
        }
    }

    return 10;
}
