#include <rcsc/player/player_agent.h>
#include <rcsc/geom/vector_2d.h>
#include <iostream>
#include <fstream>
#include "neuro.h"

class Experiment{
 private:
  static rcsc::Vector2D ball_pos;
  static rcsc::Vector2D mate_pos[5];
  static rcsc::Vector2D opp_pos[11];

  static std::vector<long> game_time;
  static std::vector<int> mate_cycle[3];
  static std::vector<int> opp_cycle[3];
  static std::vector<bool> kick_to_mate[3];

  static std::vector<long> game_time_intercept;
  static std::vector<int> pass_success;

  static Neuro< 6, 15, 3 > nur;

 public:
  Experiment()
    {}
  bool getData( const rcsc::PlayerAgent * agent,
		const int passer, const int receiver );
  void updateCycle( rcsc::PlayerAgent * agent );
  bool passedToMe( rcsc::PlayerAgent * agent );
  void discrimination( int type );
  void saveFile( rcsc::PlayerAgent * agent );
  bool setNeuralNet( std::string config_dir );

 private:
  int cycleToMate( const rcsc::Vector2D ball_pos,
		   const rcsc::Vector2D mate_pos );
  int cycleToOpp( const rcsc::Vector2D ball_pos,
		  const rcsc::Vector2D mate_pos,
		  const rcsc::Vector2D opp_pos,
		  const rcsc::PlayerObject * opp );

};
