#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_direct_pass.h"
#include "opuci_one_step_kick.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/geom/vector_2d.h>
#include <rcsc/geom/ray_2d.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/action/body_smart_kick.h>
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
bool
Opuci_DirectPass::execute( rcsc::PlayerAgent * agent )
{

    const rcsc::WorldModel & wm = agent->world();
    if( !wm.self().isKickable() )
    {
        return false;
    }
    rcsc::Vector2D pass_target;
    double first_speed;
    rcsc::PlayerPtrCont::const_iterator end = wm.teammatesFromSelf().end();
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end;
         ++it )
    {
        // まず前方の味方のみを対象
        if( (*it)->pos().x < wm.self().pos().x )
            continue;

        // 近すぎるのも除外
        if( wm.self().pos().dist( (*it)->pos() ) < 3.0 )
            continue;

        // posCount が大きいものも除外 とりあえず４以上
        if( (*it)->posCount() > 3 )
            continue;

        const rcsc::PlayerObject * receiver = (*it);
        if( search( agent, receiver, pass_target, first_speed ) )
        {
            agent->debugClient().setTarget( pass_target );
            if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
            {
                agent->debugClient().addMessage( "Target%d", receiver->unum() );
                agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                             agent->effector().queuedNextBallPos(),
                                                             agent->effector().queuedNextBallVel() ) );
            }            
            return true;
        }
    }
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end;
         ++it )
    {
        // 後方の味方のみを対象
        if( (*it)->pos().x > wm.self().pos().x )
            continue;

        // 近すぎるのも除外
        if( wm.self().pos().dist( (*it)->pos() ) < 3.0 )
            continue;

        // posCount が大きいものも除外 とりあえず４以上
        if( (*it)->posCount() > 3 )
            continue;

        const rcsc::PlayerObject * receiver = (*it);
        if( search( agent, receiver, pass_target, first_speed ) )
        {
            agent->debugClient().setTarget( pass_target );
            if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
            {
                agent->debugClient().addMessage( "Target%d", receiver->unum() );
                agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                             agent->effector().queuedNextBallPos(),
                                                             agent->effector().queuedNextBallVel() ) );
            }            
            return true;
        }
    }
    
    
    

    return false;
}
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
bool
Opuci_DirectPass::execute( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * receiver )
{

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();
    if( !wm.self().isKickable() )
    {
        return false;
    }
    rcsc::Vector2D pass_target;
    double first_speed;
    if( search( agent, receiver, pass_target, first_speed ) )
    {

    }
    else
    {
        pass_target = receiver->pos();
        pass_target.x += wm.self().pos().dist( receiver->pos() ) / 10.0;
        first_speed = sp.ballSpeedMax();
    }

    agent->debugClient().setTarget( pass_target );
    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
    {
        agent->debugClient().addMessage( "Target%d", receiver->unum() );
        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                     agent->effector().queuedNextBallPos(),
                                                     agent->effector().queuedNextBallVel() ) );

    }            
    return true;
}
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
bool 
Opuci_DirectPass::search( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * receiver, 
                           rcsc::Vector2D & target_pos, double & kick_power, rcsc::AngleDeg & kick_angle )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();


    if( receiver->pos().x > wm.offsideLineX() )
    {
        return false;
    }

    int inertial_cycle = 1;

    rcsc::Vector2D inertial_mate_pos = receiver->playerTypePtr()->inertiaPoint( receiver->pos(), 
                                                                                receiver->vel(), 
                                                                                inertial_cycle );

    std::vector< rcsc::Vector2D > candidates;
    candidates.push_back( inertial_mate_pos );
    rcsc::Vector2D r( 2.0, 0 );
    r.rotate( receiver->body() );
    if( inertial_mate_pos.dist( wm.self().pos() ) < 10 )
    {
        r.setLength( 1.0 );
    }
    for( int i = 60; i >= -60; i -= 10 )
    {
        rcsc::Vector2D tmp = inertial_mate_pos + r.rotatedVector( i );
        if( tmp.x > inertial_mate_pos.x )
        {
            candidates.push_back( tmp );
        }
    }
    rcsc::Vector2D tmp_target;
    int cycle_margin = 0;
    double tmp_power = 0;
    rcsc::AngleDeg tmp_angle = 0;
    rcsc::Vector2D tmp_ball_vel, target_vel;
    int type = -1, tmp_type;
    for( int i = 0; i < (int)candidates.size(); i++ )
    {
        rcsc::Vector2D ball_to_cand = candidates.at( i ) - wm.ball().pos();
        rcsc::Vector2D mate_to_cand = candidates.at( i ) - receiver->pos();
        rcsc::AngleDeg mate_angle_dif = mate_to_cand.th() - receiver->body();
        int mate_turn_cycle = 1;
        if( mate_angle_dif.abs() < 5 )
        {
            mate_turn_cycle = 0;
        }
        else if( mate_angle_dif.abs() > 60 )
        {
            mate_turn_cycle = 2;
        }
        else if( mate_angle_dif.abs() > 120 )
        {
            mate_turn_cycle = 3;
        }
        double mate_dist = candidates.at( i ).dist( receiver->playerTypePtr()->inertiaPoint( receiver->pos(), 
                                                                                             receiver->vel(), 
                                                                                             mate_turn_cycle ) );
        int mate_reach_cycle = mate_turn_cycle + receiver->playerTypePtr()->cyclesToReachDistance( mate_dist );
        
        double ball_first_speed = rcsc::calc_first_term_geom_series( ball_to_cand.r(), 
                                                                     sp.ballDecay(),
                                                                     mate_reach_cycle + 1 );
        if( ball_first_speed > sp.ballSpeedMax() )
        {
            ball_first_speed = sp.ballSpeedMax();
        }
        tmp_ball_vel.setPolar( ball_first_speed, ball_to_cand.th() );
        rcsc::Vector2D accel = tmp_ball_vel - wm.ball().vel();
        double power = accel.r() / wm.self().kickRate();
        rcsc::AngleDeg angle = accel.th();
        if( power > sp.maxPower() )
        {
            power = sp.maxPower();
            rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
            rcsc::Circle2D kick_power_circle( next_ball_pos, power * wm.self().kickRate() );
            rcsc::Line2D ball_line( wm.ball().pos(), candidates.at( i ) );
            rcsc::Vector2D kick_target, sol1, sol2;
            int intersection = kick_power_circle.intersection( ball_line, &sol1, &sol2 );
            if( intersection < 1 )
            {
                kick_target = candidates.at( i );
                tmp_type = 1;
            }
            else if( intersection == 1 )
            {
                kick_target = sol1;
                tmp_type = 2;
            }
            else
            {
                tmp_type = 3;
                if( candidates.at( i ).dist2( sol1 ) < candidates.at( i ).dist2( sol2 ) )
                {
                    kick_target = sol1;
                }
                else
                {
                    kick_target = sol2;
                }
            }
            angle = ( kick_target - next_ball_pos ).th();
        }
        else
        {
            tmp_type = 0;
        }
        accel.setPolar( wm.self().kickRate() * power, angle );
        tmp_ball_vel = wm.ball().vel() + accel;
        ball_first_speed = tmp_ball_vel.r();
        if( rcsc::calc_length_geom_series( ball_first_speed, ball_to_cand.r(), sp.ballDecay() ) > 15 )
        {
            continue;
        }
        bool success = true;
        int opp_min_cycle = 100;
        rcsc::Segment2D pass_seg( wm.ball().pos(), candidates.at( i ) );
        const rcsc::PlayerPtrCont::const_iterator opp_end = wm.opponentsFromSelf().end();
        for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
             it != opp_end;
             ++it )
        {
            if( (*it)->isTackling() )
                continue;
            
            rcsc::Vector2D inertial_opp_pos = (*it)->playerTypePtr()->inertiaPoint( (*it)->pos(),
                                                                                    (*it)->vel(),
                                                                                    mate_reach_cycle );
            rcsc::Circle2D opp_area( (*it)->pos(), (*it)->playerTypePtr()->kickableMargin() );
            rcsc::Circle2D opp_area2( inertial_opp_pos, (*it)->playerTypePtr()->kickableMargin() );
            if( opp_area.intersection( pass_seg, NULL, NULL ) > 0
                || opp_area2.intersection( pass_seg, NULL, NULL ) > 0 )
            {
                success = false;
                break;
            }
            double opp_dist = pass_seg.dist( inertial_opp_pos );
            opp_dist -= (*it)->playerTypePtr()->kickableMargin();
            if( opp_dist <= 0 )
            {
                success = false;
                break;
            }
            int opp_dash = (*it)->playerTypePtr()->cyclesToReachDistance( opp_dist );
            int opp_turn = 1;
            int opp_reach_cycle = opp_dash + opp_turn;
            
            rcsc::Vector2D opp_target = pass_seg.nearestPoint( inertial_opp_pos );
            double ball_dist = wm.ball().pos().dist( opp_target );
            int ball_through_cycle = rcsc::calc_length_geom_series( ball_first_speed, 
                                                                    ball_dist,
                                                                    sp.ballDecay() );
            if( ball_through_cycle < 0 
                || ball_through_cycle >= opp_reach_cycle - 1 )
            {
                success = false;
                break;
            }
            if( opp_reach_cycle < opp_min_cycle )
            {
                opp_min_cycle = opp_reach_cycle;
            }
        }//end for oppsfromself
        if( success && opp_min_cycle > cycle_margin )
        {
            cycle_margin = opp_min_cycle;
            tmp_target = candidates.at( i );
            tmp_power = power;
            tmp_angle = angle;
            target_vel = tmp_ball_vel;
            type = tmp_type;
        }
    }//end for candidates
    if( cycle_margin > 0 )
    {
        agent->debugClient().addMessage( "CanDirectPass" );
        target_pos = tmp_target;
        kick_power = tmp_power;
        kick_angle = tmp_angle - wm.self().body();
        rcsc::Vector2D rpos = target_pos - wm.ball().pos();

        return true;
    }
    return false;
}
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
bool 
Opuci_DirectPass::search( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * receiver, 
                           rcsc::Vector2D & target_pos, double & first_speed )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();


    if( receiver->pos().x > wm.offsideLineX() )
    {
        return false;
    }

    int inertial_cycle = 1;

    rcsc::Vector2D inertial_mate_pos = receiver->playerTypePtr()->inertiaPoint( receiver->pos(), 
                                                                                receiver->vel(), 
                                                                                inertial_cycle );

    std::vector< rcsc::Vector2D > candidates;
    candidates.push_back( inertial_mate_pos );
    rcsc::Vector2D r( 2.0, 0 );
    r.rotate( receiver->body() );
    if( inertial_mate_pos.dist( wm.self().pos() ) < 10 )
    {
        r.setLength( 1.0 );
    }
    for( int i = 60; i >= -60; i -= 10 )
    {
        rcsc::Vector2D tmp = inertial_mate_pos + r.rotatedVector( i );
        if( tmp.x > inertial_mate_pos.x )
        {
            candidates.push_back( tmp );
        }
    }
    rcsc::Vector2D tmp_target;
    double tmp_first_speed = 0;
    int cycle_margin = 0;

    for( int i = 0; i < (int)candidates.size(); i++ )
    {
        rcsc::Vector2D ball_to_cand = candidates.at( i ) - wm.ball().pos();
        rcsc::Vector2D mate_to_cand = candidates.at( i ) - receiver->pos();
        rcsc::AngleDeg mate_angle_dif = mate_to_cand.th() - receiver->body();
        int mate_turn_cycle = 1;
        if( mate_angle_dif.abs() < 5 )
        {
            mate_turn_cycle = 0;
        }
        else if( mate_angle_dif.abs() > 60 )
        {
            mate_turn_cycle = 2;
        }
        else if( mate_angle_dif.abs() > 120 )
        {
            mate_turn_cycle = 3;
        }
        double mate_dist = candidates.at( i ).dist( receiver->playerTypePtr()->inertiaPoint( receiver->pos(), 
                                                                                             receiver->vel(), 
                                                                                             mate_turn_cycle ) );
        int mate_reach_cycle = mate_turn_cycle + receiver->playerTypePtr()->cyclesToReachDistance( mate_dist );
        
        double ball_first_speed = rcsc::calc_first_term_geom_series( ball_to_cand.r(), 
                                                                     sp.ballDecay(),
                                                                     mate_reach_cycle + 1 );
        if( ball_first_speed > sp.ballSpeedMax() )
        {
            ball_first_speed = sp.ballSpeedMax();
        }

        if( rcsc::calc_length_geom_series( ball_first_speed, ball_to_cand.r(), sp.ballDecay() ) > 15 )
        {
            continue;
        }
        bool success = true;
        int opp_min_cycle = 100;
        rcsc::Segment2D pass_seg( wm.ball().pos(), candidates.at( i ) );
        const rcsc::PlayerPtrCont::const_iterator opp_end = wm.opponentsFromSelf().end();
        for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
             it != opp_end;
             ++it )
        {
            if( (*it)->isTackling() )
                continue;

            rcsc::Vector2D inertial_opp_pos = (*it)->playerTypePtr()->inertiaPoint( (*it)->pos(),
                                                                                    (*it)->vel(),
                                                                                    mate_reach_cycle );
            rcsc::Circle2D opp_area( (*it)->pos(), (*it)->playerTypePtr()->kickableMargin() );
            rcsc::Circle2D opp_area2( inertial_opp_pos, (*it)->playerTypePtr()->kickableMargin() );
            if( opp_area.intersection( pass_seg, NULL, NULL ) > 0
                || opp_area2.intersection( pass_seg, NULL, NULL ) > 0 )
            {
                success = false;
                break;
            }
            double opp_dist = pass_seg.dist( inertial_opp_pos );
            opp_dist -= (*it)->playerTypePtr()->kickableMargin();
            if( opp_dist <= 0 )
            {
                success = false;
                break;
            }
            int opp_dash = (*it)->playerTypePtr()->cyclesToReachDistance( opp_dist );
            int opp_turn = 1;
            int opp_reach_cycle = opp_dash + opp_turn;
            
            rcsc::Vector2D opp_target = pass_seg.nearestPoint( inertial_opp_pos );
            double ball_dist = wm.ball().pos().dist( opp_target );
            int ball_through_cycle = rcsc::calc_length_geom_series( ball_first_speed, 
                                                                    ball_dist,
                                                                    sp.ballDecay() );
            if( ball_through_cycle < 0 
                || ball_through_cycle >= opp_reach_cycle  )
            {
                success = false;
                break;
            }
            if( opp_reach_cycle < opp_min_cycle )
            {
                opp_min_cycle = opp_reach_cycle;
            }
        }//end for oppsfromself
        if( success && opp_min_cycle > cycle_margin )
        {
            cycle_margin = opp_min_cycle;
            tmp_target = candidates.at( i );
            tmp_first_speed = ball_first_speed;
        }
    }//end for candidates
    if( cycle_margin > 0 )
    {
        agent->debugClient().addMessage( "CanDirectPass" );
        target_pos = tmp_target;
        first_speed = tmp_first_speed;
        return true;
    }
    return false;
}
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
