#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_intention_dash.h"
#include "bhv_defense.h"
#include "opuci_move.h"
#include "opuci_neck.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/common/logger.h>

/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_IntentionDash::finished( const rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    const int self_min = wm.interceptTable()->selfReachCycle();
    const int mate_min = wm.interceptTable()->teammateReachCycle();
    const int opp_min = wm.interceptTable()->opponentReachCycle();

    if( wm.self().pos().dist( M_target_point ) < 1.0 )
    {
        return true;
    }
    else if( M_dash_count <= 0 )
    {
        return true;
    }
    else if( wm.self().isKickable() )
    {
        return true;
    }
    else if( wm.self().tackleProbability() > 0.1 )
    {
        return true;
    }
    else if( wm.existKickableOpponent()
             || wm.existKickableTeammate() )
    {
        return true;
    }
    else if( self_min < mate_min
             && self_min < opp_min )
    {
        return true;
    }
    return false;
}
/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_IntentionDash::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d:Opuci_IntentionDash"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    rcsc::Vector2D target_point = M_target_point;
    if( M_target_point.x < -52.5 )
    {
        target_point.x = -52.5;
    }
    else if( M_target_point.x > 52.5 )
    {
        target_point.x = 52.5;
    }

    if( M_target_point.y < -34.0 )
    {
        target_point.y = -34.0;
    }
    else if( M_target_point.y > 34.0 )
    {
        target_point.y = 34.0;
    }

    if( ! Opuci_Move( target_point, M_dash_power, M_dist_thr ).execute( agent ) )
    {
        agent->doTurn( 180.0 );
    }
    Opuci_Neck().execute( agent );
    M_dash_count--;

    Bhv_defense().defenseMessage( agent );
    Bhv_defense().defenseAttention( agent );
    return true;
}
