#ifndef OPUCI_INTENTION_DASH_H
#define OPUCI_INTENTION_DASH_H

#include <rcsc/player/soccer_intention.h>
#include <rcsc/geom/vector_2d.h>
#include <rcsc/common/server_param.h>

class Opuci_IntentionDash
    : public rcsc::SoccerIntention {
 private:
      rcsc::Vector2D M_target_point;
      int M_dash_count;
      double M_dash_power;
      double M_dist_thr;

 public:
 Opuci_IntentionDash( rcsc::Vector2D target_point, 
		      int dash_count, 
		      double dash_power = rcsc::ServerParam::i().maxDashPower(), 
		      double dist_thr = 1.0 )
   :M_target_point( target_point )
	,M_dash_count( dash_count )
	,M_dash_power( dash_power )
	,M_dist_thr( dist_thr )
	{ }
      bool finished( const rcsc::PlayerAgent * agent );
      bool execute( rcsc::PlayerAgent * agent );

 private:
};

#endif
