#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_intention_dribble.h"
#include "opuci_neck.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/action/body_intercept2009.h>
/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_IntentionDribble::finished( const rcsc::PlayerAgent * agent )
{
    if( M_dash_count <= 0 )
    {
        return true;
    }
    return false;
}
/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_IntentionDribble::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::KICK,
                        "%s:%d:Opuci_IntentionDribble"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
    
    if( M_dash_count <= 0 )
    {
        return false;
    }

    if( !wm.self().isKickable() 
        && wm.existKickableOpponent() )
    {
        agent->debugClient().addMessage( "StopIntDrib" );
        M_dash_count = 0;
        return false;
    }
    if( wm.self().playerType().cyclesToReachDistance( wm.ball().pos().dist( wm.self().pos() ) ) > M_dash_count + 2 )
    {
        agent->debugClient().addMessage( "BallTooFar" );
        M_dash_count = 0;
        return false;
    }


    const rcsc::PlayerType & PT = wm.self().playerType();
    const double dash_power = dashPower( agent );

    const rcsc::Line2D body_right_line( rcsc::Vector2D( wm.self().pos().x + PT.kickableArea() * wm.self().body().sin(),
                                                        wm.self().pos().y - PT.kickableArea() * wm.self().body().cos() ),
                                        wm.self().body() );
    const rcsc::Line2D body_left_line( rcsc::Vector2D( wm.self().pos().x - PT.kickableArea() * wm.self().body().sin(),
                                                       wm.self().pos().y + PT.kickableArea() * wm.self().body().cos() ),
                                       wm.self().body() );

    const double target_inside =
        ( body_right_line.getA() * M_target_point.x + body_right_line.getB() * M_target_point.y + body_right_line.getC() )
        * ( body_left_line.getA() * M_target_point.x + body_left_line.getB() * M_target_point.y + body_left_line.getC() );
    agent->debugClient().addMessage("DL%.2f", wm.self().dashRate() );
    if( target_inside <= 0.0
        && fabs( ( wm.self().body() - rcsc::Vector2D( M_target_point - wm.self().pos() ).th() ).degree() ) < 90.0 )
    {
        if( wm.self().isKickable() )
        {
            /* 一回ダッシュすると仮定して次の位置を計算 */
            rcsc::Vector2D dash_vec( wm.self().dashRate() * dash_power, 0 );
            dash_vec.rotate( wm.self().body() );
            rcsc::Vector2D tmp_next = wm.self().vel() + dash_vec;
            if( tmp_next.r() > wm.self().playerType().playerSpeedMax() )
                tmp_next.setLength( wm.self().playerType().playerSpeedMax() );
            tmp_next += wm.self().pos();
	  
            rcsc::Circle2D next_self_kickable( tmp_next, wm.self().kickableArea() );
            rcsc::Circle2D next_self_size( tmp_next, wm.self().playerTypePtr()->playerSize() );
            rcsc::Circle2D next_ball_size( next_ball_pos, rcsc::ServerParam::i().ballSize() );
            if( next_self_kickable.contains( next_ball_pos )
                || next_self_size.contains( next_ball_pos )
                || next_self_size.intersection( next_ball_size, NULL, NULL ) > 0 )
            {
                M_dash_count--;
//                agent->doDash( dash_power*0.5 );
                agent->doDash( dash_power );
                agent->debugClient().addMessage( "opuciIntDribDash:%f", dash_power );
                //	      agent->debugClient().addMessage( "IntDribNoAct1" );
            }
            else
            {
                rcsc::Vector2D self_pos = wm.self().pos();
                rcsc::Vector2D self_vel = wm.self().vel();
                rcsc::Vector2D dash;
                dash.setPolar( wm.self().dashRate() * 100, wm.self().body() );
                bool success = false;
                for( int i = 1; i <= M_dash_count; i++ )
                {
                    self_vel += dash;
                    self_pos += self_vel;
                    rcsc::Circle2D circle( self_pos, wm.self().kickableArea() );
                    if( circle.contains( wm.ball().inertiaPoint( i ) ) )
                    {
                        success = true;
                    }
                    self_vel *= wm.self().playerType().playerDecay();
                }
                if( success )
                {
                    agent->doDash( dash_power );
                    agent->debugClient().addMessage( "opuciIntDribDash:%f", dash_power );
                }
                else
                {
                    agent->debugClient().addMessage( "opuciIntDribIntercept" );
                    rcsc::Body_Intercept2009().execute( agent );
                }
            }
        }
        else
        {
            rcsc::Vector2D self_pos = wm.self().pos();
            rcsc::Vector2D self_vel = wm.self().vel();
            rcsc::Vector2D dash;
            dash.setPolar( wm.self().dashRate() * 100, wm.self().body() );
            bool success = false;
            for( int i = 1; i <= M_dash_count; i++ )
            {
                self_vel += dash;
                self_pos += self_vel;
                rcsc::Circle2D circle( self_pos, wm.self().kickableArea() );
                if( circle.contains( wm.ball().inertiaPoint( i ) ) )
                {
                    success = true;
                }
                self_vel *= wm.self().playerType().playerDecay();
            }
            if( success )
            {
                agent->doDash( dash_power );
                agent->debugClient().addMessage( "opuciIntDribDash:%f", dash_power );
            }
            else
            {
                agent->debugClient().addMessage( "opuciIntDribIntercept" );
                rcsc::Body_Intercept2009().execute( agent );
            }            
        }
    }
    else
    {
        if( wm.self().isKickable() )
        {
            rcsc::Vector2D tmp_next = wm.self().pos() + wm.self().vel();
            rcsc::Circle2D next_self_kickable( tmp_next, wm.self().kickableArea() );
            rcsc::Circle2D next_self_size( tmp_next, wm.self().playerTypePtr()->playerSize() );
            rcsc::Circle2D next_ball_size( next_ball_pos, rcsc::ServerParam::i().ballSize() );
            if( !next_self_kickable.contains( next_ball_pos )
                || next_self_size.contains( next_ball_pos )
                || next_self_size.intersection( next_ball_size, NULL, NULL ) > 0 )
            {
                M_dash_count--;
                agent->debugClient().addMessage( "IntDribNoAct2" );
                return false;
            }
            else
            {
                rcsc::AngleDeg angle = ( M_target_point - ( wm.self().pos() + wm.self().vel() ) ).th() - wm.self().body();
                agent->doTurn( angle );
                agent->debugClient().addMessage( "opuciIntDribTurn" );
            }
        }
        else
        {
            rcsc::AngleDeg angle = ( M_target_point - ( wm.self().pos() + wm.self().vel() ) ).th() - wm.self().body();
            agent->doTurn( angle );
            agent->debugClient().addMessage( "opuciIntDribTurn" );
        }
    }


    const rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
    const rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();

    //agent->doTurnNeck( ( next_ball_pos - next_self_pos ).th() - ( wm.self().neck() + next_self_body ) );
    if( !neckToMate( agent ) )
        Opuci_Neck().execute( agent );

    M_dash_count--;

    if( wm.ball().rposCount() < 1 )
    {
        agent->addSayMessage( new rcsc::BallPlayerMessage( agent->effector().queuedNextBallPos(), 
                                                           agent->effector().queuedNextBallVel(),
                                                           wm.self().unum(),
                                                           agent->effector().queuedNextMyPos(),
                                                           agent->effector().queuedNextMyBody() ) );
    }
    agent->debugClient().addMessage("posCount:%d",wm.ball().posCount());

    return true;
}
/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_IntentionDribble::neckToMate( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::KICK,
                        "%s:%d:Opuci_IntentionDribble::neckToMate"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
 	
    const rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
    const rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
    const rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();
   
    if( wm.ball().posCount() > 1 )
    {
        agent->doTurnNeck( ( next_ball_pos - next_self_pos ).th() - ( wm.self().neck() + next_self_body ) );
    }
    else if( wm.dirCount( wm.self().body() ) > 1 )
    {
        agent->doTurnNeck( - wm.self().neck() );
    }
    else
    {
        int max_count = 0;
        rcsc::AngleDeg search_angle = next_self_body;
        int tmp_count;
        bool flag = false;
        for( int num = 7; num <= 11; num++ )
        {
            if( wm.teammate( num ) )
            {
                const rcsc::AngleDeg target_angle = ( wm.teammate( num )->pos() - next_self_pos ).th();
                tmp_count = wm.teammate( num )->posCount();
                if( num >= 9 )
                {
                    tmp_count *= 1.5;
                }
                if( tmp_count > max_count
                    && ( target_angle - next_self_body ).abs() < 115.0 )
                {
                    max_count = tmp_count;
                    search_angle = target_angle;
                    flag = true;
                }
            }
        }
        if( flag )
            agent->doTurnNeck( search_angle - ( wm.self().neck() + next_self_body ) );
        else
        {
            return false;
        }
    }
    return true;
}
/*-------------------------------------------------------------------*/
/*!

 */
double
Opuci_IntentionDribble::dashPower( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();
    double power = sp.maxDashPower(); 
    

    if( wm.self().stamina() < sp.staminaMax() * sp.effortDecThr() * 1.2
        || wm.self().stamina() < sp.staminaMax() * sp.recoverDecThr() * 1.2 )
    {
        power = 0.0;
    }
    if( wm.ball().pos().x > 20 )
    {
        power = sp.maxDashPower();
    }

//    power = std::min( power, rcsc::ServerParam::i().maxDashPower() );
    agent->debugClient().addMessage( "power:%d", int( power ) );
    return power;
}
